/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Cancellation;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.core.publisher.Operators;

final class MonoCreate<T>
extends Mono<T> {
    final Consumer<MonoSink<T>> callback;

    public MonoCreate(Consumer<MonoSink<T>> callback) {
        this.callback = callback;
    }

    public void subscribe(Subscriber<? super T> s) {
        DefaultMonoSink<T> emitter = new DefaultMonoSink<T>(s);
        s.onSubscribe(emitter);
        try {
            this.callback.accept(emitter);
        }
        catch (Throwable ex) {
            emitter.error(Operators.onOperatorError(ex));
        }
    }

    static final class DefaultMonoSink<T>
    implements MonoSink<T>,
    Subscription {
        final Subscriber<? super T> actual;
        volatile Cancellation cancellation;
        static final AtomicReferenceFieldUpdater<DefaultMonoSink, Cancellation> CANCELLATION = AtomicReferenceFieldUpdater.newUpdater(DefaultMonoSink.class, Cancellation.class, "cancellation");
        volatile int state;
        static final AtomicIntegerFieldUpdater<DefaultMonoSink> STATE = AtomicIntegerFieldUpdater.newUpdater(DefaultMonoSink.class, "state");
        T value;
        static final Cancellation CANCELLED = () -> {};
        static final int NO_REQUEST_NO_VALUE = 0;
        static final int NO_REQUEST_HAS_VALUE = 1;
        static final int HAS_REQUEST_NO_VALUE = 2;
        static final int HAS_REQUEST_HAS_VALUE = 3;

        public DefaultMonoSink(Subscriber<? super T> actual) {
            this.actual = actual;
        }

        @Override
        public void success() {
            if (STATE.getAndSet(this, 3) != 3) {
                this.cancellation = CANCELLED;
                this.actual.onComplete();
            }
        }

        @Override
        public void success(T value) {
            int s;
            do {
                if ((s = this.state) == 3 || s == 1) {
                    return;
                }
                if (s == 2) {
                    if (STATE.compareAndSet(this, s, 3)) {
                        this.cancellation = CANCELLED;
                        this.actual.onNext(value);
                        this.actual.onComplete();
                    }
                    return;
                }
                this.value = value;
            } while (!STATE.compareAndSet(this, s, 1));
        }

        @Override
        public void error(Throwable e) {
            if (STATE.getAndSet(this, 3) != 3) {
                this.cancellation = CANCELLED;
                this.actual.onError(e);
            } else {
                Operators.onErrorDropped(e);
            }
        }

        @Override
        public void setCancellation(Cancellation c) {
            if (!CANCELLATION.compareAndSet(this, null, c) && this.cancellation != CANCELLED && c != null) {
                c.dispose();
            }
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                int s;
                do {
                    if ((s = this.state) == 2 || s == 3) {
                        return;
                    }
                    if (s != 1) continue;
                    if (STATE.compareAndSet(this, s, 3)) {
                        this.cancellation = CANCELLED;
                        this.actual.onNext(this.value);
                        this.actual.onComplete();
                    }
                    return;
                } while (!STATE.compareAndSet(this, s, 2));
                return;
            }
        }

        public void cancel() {
            Cancellation c;
            if (STATE.getAndSet(this, 3) != 3) {
                this.value = null;
            }
            if ((c = this.cancellation) != CANCELLED && (c = CANCELLATION.getAndSet(this, CANCELLED)) != null && c != CANCELLED) {
                c.dispose();
            }
        }
    }
}

