/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Fuseable;
import reactor.core.Receiver;
import reactor.core.publisher.MonoSource;
import reactor.core.publisher.Operators;

final class MonoElementAt<T>
extends MonoSource<T, T>
implements Fuseable {
    final long index;
    final T defaultValue;

    public MonoElementAt(Publisher<? extends T> source, long index) {
        super(source);
        if (index < 0L) {
            throw new IndexOutOfBoundsException("index >= required but it was " + index);
        }
        this.index = index;
        this.defaultValue = null;
    }

    public MonoElementAt(Publisher<? extends T> source, long index, T defaultValue) {
        super(source);
        if (index < 0L) {
            throw new IndexOutOfBoundsException("index >= required but it was " + index);
        }
        this.index = index;
        this.defaultValue = Objects.requireNonNull(defaultValue, "defaultValue");
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        this.source.subscribe(new ElementAtSubscriber<T>(s, this.index, this.defaultValue));
    }

    static final class ElementAtSubscriber<T>
    extends Operators.MonoSubscriber<T, T>
    implements Receiver {
        final T defaultValue;
        long index;
        Subscription s;
        boolean done;

        public ElementAtSubscriber(Subscriber<? super T> actual, long index, T defaultValue) {
            super(actual);
            this.index = index;
            this.defaultValue = defaultValue;
        }

        @Override
        public void request(long n) {
            super.request(n);
            if (n > 0L) {
                this.s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void cancel() {
            super.cancel();
            this.s.cancel();
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            long i = this.index;
            if (i == 0L) {
                this.done = true;
                this.s.cancel();
                this.actual.onNext(t);
                this.actual.onComplete();
                return;
            }
            this.index = i - 1L;
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            if (this.defaultValue != null) {
                this.complete(this.defaultValue);
            } else {
                this.actual.onError(Operators.onOperatorError(new IndexOutOfBoundsException()));
            }
        }

        @Override
        public boolean isTerminated() {
            return this.done;
        }

        @Override
        public Object upstream() {
            return this.s;
        }

        @Override
        public Object connectedInput() {
            return this.defaultValue;
        }
    }
}

