/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Producer;
import reactor.core.Receiver;
import reactor.core.publisher.MonoSource;
import reactor.core.publisher.Operators;

final class MonoIgnoreThen<T>
extends MonoSource<T, T> {
    public MonoIgnoreThen(Publisher<? extends T> source) {
        super(source);
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        this.source.subscribe(new IgnoreElementsSubscriber<T>(s));
    }

    static final class IgnoreElementsSubscriber<T>
    implements Subscriber<T>,
    Producer,
    Subscription,
    Receiver {
        final Subscriber<? super T> actual;
        Subscription s;

        public IgnoreElementsSubscriber(Subscriber<? super T> actual) {
            this.actual = actual;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
        }

        public void onError(Throwable t) {
            this.actual.onError(t);
        }

        public void onComplete() {
            this.actual.onComplete();
        }

        @Override
        public Object downstream() {
            return this.actual;
        }

        public void request(long n) {
        }

        public void cancel() {
            this.s.cancel();
        }

        @Override
        public Object upstream() {
            return this.s;
        }
    }
}

