/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.Fuseable;
import reactor.core.publisher.FluxMap;
import reactor.core.publisher.FluxMapFuseable;
import reactor.core.publisher.MonoSource;

final class MonoMap<T, R>
extends MonoSource<T, R> {
    final Function<? super T, ? extends R> mapper;

    public MonoMap(Publisher<? extends T> source, Function<? super T, ? extends R> mapper) {
        super(source);
        this.mapper = Objects.requireNonNull(mapper, "mapper");
    }

    public Function<? super T, ? extends R> mapper() {
        return this.mapper;
    }

    @Override
    public void subscribe(Subscriber<? super R> s) {
        if (this.source instanceof Fuseable) {
            this.source.subscribe(new FluxMapFuseable.MapFuseableSubscriber<T, R>(s, this.mapper));
            return;
        }
        if (s instanceof Fuseable.ConditionalSubscriber) {
            Fuseable.ConditionalSubscriber cs = (Fuseable.ConditionalSubscriber)s;
            this.source.subscribe(new FluxMap.MapConditionalSubscriber<T, R>(cs, this.mapper));
            return;
        }
        this.source.subscribe(new FluxMap.MapSubscriber<T, R>(s, this.mapper));
    }
}

