/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Fuseable;
import reactor.core.publisher.FluxPeek;
import reactor.core.publisher.FluxPeekFuseable;
import reactor.core.publisher.MonoSource;
import reactor.core.publisher.SignalPeek;

final class MonoPeek<T>
extends MonoSource<T, T>
implements SignalPeek<T> {
    final Consumer<? super Subscription> onSubscribeCall;
    final Consumer<? super T> onNextCall;
    final Consumer<? super Throwable> onErrorCall;
    final Runnable onCompleteCall;
    final Runnable onAfterTerminateCall;
    final LongConsumer onRequestCall;
    final Runnable onCancelCall;

    public MonoPeek(Publisher<? extends T> source, Consumer<? super Subscription> onSubscribeCall, Consumer<? super T> onNextCall, Consumer<? super Throwable> onErrorCall, Runnable onCompleteCall, Runnable onAfterTerminateCall, LongConsumer onRequestCall, Runnable onCancelCall) {
        super(source);
        this.onSubscribeCall = onSubscribeCall;
        this.onNextCall = onNextCall;
        this.onErrorCall = onErrorCall;
        this.onCompleteCall = onCompleteCall;
        this.onAfterTerminateCall = onAfterTerminateCall;
        this.onRequestCall = onRequestCall;
        this.onCancelCall = onCancelCall;
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        if (this.source instanceof Fuseable) {
            if (s instanceof Fuseable.ConditionalSubscriber) {
                this.source.subscribe(new FluxPeekFuseable.PeekFuseableConditionalSubscriber((Fuseable.ConditionalSubscriber)s, this));
                return;
            }
            this.source.subscribe(new FluxPeekFuseable.PeekFuseableSubscriber<T>(s, this));
            return;
        }
        if (s instanceof Fuseable.ConditionalSubscriber) {
            this.source.subscribe(new FluxPeekFuseable.PeekConditionalSubscriber((Fuseable.ConditionalSubscriber)s, this));
            return;
        }
        this.source.subscribe(new FluxPeek.PeekSubscriber<T>(s, this));
    }

    @Override
    public Consumer<? super Subscription> onSubscribeCall() {
        return this.onSubscribeCall;
    }

    @Override
    public Consumer<? super T> onNextCall() {
        return this.onNextCall;
    }

    @Override
    public Consumer<? super Throwable> onErrorCall() {
        return this.onErrorCall;
    }

    @Override
    public Runnable onCompleteCall() {
        return this.onCompleteCall;
    }

    @Override
    public Runnable onAfterTerminateCall() {
        return this.onAfterTerminateCall;
    }

    @Override
    public LongConsumer onRequestCall() {
        return this.onRequestCall;
    }

    @Override
    public Runnable onCancelCall() {
        return this.onCancelCall;
    }

    static final class AfterSuccess<T>
    implements Consumer<T>,
    Runnable {
        final BiConsumer<? super T, Throwable> biConsumer;
        final Consumer<Throwable> errorConsumer = e -> {
            this.error = e;
        };
        T value = null;
        Throwable error = null;

        public AfterSuccess(BiConsumer<? super T, Throwable> biConsumer) {
            this.biConsumer = Objects.requireNonNull(biConsumer, "AfterTerminate");
        }

        @Override
        public void run() {
            this.biConsumer.accept(this.value, this.error);
        }

        @Override
        public void accept(T t) {
            this.value = t;
        }
    }

    static final class OnSuccess<T>
    implements Consumer<T>,
    Runnable {
        final Consumer<? super T> consumer;
        boolean value = false;

        public OnSuccess(Consumer<? super T> consumer) {
            this.consumer = Objects.requireNonNull(consumer, "OnSuccess");
        }

        @Override
        public void run() {
            if (!this.value) {
                this.consumer.accept(null);
            }
        }

        @Override
        public void accept(T t) {
            this.value = true;
            this.consumer.accept(t);
        }
    }

    static final class OnTerminate<T>
    implements Consumer<T>,
    Runnable {
        final BiConsumer<? super T, Throwable> biConsumer;
        boolean value = false;

        public OnTerminate(BiConsumer<? super T, Throwable> biConsumer) {
            this.biConsumer = Objects.requireNonNull(biConsumer, "OnTerminate");
        }

        @Override
        public void run() {
            if (!this.value) {
                this.biConsumer.accept(null, null);
            }
        }

        @Override
        public void accept(T t) {
            this.value = true;
            this.biConsumer.accept(t, null);
        }
    }
}

