/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Cancellation;
import reactor.core.publisher.MonoSource;
import reactor.core.publisher.Operators;
import reactor.core.scheduler.Scheduler;

final class MonoPublishOn<T>
extends MonoSource<T, T> {
    final Scheduler scheduler;

    public MonoPublishOn(Publisher<? extends T> source, Scheduler scheduler) {
        super(source);
        this.scheduler = scheduler;
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        this.source.subscribe(new MonoPublishOnSubscriber<T>(s, this.scheduler));
    }

    static final class MonoPublishOnSubscriber<T>
    implements Subscriber<T>,
    Subscription,
    Runnable {
        final Subscriber<? super T> actual;
        final Scheduler scheduler;
        Subscription s;
        volatile Cancellation future;
        static final AtomicReferenceFieldUpdater<MonoPublishOnSubscriber, Cancellation> FUTURE = AtomicReferenceFieldUpdater.newUpdater(MonoPublishOnSubscriber.class, Cancellation.class, "future");
        static final Cancellation CANCELLED = () -> {};
        T value;
        Throwable error;

        public MonoPublishOnSubscriber(Subscriber<? super T> actual, Scheduler scheduler) {
            this.actual = actual;
            this.scheduler = scheduler;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            this.value = t;
            this.schedule();
        }

        public void onError(Throwable t) {
            this.error = t;
            this.schedule();
        }

        public void onComplete() {
            if (this.value == null) {
                this.schedule();
            }
        }

        void schedule() {
            Cancellation c;
            if (this.future == null && !FUTURE.compareAndSet(this, null, c = this.scheduler.schedule(this))) {
                c.dispose();
            }
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            Cancellation c = this.future;
            if (c != CANCELLED && (c = FUTURE.getAndSet(this, CANCELLED)) != null && c != CANCELLED) {
                c.dispose();
            }
            this.s.cancel();
        }

        @Override
        public void run() {
            if (this.future == CANCELLED) {
                return;
            }
            T v = this.value;
            this.value = null;
            if (v != null) {
                this.actual.onNext(v);
            }
            if (this.future == CANCELLED) {
                return;
            }
            Throwable e = this.error;
            if (e != null) {
                this.actual.onError(e);
            } else {
                this.actual.onComplete();
            }
        }
    }
}

