/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.Callable;
import org.reactivestreams.Subscriber;
import reactor.core.Cancellation;
import reactor.core.Fuseable;
import reactor.core.publisher.FluxSubscribeOnCallable;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;

final class MonoSubscribeOnCallable<T>
extends Mono<T>
implements Fuseable {
    final Callable<? extends T> callable;
    final Scheduler scheduler;

    public MonoSubscribeOnCallable(Callable<? extends T> callable, Scheduler scheduler) {
        this.callable = Objects.requireNonNull(callable, "callable");
        this.scheduler = Objects.requireNonNull(scheduler, "scheduler");
    }

    public void subscribe(Subscriber<? super T> s) {
        MonoSubscribeOnCallable.subscribe(this.callable, s, this.scheduler);
    }

    public static <T> void subscribe(Callable<T> callable, Subscriber<? super T> s, Scheduler scheduler) {
        FluxSubscribeOnCallable.CallableSubscribeOnSubscription<T> parent = new FluxSubscribeOnCallable.CallableSubscribeOnSubscription<T>(s, callable, scheduler);
        s.onSubscribe(parent);
        Cancellation f = scheduler.schedule(parent);
        parent.setMainFuture(f);
    }
}

