/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxTimeout;
import reactor.core.publisher.MonoSource;
import reactor.core.publisher.Operators;

final class MonoTimeout<T, U, V>
extends MonoSource<T, T> {
    final Publisher<U> firstTimeout;
    final Publisher<? extends T> other;
    static final Function NEVER = e -> Flux.never();

    public MonoTimeout(Publisher<? extends T> source, Publisher<U> firstTimeout) {
        super(source);
        this.firstTimeout = Objects.requireNonNull(firstTimeout, "firstTimeout");
        this.other = null;
    }

    public MonoTimeout(Publisher<? extends T> source, Publisher<U> firstTimeout, Publisher<? extends T> other) {
        super(source);
        this.firstTimeout = Objects.requireNonNull(firstTimeout, "firstTimeout");
        this.other = Objects.requireNonNull(other, "other");
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        Subscriber<? super T> serial = Operators.serialize(s);
        FluxTimeout.TimeoutMainSubscriber main = new FluxTimeout.TimeoutMainSubscriber(serial, NEVER, this.other);
        serial.onSubscribe(main);
        FluxTimeout.TimeoutTimeoutSubscriber ts = new FluxTimeout.TimeoutTimeoutSubscriber(main, 0L);
        main.setTimeout(ts);
        this.firstTimeout.subscribe((Subscriber)ts);
        this.source.subscribe(main);
    }
}

