/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.publisher.FluxZip;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;

final class MonoWhen<T, R>
extends Mono<R> {
    final boolean delayError;
    final Publisher<?>[] sources;
    final Iterable<? extends Publisher<?>> sourcesIterable;
    final Function<? super Object[], ? extends R> zipper;

    public <U> MonoWhen(boolean delayError, Publisher<? extends T> p1, Publisher<? extends U> p2, BiFunction<? super T, ? super U, ? extends R> zipper2) {
        this(delayError, new FluxZip.PairwiseZipper(new BiFunction[]{Objects.requireNonNull(zipper2, "zipper2")}), Objects.requireNonNull(p1, "p1"), Objects.requireNonNull(p2, "p2"));
    }

    public MonoWhen(boolean delayError, Function<? super Object[], ? extends R> zipper, Publisher<?> ... sources) {
        this.delayError = delayError;
        this.zipper = Objects.requireNonNull(zipper, "zipper");
        this.sources = Objects.requireNonNull(sources, "sources");
        this.sourcesIterable = null;
    }

    public MonoWhen(boolean delayError, Function<? super Object[], ? extends R> zipper, Iterable<? extends Publisher<?>> sourcesIterable) {
        this.delayError = delayError;
        this.zipper = Objects.requireNonNull(zipper, "zipper");
        this.sources = null;
        this.sourcesIterable = Objects.requireNonNull(sourcesIterable, "sourcesIterable");
    }

    public Mono<R> whenAdditionalSource(Publisher source, BiFunction zipper) {
        Publisher<?>[] oldSources = this.sources;
        if (oldSources != null && this.zipper instanceof FluxZip.PairwiseZipper) {
            int oldLen = oldSources.length;
            Publisher[] newSources = new Publisher[oldLen + 1];
            System.arraycopy(oldSources, 0, newSources, 0, oldLen);
            newSources[oldLen] = source;
            FluxZip.PairwiseZipper z = ((FluxZip.PairwiseZipper)this.zipper).then(zipper);
            return new MonoWhen<T, R>(this.delayError, z, newSources);
        }
        return null;
    }

    public void subscribe(Subscriber<? super R> s) {
        Publisher<?>[] a;
        int n = 0;
        if (this.sources != null) {
            a = this.sources;
            n = a.length;
        } else {
            a = new Mono[8];
            for (Publisher<?> m : this.sourcesIterable) {
                if (n == a.length) {
                    Publisher[] b = new Publisher[n + (n >> 2)];
                    System.arraycopy(a, 0, b, 0, n);
                    a = b;
                }
                a[n++] = m;
            }
        }
        if (n == 0) {
            Operators.complete(s);
            return;
        }
        MonoWhenCoordinator<R> parent = new MonoWhenCoordinator<R>(s, n, this.delayError, this.zipper);
        s.onSubscribe(parent);
        parent.subscribe(a);
    }

    static final class MonoWhenSubscriber<R>
    implements Subscriber<Object> {
        final MonoWhenCoordinator<R> parent;
        volatile Subscription s;
        static final AtomicReferenceFieldUpdater<MonoWhenSubscriber, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(MonoWhenSubscriber.class, Subscription.class, "s");
        Object value;
        Throwable error;

        public MonoWhenSubscriber(MonoWhenCoordinator<R> parent) {
            this.parent = parent;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.setOnce(S, this, s)) {
                s.request(Long.MAX_VALUE);
            } else {
                s.cancel();
            }
        }

        public void onNext(Object t) {
            if (this.value == null) {
                this.value = t;
                this.parent.signal();
            }
        }

        public void onError(Throwable t) {
            this.error = t;
            this.parent.signalError(t);
        }

        public void onComplete() {
            if (this.value == null) {
                this.parent.signal();
            }
        }

        void cancel() {
            Operators.terminate(S, this);
        }
    }

    static final class MonoWhenCoordinator<R>
    extends Operators.MonoSubscriber<Object, R>
    implements Subscription {
        final MonoWhenSubscriber<R>[] subscribers;
        final boolean delayError;
        final Function<? super Object[], ? extends R> zipper;
        volatile int done;
        static final AtomicIntegerFieldUpdater<MonoWhenCoordinator> DONE = AtomicIntegerFieldUpdater.newUpdater(MonoWhenCoordinator.class, "done");

        public MonoWhenCoordinator(Subscriber<? super R> subscriber, int n, boolean delayError, Function<? super Object[], ? extends R> zipper) {
            super(subscriber);
            this.delayError = delayError;
            this.zipper = zipper;
            this.subscribers = new MonoWhenSubscriber[n];
            for (int i = 0; i < n; ++i) {
                this.subscribers[i] = new MonoWhenSubscriber(this);
            }
        }

        void subscribe(Publisher<?>[] sources) {
            MonoWhenSubscriber<R>[] a = this.subscribers;
            for (int i = 0; i < a.length; ++i) {
                sources[i].subscribe(a[i]);
            }
        }

        void signalError(Throwable t) {
            if (this.delayError) {
                this.signal();
            } else {
                int n = this.subscribers.length;
                if (DONE.getAndSet(this, n) != n) {
                    this.cancel();
                    this.actual.onError(t);
                }
            }
        }

        void signal() {
            MonoWhenSubscriber<R>[] a = this.subscribers;
            int n = a.length;
            if (DONE.incrementAndGet(this) != n) {
                return;
            }
            Object[] o = new Object[n];
            Throwable error = null;
            Throwable compositeError = null;
            boolean hasEmpty = false;
            for (int i = 0; i < a.length; ++i) {
                MonoWhenSubscriber<R> m = a[i];
                Object v = m.value;
                if (v != null) {
                    o[i] = v;
                    continue;
                }
                Throwable e = m.error;
                if (e != null) {
                    if (compositeError != null) {
                        compositeError.addSuppressed(e);
                        continue;
                    }
                    if (error != null) {
                        compositeError = new Throwable("Multiple errors");
                        compositeError.addSuppressed(error);
                        compositeError.addSuppressed(e);
                        continue;
                    }
                    error = e;
                    continue;
                }
                hasEmpty = true;
            }
            if (compositeError != null) {
                this.actual.onError(compositeError);
            } else if (error != null) {
                this.actual.onError(error);
            } else if (hasEmpty || this.zipper == Mono.VOID_FUNCTION) {
                this.actual.onComplete();
            } else {
                R r;
                try {
                    r = this.zipper.apply((Object[])o);
                }
                catch (Throwable t) {
                    this.actual.onError(Operators.onOperatorError(null, t, o));
                    return;
                }
                if (r == null) {
                    this.actual.onError(Operators.onOperatorError(null, new NullPointerException("zipper produced a null value"), o));
                    return;
                }
                this.complete(r);
            }
        }

        @Override
        public void cancel() {
            if (!this.isCancelled()) {
                super.cancel();
                for (MonoWhenSubscriber<R> ms : this.subscribers) {
                    ms.cancel();
                }
            }
        }
    }
}

