/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.Queue;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.FluxConcatMap;
import reactor.core.publisher.ParallelFlux;

final class ParallelUnorderedConcatMap<T, R>
extends ParallelFlux<R> {
    final ParallelFlux<T> source;
    final Function<? super T, ? extends Publisher<? extends R>> mapper;
    final Supplier<? extends Queue<T>> queueSupplier;
    final int prefetch;
    final FluxConcatMap.ErrorMode errorMode;

    public ParallelUnorderedConcatMap(ParallelFlux<T> source, Function<? super T, ? extends Publisher<? extends R>> mapper, Supplier<? extends Queue<T>> queueSupplier, int prefetch, FluxConcatMap.ErrorMode errorMode) {
        this.source = source;
        this.mapper = Objects.requireNonNull(mapper, "mapper");
        this.queueSupplier = Objects.requireNonNull(queueSupplier, "queueSupplier");
        this.prefetch = prefetch;
        this.errorMode = Objects.requireNonNull(errorMode, "errorMode");
    }

    @Override
    public boolean isOrdered() {
        return false;
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    @Override
    public void subscribe(Subscriber<? super R>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n = subscribers.length;
        Subscriber[] parents = new Subscriber[n];
        for (int i = 0; i < n; ++i) {
            parents[i] = FluxConcatMap.subscriber(subscribers[i], this.mapper, this.queueSupplier, this.prefetch, this.errorMode);
        }
        this.source.subscribe(parents);
    }
}

