/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.function.Function;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.FluxMap;
import reactor.core.publisher.ParallelFlux;

final class ParallelUnorderedMap<T, R>
extends ParallelFlux<R> {
    final ParallelFlux<T> source;
    final Function<? super T, ? extends R> mapper;

    public ParallelUnorderedMap(ParallelFlux<T> source, Function<? super T, ? extends R> mapper) {
        this.source = source;
        this.mapper = mapper;
    }

    @Override
    public void subscribe(Subscriber<? super R>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n = subscribers.length;
        Subscriber[] parents = new Subscriber[n];
        for (int i = 0; i < n; ++i) {
            parents[i] = new FluxMap.MapSubscriber<T, R>(subscribers[i], this.mapper);
        }
        this.source.subscribe(parents);
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    @Override
    public boolean isOrdered() {
        return false;
    }
}

