/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import reactor.core.publisher.RingBuffer;
import reactor.core.publisher.SequenceGroups;
import reactor.util.concurrent.WaitStrategy;

abstract class RingBufferProducer {
    static final AtomicReferenceFieldUpdater<RingBufferProducer, RingBuffer.Sequence[]> SEQUENCE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(RingBufferProducer.class, RingBuffer.Sequence[].class, "gatingSequences");
    final Runnable spinObserver;
    final int bufferSize;
    final WaitStrategy waitStrategy;
    final RingBuffer.Sequence cursor = RingBuffer.newSequence(-1L);
    volatile RingBuffer.Sequence[] gatingSequences = new RingBuffer.Sequence[0];

    public RingBufferProducer(int bufferSize, WaitStrategy waitStrategy, Runnable spinObserver) {
        if (bufferSize < 1) {
            throw new IllegalArgumentException("bufferSize must not be less than 1");
        }
        this.spinObserver = spinObserver;
        this.bufferSize = bufferSize;
        this.waitStrategy = waitStrategy;
    }

    public final long getCursor() {
        return this.cursor.getAsLong();
    }

    public final RingBuffer.Sequence getSequence() {
        return this.cursor;
    }

    public final int getBufferSize() {
        return this.bufferSize;
    }

    public final void addGatingSequence(RingBuffer.Sequence gatingSequence) {
        SequenceGroups.addSequence(this, SEQUENCE_UPDATER, gatingSequence);
    }

    public boolean removeGatingSequence(RingBuffer.Sequence sequence) {
        return SequenceGroups.removeSequence(this, SEQUENCE_UPDATER, sequence);
    }

    public long getMinimumSequence(RingBuffer.Sequence excludeSequence) {
        return RingBuffer.getMinimumSequence(excludeSequence, this.gatingSequences, this.cursor.getAsLong());
    }

    public RingBuffer.Reader newBarrier() {
        return new RingBuffer.Reader(this, this.waitStrategy, this.cursor);
    }

    public abstract boolean isAvailable(long var1);

    public abstract long getHighestPublishedSequence(long var1, long var3);

    public abstract long remainingCapacity();

    public abstract long getPending();

    public abstract long next();

    public abstract long next(int var1);

    public abstract void publish(long var1);

    public abstract void publish(long var1, long var3);

    public RingBuffer.Sequence[] getGatingSequences() {
        return this.gatingSequences;
    }
}

