/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Producer;
import reactor.core.Receiver;
import reactor.core.Trackable;
import reactor.core.publisher.Operators;

final class SerializedSubscriber<T>
implements Subscriber<T>,
Subscription,
Receiver,
Producer,
Trackable {
    final Subscriber<? super T> actual;
    boolean emitting;
    boolean missed;
    volatile boolean done;
    volatile boolean cancelled;
    LinkedArrayNode<T> head;
    LinkedArrayNode<T> tail;
    Throwable error;
    Subscription s;

    public SerializedSubscriber(Subscriber<? super T> actual) {
        this.actual = actual;
    }

    public void onSubscribe(Subscription s) {
        if (Operators.validate(this.s, s)) {
            this.s = s;
            this.actual.onSubscribe((Subscription)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNext(T t) {
        if (this.isCancelled() || this.isTerminated()) {
            return;
        }
        SerializedSubscriber serializedSubscriber = this;
        synchronized (serializedSubscriber) {
            if (this.isCancelled() || this.isTerminated()) {
                return;
            }
            if (this.emitting) {
                this.serAdd(t);
                this.missed = true;
                return;
            }
            this.emitting = true;
        }
        this.actual.onNext(t);
        this.serDrainLoop(this.actual);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(Throwable t) {
        if (this.isCancelled() || this.isTerminated()) {
            return;
        }
        SerializedSubscriber serializedSubscriber = this;
        synchronized (serializedSubscriber) {
            if (this.isCancelled() || this.isTerminated()) {
                return;
            }
            this.done = true;
            this.error = t;
            if (this.emitting) {
                this.missed = true;
                return;
            }
        }
        this.actual.onError(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onComplete() {
        if (this.isCancelled() || this.isTerminated()) {
            return;
        }
        SerializedSubscriber serializedSubscriber = this;
        synchronized (serializedSubscriber) {
            if (this.isCancelled() || this.isTerminated()) {
                return;
            }
            this.done = true;
            if (this.emitting) {
                this.missed = true;
                return;
            }
        }
        this.actual.onComplete();
    }

    public void request(long n) {
        this.s.request(n);
    }

    public void cancel() {
        this.cancelled = true;
        this.s.cancel();
    }

    void serAdd(T value) {
        LinkedArrayNode<T> t = this.tail;
        if (t == null) {
            t = new LinkedArrayNode<T>(value);
            this.head = t;
            this.tail = t;
        } else if (t.count == 16) {
            LinkedArrayNode<T> n = new LinkedArrayNode<T>(value);
            t.next = n;
            this.tail = n;
        } else {
            t.array[t.count++] = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void serDrainLoop(Subscriber<? super T> actual) {
        boolean d;
        do {
            LinkedArrayNode<T> n;
            Throwable e;
            if (this.isCancelled()) {
                return;
            }
            SerializedSubscriber serializedSubscriber = this;
            synchronized (serializedSubscriber) {
                if (this.isCancelled()) {
                    return;
                }
                if (!this.missed) {
                    this.emitting = false;
                    return;
                }
                this.missed = false;
                d = this.isTerminated();
                e = this.getError();
                n = this.head;
                this.head = null;
                this.tail = null;
            }
            while (n != null) {
                T[] arr = n.array;
                int c = n.count;
                for (int i = 0; i < c; ++i) {
                    if (this.isCancelled()) {
                        return;
                    }
                    actual.onNext(arr[i]);
                }
                n = n.next;
            }
            if (this.isCancelled()) {
                return;
            }
            if (e == null) continue;
            actual.onError(e);
            return;
        } while (!d);
        actual.onComplete();
    }

    public Subscriber<? super T> downstream() {
        return this.actual;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isTerminated() {
        return this.done;
    }

    @Override
    public Throwable getError() {
        return this.error;
    }

    @Override
    public boolean isStarted() {
        return this.s != null || !this.cancelled;
    }

    public Subscription upstream() {
        return this.s;
    }

    @Override
    public long getPending() {
        LinkedArrayNode<T> node = this.tail;
        if (node != null) {
            return node.count;
        }
        return 0L;
    }

    @Override
    public long getCapacity() {
        return 16L;
    }

    static final class LinkedArrayNode<T> {
        static final int DEFAULT_CAPACITY = 16;
        final T[] array = new Object[16];
        int count;
        LinkedArrayNode<T> next;

        public LinkedArrayNode(T value) {
            this.array[0] = value;
            this.count = 1;
        }
    }
}

