/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Disposable;
import reactor.core.Exceptions;
import reactor.core.Receiver;
import reactor.core.Trackable;
import reactor.core.publisher.Operators;
import reactor.core.publisher.SignalType;

public abstract class BaseSubscriber<T>
implements Subscriber<T>,
Subscription,
Trackable,
Receiver,
Disposable {
    volatile Subscription subscription;
    static AtomicReferenceFieldUpdater<BaseSubscriber, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(BaseSubscriber.class, Subscription.class, "subscription");

    public Subscription upstream() {
        return this.subscription;
    }

    @Override
    public boolean isStarted() {
        return this.subscription != null;
    }

    @Override
    public boolean isDisposed() {
        return this.subscription == Operators.cancelledSubscription();
    }

    @Override
    public void dispose() {
        S.lazySet(this, Operators.cancelledSubscription());
    }

    protected abstract void hookOnSubscribe(Subscription var1);

    protected abstract void hookOnNext(T var1);

    protected void hookOnComplete() {
    }

    protected void hookOnError(Throwable throwable) {
        throw Exceptions.errorCallbackNotImplemented(throwable);
    }

    protected void hookOnCancel() {
    }

    protected void hookFinally(SignalType type) {
    }

    public final void onSubscribe(Subscription s) {
        if (Operators.setOnce(S, this, s)) {
            try {
                this.hookOnSubscribe(s);
            }
            catch (Throwable throwable) {
                this.onError(Operators.onOperatorError(s, throwable));
            }
        }
    }

    public final void onNext(T value) {
        if (value == null) {
            throw Exceptions.argumentIsNullException();
        }
        try {
            this.hookOnNext(value);
        }
        catch (Throwable throwable) {
            this.onError(Operators.onOperatorError(this.subscription, throwable, value));
        }
    }

    public final void onError(Throwable t) {
        if (S.getAndSet(this, Operators.cancelledSubscription()) == Operators.cancelledSubscription()) {
            Operators.onErrorDropped(t);
            return;
        }
        if (t == null) {
            throw Exceptions.argumentIsNullException();
        }
        try {
            this.hookOnError(t);
        }
        catch (Throwable e) {
            e.addSuppressed(t);
            Operators.onErrorDropped(e);
        }
        finally {
            this.safeHookFinally(SignalType.ON_ERROR);
        }
    }

    public final void onComplete() {
        if (S.getAndSet(this, Operators.cancelledSubscription()) != Operators.cancelledSubscription()) {
            try {
                this.hookOnComplete();
            }
            catch (Throwable throwable) {
                this.hookOnError(Operators.onOperatorError(throwable));
            }
            finally {
                this.safeHookFinally(SignalType.ON_COMPLETE);
            }
        }
    }

    public final void request(long n) {
        try {
            Operators.checkRequest(n);
            Subscription s = this.subscription;
            if (s != null) {
                s.request(n);
            }
        }
        catch (Throwable throwable) {
            this.onError(Operators.onOperatorError(throwable));
        }
    }

    public final void cancel() {
        if (Operators.terminate(S, this)) {
            try {
                this.hookOnCancel();
            }
            catch (Throwable throwable) {
                this.hookOnError(Operators.onOperatorError(this.subscription, throwable));
            }
            finally {
                this.safeHookFinally(SignalType.CANCEL);
            }
        }
    }

    void safeHookFinally(SignalType type) {
        try {
            this.hookFinally(type);
        }
        catch (Throwable finallyFailure) {
            Operators.onErrorDropped(finallyFailure);
        }
    }

    @Override
    public boolean isTerminated() {
        return null != this.subscription && this.subscription instanceof Trackable && ((Trackable)this.subscription).isTerminated();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

