/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Disposable;
import reactor.core.Exceptions;
import reactor.core.Receiver;
import reactor.core.Trackable;

abstract class BlockingSingleSubscriber<T>
extends CountDownLatch
implements Subscriber<T>,
Disposable,
Trackable,
Receiver {
    T value;
    Throwable error;
    Subscription s;
    volatile boolean cancelled;

    public BlockingSingleSubscriber() {
        super(1);
    }

    public final void onSubscribe(Subscription s) {
        this.s = s;
        if (!this.cancelled) {
            s.request(Long.MAX_VALUE);
            if (this.cancelled) {
                this.s = null;
                s.cancel();
            }
        }
    }

    public final void onComplete() {
        this.countDown();
    }

    @Override
    public final void dispose() {
        this.cancelled = true;
        Subscription s = this.s;
        if (s != null) {
            this.s = null;
            s.cancel();
        }
    }

    public final T blockingGet() {
        Throwable e;
        if (this.getCount() != 0L) {
            try {
                this.await();
            }
            catch (InterruptedException ex) {
                this.dispose();
                throw Exceptions.propagate(ex);
            }
        }
        if ((e = this.error) != null) {
            throw Exceptions.propagate(e);
        }
        return this.value;
    }

    public final T blockingGet(long timeout, TimeUnit unit) {
        Throwable e;
        if (this.getCount() != 0L) {
            try {
                if (!this.await(timeout, unit)) {
                    this.dispose();
                    throw new IllegalStateException("Timeout on blocking read");
                }
            }
            catch (InterruptedException ex) {
                this.dispose();
                throw Exceptions.propagate(ex);
            }
        }
        if ((e = this.error) != null) {
            throw Exceptions.propagate(e);
        }
        return this.value;
    }

    @Override
    public Object upstream() {
        return this.s;
    }

    @Override
    public boolean isTerminated() {
        return this.getCount() == 0L;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isStarted() {
        return this.s != null;
    }

    @Override
    public Throwable getError() {
        return this.error;
    }

    @Override
    public long getPending() {
        return this.getCount();
    }
}

