/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.Producer;
import reactor.core.Receiver;
import reactor.core.Trackable;
import reactor.core.publisher.FluxProcessor;

final class DelegateProcessor<IN, OUT>
extends FluxProcessor<IN, OUT>
implements Producer,
Receiver {
    private final Publisher<OUT> downstream;
    private final Subscriber<IN> upstream;
    Subscription upstreamSubscription;

    public DelegateProcessor(Publisher<OUT> downstream, Subscriber<IN> upstream) {
        this.downstream = Objects.requireNonNull(downstream, "Downstream must not be null");
        this.upstream = Objects.requireNonNull(upstream, "Upstream must not be null");
    }

    public Subscriber<? super IN> downstream() {
        return this.upstream;
    }

    @Override
    public long getCapacity() {
        return Trackable.class.isAssignableFrom(this.upstream.getClass()) ? ((Trackable)this.upstream).getCapacity() : Long.MAX_VALUE;
    }

    public void onComplete() {
        this.upstream.onComplete();
    }

    public void onError(Throwable t) {
        this.upstream.onError(t);
    }

    public void onNext(IN in) {
        this.upstream.onNext(in);
    }

    public void onSubscribe(Subscription s) {
        this.upstream.onSubscribe(s);
    }

    @Override
    public void subscribe(Subscriber<? super OUT> s) {
        if (s == null) {
            throw Exceptions.argumentIsNullException();
        }
        this.downstream.subscribe(s);
    }

    public Subscription upstream() {
        return this.upstreamSubscription;
    }
}

