/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Cancellation;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.Operators;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.TimedScheduler;

abstract class FluxBatch<T, V>
extends FluxSource<T, V> {
    final int batchSize;
    final long timespan;
    final TimedScheduler timer;

    public FluxBatch(Publisher<T> source, int batchSize, long timespan, TimedScheduler timer) {
        super(source);
        if (timespan <= 0L) {
            throw new IllegalArgumentException("Timeout period must be strictly positive");
        }
        if (batchSize <= 0) {
            throw new IllegalArgumentException("BatchSize period must be strictly positive");
        }
        this.timer = Objects.requireNonNull(timer, "Timer");
        this.timespan = timespan;
        this.batchSize = batchSize;
    }

    final Subscriber<? super V> prepareSub(Subscriber<? super V> actual) {
        return Operators.serialize(actual);
    }

    static abstract class BatchAction<T, V>
    extends Operators.SubscriberAdapter<T, V> {
        static final Exception FAILED_SATE = new RuntimeException("Failed Subscriber"){
            private static final long serialVersionUID = 7503907754069414227L;

            @Override
            public synchronized Throwable fillInStackTrace() {
                return null;
            }
        };
        static final int NOT_TERMINATED = 0;
        static final int TERMINATED_WITH_SUCCESS = 1;
        static final int TERMINATED_WITH_ERROR = 2;
        static final int TERMINATED_WITH_CANCEL = 3;
        final boolean first;
        final int batchSize;
        final long timespan;
        final TimedScheduler.TimedWorker timer;
        final Runnable flushTask;
        volatile int terminated = 0;
        static final AtomicIntegerFieldUpdater<BatchAction> TERMINATED = AtomicIntegerFieldUpdater.newUpdater(BatchAction.class, "terminated");
        volatile long requested;
        static final AtomicLongFieldUpdater<BatchAction> REQUESTED = AtomicLongFieldUpdater.newUpdater(BatchAction.class, "requested");
        volatile int index = 0;
        static final AtomicIntegerFieldUpdater<BatchAction> INDEX = AtomicIntegerFieldUpdater.newUpdater(BatchAction.class, "index");
        volatile Cancellation timespanRegistration;

        public BatchAction(Subscriber<? super V> actual, int batchSize, boolean first, long timespan, TimedScheduler.TimedWorker timer) {
            super(actual);
            this.timespan = timespan;
            this.timer = timer;
            this.flushTask = () -> {
                if (!this.isTerminated()) {
                    int index;
                    do {
                        if ((index = this.index) != 0) continue;
                        return;
                    } while (!INDEX.compareAndSet(this, index, 0));
                    this.flushCallback(null);
                }
            };
            this.first = first;
            this.batchSize = batchSize;
        }

        void doRequested(long before, long n) {
            if (this.isTerminated()) {
                return;
            }
            if (this.batchSize == Integer.MAX_VALUE || n == Long.MAX_VALUE) {
                this.requestMore(Long.MAX_VALUE);
            } else {
                this.requestMore(Operators.multiplyCap(n, this.batchSize));
            }
        }

        void nextCallback(T event) {
        }

        void flushCallback(T event) {
        }

        void firstCallback(T event) {
        }

        @Override
        protected void doNext(T value) {
            int index;
            while (!INDEX.compareAndSet(this, (index = this.index + 1) - 1, index)) {
            }
            if (index == 1) {
                this.timespanRegistration = this.timer.schedule(this.flushTask, this.timespan, TimeUnit.MILLISECONDS);
                if (this.timespanRegistration == Scheduler.REJECTED) {
                    throw Operators.onRejectedExecution(this, null, value);
                }
                if (this.first) {
                    this.firstCallback(value);
                }
            }
            this.nextCallback(value);
            if (this.index % this.batchSize == 0) {
                this.index = 0;
                if (this.timespanRegistration != null) {
                    this.timespanRegistration.dispose();
                    this.timespanRegistration = null;
                }
                this.flushCallback(value);
            }
        }

        void checkedComplete() {
            try {
                this.flushCallback(null);
            }
            finally {
                this.subscriber.onComplete();
            }
        }

        @Override
        public boolean isTerminated() {
            return this.terminated != 0;
        }

        public final boolean isCompleted() {
            return this.terminated == 1;
        }

        public final boolean isFailed() {
            return this.terminated == 2;
        }

        @Override
        public final boolean isCancelled() {
            return this.terminated == 3;
        }

        @Override
        public final long requestedFromDownstream() {
            return this.requested;
        }

        @Override
        protected void doRequest(long n) {
            this.doRequested(Operators.getAndAddCap(REQUESTED, this, n), n);
        }

        final void requestMore(long n) {
            Subscription s = this.subscription;
            if (s != null) {
                s.request(n);
            }
        }

        @Override
        protected void doComplete() {
            if (TERMINATED.compareAndSet(this, 0, 1)) {
                this.checkedComplete();
                this.doTerminate();
            }
        }

        @Override
        protected void doError(Throwable throwable) {
            if (TERMINATED.compareAndSet(this, 0, 2)) {
                this.checkedError(throwable);
                this.doTerminate();
            }
        }

        void checkedError(Throwable throwable) {
            this.subscriber.onError(throwable);
        }

        @Override
        protected void doCancel() {
            if (TERMINATED.compareAndSet(this, 0, 3)) {
                this.checkedCancel();
                this.doTerminate();
            }
        }

        void checkedCancel() {
            super.doCancel();
        }

        void doTerminate() {
            this.timer.dispose();
        }

        @Override
        public Throwable getError() {
            return this.isFailed() ? FAILED_SATE : null;
        }

        @Override
        public String toString() {
            return super.toString() + "{" + (this.timer != null ? "timed - " + this.timespan + " ms" : "") + " batchSize=" + this.index + "/" + this.batchSize + " [" + (int)((float)this.index / (float)this.batchSize * 100.0f) + "%]";
        }
    }
}

