/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.concurrent.Callable;
import org.reactivestreams.Subscriber;
import reactor.core.Fuseable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Operators;

final class FluxCallable<T>
extends Flux<T>
implements Callable<T>,
Fuseable {
    final Callable<T> callable;

    FluxCallable(Callable<T> callable) {
        this.callable = callable;
    }

    public void subscribe(Subscriber<? super T> s) {
        T v;
        Operators.MonoSubscriber wrapper = new Operators.MonoSubscriber(s);
        s.onSubscribe(wrapper);
        try {
            v = this.callable.call();
        }
        catch (Throwable ex) {
            s.onError(Operators.onOperatorError(ex));
            return;
        }
        if (v == null) {
            s.onError(Operators.onOperatorError(new NullPointerException("The callable returned null")));
            return;
        }
        wrapper.complete(v);
    }

    @Override
    public T call() throws Exception {
        return this.callable.call();
    }
}

