/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Disposable;
import reactor.core.Exceptions;
import reactor.core.MultiProducer;
import reactor.core.MultiReceiver;
import reactor.core.Producer;
import reactor.core.Receiver;
import reactor.core.Trackable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.Operators;
import reactor.core.publisher.UnicastProcessor;
import reactor.util.concurrent.OpenHashSet;

final class FluxGroupJoin<TLeft, TRight, TLeftEnd, TRightEnd, R>
extends FluxSource<TLeft, R> {
    final Publisher<? extends TRight> other;
    final Function<? super TLeft, ? extends Publisher<TLeftEnd>> leftEnd;
    final Function<? super TRight, ? extends Publisher<TRightEnd>> rightEnd;
    final BiFunction<? super TLeft, ? super Flux<TRight>, ? extends R> resultSelector;
    final Supplier<? extends Queue<Object>> queueSupplier;
    final Supplier<? extends Queue<TRight>> processorQueueSupplier;

    public FluxGroupJoin(Publisher<TLeft> source, Publisher<? extends TRight> other, Function<? super TLeft, ? extends Publisher<TLeftEnd>> leftEnd, Function<? super TRight, ? extends Publisher<TRightEnd>> rightEnd, BiFunction<? super TLeft, ? super Flux<TRight>, ? extends R> resultSelector, Supplier<? extends Queue<Object>> queueSupplier, Supplier<? extends Queue<TRight>> processorQueueSupplier) {
        super(source);
        this.other = Objects.requireNonNull(other, "other");
        this.leftEnd = Objects.requireNonNull(leftEnd, "leftEnd");
        this.rightEnd = Objects.requireNonNull(rightEnd, "rightEnd");
        this.queueSupplier = Objects.requireNonNull(queueSupplier, "queueSupplier");
        this.processorQueueSupplier = Objects.requireNonNull(processorQueueSupplier, "processorQueueSupplier");
        this.resultSelector = Objects.requireNonNull(resultSelector, "resultSelector");
    }

    @Override
    public void subscribe(Subscriber<? super R> s) {
        GroupJoinSubscription parent = new GroupJoinSubscription(s, this.leftEnd, this.rightEnd, this.resultSelector, this.queueSupplier.get(), this.processorQueueSupplier);
        s.onSubscribe(parent);
        LeftRightSubscriber left = new LeftRightSubscriber(parent, true);
        parent.cancellations.add(left);
        LeftRightSubscriber right = new LeftRightSubscriber(parent, false);
        parent.cancellations.add(right);
        this.source.subscribe((Subscriber)left);
        this.other.subscribe((Subscriber)right);
    }

    static final class LeftRightEndSubscriber
    implements Subscriber<Object>,
    Disposable,
    Trackable,
    Receiver {
        final JoinSupport parent;
        final boolean isLeft;
        final int index;
        volatile Subscription subscription;
        static final AtomicReferenceFieldUpdater<LeftRightEndSubscriber, Subscription> SUBSCRIPTION = AtomicReferenceFieldUpdater.newUpdater(LeftRightEndSubscriber.class, Subscription.class, "subscription");

        public LeftRightEndSubscriber(JoinSupport parent, boolean isLeft, int index) {
            this.parent = parent;
            this.isLeft = isLeft;
            this.index = index;
        }

        @Override
        public void dispose() {
            Subscription current = SUBSCRIPTION.get(this);
            if (current != Operators.cancelledSubscription() && (current = SUBSCRIPTION.getAndSet(this, Operators.cancelledSubscription())) != Operators.cancelledSubscription() && current != null) {
                current.cancel();
            }
        }

        @Override
        public boolean isCancelled() {
            return Operators.cancelledSubscription() == this.subscription;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.setOnce(SUBSCRIPTION, this, s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(Object t) {
            Subscription current = SUBSCRIPTION.get(this);
            if (current != Operators.cancelledSubscription() && (current = SUBSCRIPTION.getAndSet(this, Operators.cancelledSubscription())) != Operators.cancelledSubscription()) {
                if (current != null) {
                    current.cancel();
                }
                this.parent.innerClose(this.isLeft, this);
            }
        }

        public void onError(Throwable t) {
            this.parent.innerError(t);
        }

        public void onComplete() {
            this.parent.innerClose(this.isLeft, this);
        }

        @Override
        public Object upstream() {
            return this.subscription;
        }
    }

    static final class LeftRightSubscriber
    implements Subscriber<Object>,
    Disposable,
    Trackable,
    Receiver {
        final JoinSupport parent;
        final boolean isLeft;
        volatile Subscription subscription;
        static final AtomicReferenceFieldUpdater<LeftRightSubscriber, Subscription> SUBSCRIPTION = AtomicReferenceFieldUpdater.newUpdater(LeftRightSubscriber.class, Subscription.class, "subscription");

        public LeftRightSubscriber(JoinSupport parent, boolean isLeft) {
            this.parent = parent;
            this.isLeft = isLeft;
        }

        @Override
        public void dispose() {
            Subscription current = SUBSCRIPTION.get(this);
            if (current != Operators.cancelledSubscription() && (current = SUBSCRIPTION.getAndSet(this, Operators.cancelledSubscription())) != Operators.cancelledSubscription() && current != null) {
                current.cancel();
            }
        }

        @Override
        public boolean isCancelled() {
            return Operators.cancelledSubscription() == this.subscription;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.setOnce(SUBSCRIPTION, this, s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(Object t) {
            this.parent.innerValue(this.isLeft, t);
        }

        public void onError(Throwable t) {
            this.parent.innerError(t);
        }

        public void onComplete() {
            this.parent.innerComplete(this);
        }

        @Override
        public Object upstream() {
            return this.subscription;
        }
    }

    static final class GroupJoinSubscription<TLeft, TRight, TLeftEnd, TRightEnd, R>
    implements Subscription,
    JoinSupport,
    Trackable,
    Producer,
    MultiReceiver,
    MultiProducer {
        final Subscriber<? super R> actual;
        final Queue<Object> queue;
        final BiPredicate<Object, Object> queueBiOffer;
        final OpenHashSet<Disposable> cancellations;
        final Map<Integer, UnicastProcessor<TRight>> lefts;
        final Map<Integer, TRight> rights;
        final Function<? super TLeft, ? extends Publisher<TLeftEnd>> leftEnd;
        final Function<? super TRight, ? extends Publisher<TRightEnd>> rightEnd;
        final BiFunction<? super TLeft, ? super Flux<TRight>, ? extends R> resultSelector;
        final Supplier<? extends Queue<TRight>> processorQueueSupplier;
        int leftIndex;
        int rightIndex;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<GroupJoinSubscription> WIP = AtomicIntegerFieldUpdater.newUpdater(GroupJoinSubscription.class, "wip");
        volatile int active;
        static final AtomicIntegerFieldUpdater<GroupJoinSubscription> ACTIVE = AtomicIntegerFieldUpdater.newUpdater(GroupJoinSubscription.class, "active");
        volatile long requested;
        static final AtomicLongFieldUpdater<GroupJoinSubscription> REQUESTED = AtomicLongFieldUpdater.newUpdater(GroupJoinSubscription.class, "requested");
        volatile Throwable error;
        static final AtomicReferenceFieldUpdater<GroupJoinSubscription, Throwable> ERROR = AtomicReferenceFieldUpdater.newUpdater(GroupJoinSubscription.class, Throwable.class, "error");
        volatile boolean cancelled;
        static final Integer LEFT_VALUE = 1;
        static final Integer RIGHT_VALUE = 2;
        static final Integer LEFT_CLOSE = 3;
        static final Integer RIGHT_CLOSE = 4;

        public GroupJoinSubscription(Subscriber<? super R> actual, Function<? super TLeft, ? extends Publisher<TLeftEnd>> leftEnd, Function<? super TRight, ? extends Publisher<TRightEnd>> rightEnd, BiFunction<? super TLeft, ? super Flux<TRight>, ? extends R> resultSelector, Queue<Object> queue, Supplier<? extends Queue<TRight>> processorQueueSupplier) {
            this.actual = actual;
            this.cancellations = new OpenHashSet();
            this.queue = queue;
            this.processorQueueSupplier = processorQueueSupplier;
            if (!(queue instanceof BiPredicate)) {
                throw new IllegalArgumentException("The provided queue must implement BiPredicate to expose atomic dual insert");
            }
            this.queueBiOffer = (BiPredicate)((Object)queue);
            this.lefts = new LinkedHashMap<Integer, UnicastProcessor<TRight>>();
            this.rights = new LinkedHashMap<Integer, TRight>();
            this.leftEnd = leftEnd;
            this.rightEnd = rightEnd;
            this.resultSelector = resultSelector;
            ACTIVE.lazySet(this, 2);
        }

        @Override
        public Iterator<?> downstreams() {
            return this.lefts.values().iterator();
        }

        @Override
        public long downstreamCount() {
            return this.lefts.size();
        }

        @Override
        public Iterator<?> upstreams() {
            return Arrays.asList(this.cancellations.keys()).iterator();
        }

        @Override
        public Object downstream() {
            return this.actual;
        }

        @Override
        public long upstreamCount() {
            return this.cancellations.keys().length;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public long requestedFromDownstream() {
            return this.requested;
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                Operators.getAndAddCap(REQUESTED, this, n);
            }
        }

        public void cancel() {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
            this.cancelAll();
            if (WIP.getAndIncrement(this) == 0) {
                this.queue.clear();
            }
        }

        void cancelAll() {
            Object[] a;
            for (Object o : a = this.cancellations.keys()) {
                if (o == null) continue;
                ((Disposable)o).dispose();
            }
        }

        void errorAll(Subscriber<?> a) {
            Throwable ex = Exceptions.terminate(ERROR, this);
            for (UnicastProcessor<TRight> up : this.lefts.values()) {
                up.onError(ex);
            }
            this.lefts.clear();
            this.rights.clear();
            a.onError(ex);
        }

        void drain() {
            if (WIP.getAndIncrement(this) != 0) {
                return;
            }
            int missed = 1;
            Queue<Object> q = this.queue;
            Subscriber<? super R> a = this.actual;
            block6: while (true) {
                boolean empty;
                if (this.cancelled) {
                    q.clear();
                    return;
                }
                Throwable ex = this.error;
                if (ex != null) {
                    q.clear();
                    this.cancelAll();
                    this.errorAll(a);
                    return;
                }
                boolean d = this.active == 0;
                Integer mode = (Integer)q.poll();
                boolean bl = empty = mode == null;
                if (d && empty) {
                    for (UnicastProcessor<TRight> up : this.lefts.values()) {
                        up.onComplete();
                    }
                    this.lefts.clear();
                    this.rights.clear();
                    this.cancelAll();
                    a.onComplete();
                    return;
                }
                if (!empty) {
                    LeftRightEndSubscriber end;
                    Object val = q.poll();
                    if (mode == LEFT_VALUE) {
                        R w;
                        Publisher<TLeftEnd> p;
                        int idx;
                        Object left = val;
                        UnicastProcessor<TRight> up = new UnicastProcessor<TRight>(this.processorQueueSupplier.get());
                        ++this.leftIndex;
                        this.lefts.put(idx, up);
                        try {
                            p = Objects.requireNonNull(this.leftEnd.apply(left), "The leftEnd returned a null Publisher");
                        }
                        catch (Throwable exc) {
                            Exceptions.addThrowable(ERROR, this, Operators.onOperatorError(this, exc, left));
                            this.errorAll(a);
                            return;
                        }
                        LeftRightEndSubscriber end2 = new LeftRightEndSubscriber(this, true, idx);
                        this.cancellations.add(end2);
                        p.subscribe((Subscriber)end2);
                        ex = this.error;
                        if (ex != null) {
                            this.cancelAll();
                            q.clear();
                            this.errorAll(a);
                            return;
                        }
                        try {
                            w = Objects.requireNonNull(this.resultSelector.apply(left, up), "The resultSelector returned a null value");
                        }
                        catch (Throwable exc) {
                            Exceptions.addThrowable(ERROR, this, Operators.onOperatorError(this, exc, up));
                            this.errorAll(a);
                            return;
                        }
                        long r = this.requested;
                        if (r != 0L) {
                            a.onNext(w);
                            while (r != Long.MAX_VALUE) {
                                long upd = r - 1L;
                                if (upd < 0L) {
                                    Exceptions.addThrowable(ERROR, this, Operators.onOperatorError(this, Exceptions.failWithOverflow()));
                                    this.errorAll(a);
                                    return;
                                }
                                if (!REQUESTED.compareAndSet(this, r, upd)) {
                                    r = this.requested;
                                    continue;
                                }
                                break;
                            }
                        } else {
                            Exceptions.addThrowable(ERROR, this, Exceptions.failWithOverflow());
                            this.errorAll(a);
                            return;
                        }
                        Iterator<TRight> iterator = this.rights.values().iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block6;
                            TRight right = iterator.next();
                            up.onNext(right);
                        }
                    }
                    if (mode == RIGHT_VALUE) {
                        Publisher<TRightEnd> p;
                        int idx;
                        Object right = val;
                        ++this.rightIndex;
                        this.rights.put(idx, right);
                        try {
                            p = Objects.requireNonNull(this.rightEnd.apply(right), "The rightEnd returned a null Publisher");
                        }
                        catch (Throwable exc) {
                            Exceptions.addThrowable(ERROR, this, Operators.onOperatorError(this, exc, right));
                            this.errorAll(a);
                            return;
                        }
                        LeftRightEndSubscriber end3 = new LeftRightEndSubscriber(this, false, idx);
                        this.cancellations.add(end3);
                        p.subscribe((Subscriber)end3);
                        ex = this.error;
                        if (ex != null) {
                            q.clear();
                            this.cancelAll();
                            this.errorAll(a);
                            return;
                        }
                        Iterator<UnicastProcessor<TRight>> iterator = this.lefts.values().iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block6;
                            UnicastProcessor<TRight> up = iterator.next();
                            up.onNext(right);
                        }
                    }
                    if (mode == LEFT_CLOSE) {
                        end = (LeftRightEndSubscriber)val;
                        UnicastProcessor<TRight> up = this.lefts.remove(end.index);
                        this.cancellations.remove(end);
                        if (up == null) continue;
                        up.onComplete();
                        continue;
                    }
                    if (mode != RIGHT_CLOSE) continue;
                    end = (LeftRightEndSubscriber)val;
                    this.rights.remove(end.index);
                    this.cancellations.remove(end);
                    continue;
                }
                if ((missed = WIP.addAndGet(this, -missed)) == 0) break;
            }
        }

        @Override
        public void innerError(Throwable ex) {
            if (Exceptions.addThrowable(ERROR, this, ex)) {
                ACTIVE.decrementAndGet(this);
                this.drain();
            } else {
                Operators.onErrorDropped(ex);
            }
        }

        @Override
        public void innerComplete(LeftRightSubscriber sender) {
            this.cancellations.remove(sender);
            ACTIVE.decrementAndGet(this);
            this.drain();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void innerValue(boolean isLeft, Object o) {
            GroupJoinSubscription groupJoinSubscription = this;
            synchronized (groupJoinSubscription) {
                this.queueBiOffer.test(isLeft ? LEFT_VALUE : RIGHT_VALUE, o);
            }
            this.drain();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void innerClose(boolean isLeft, LeftRightEndSubscriber index) {
            GroupJoinSubscription groupJoinSubscription = this;
            synchronized (groupJoinSubscription) {
                this.queueBiOffer.test(isLeft ? LEFT_CLOSE : RIGHT_CLOSE, index);
            }
            this.drain();
        }

        @Override
        public void innerCloseError(Throwable ex) {
            if (Exceptions.addThrowable(ERROR, this, ex)) {
                this.drain();
            } else {
                Operators.onErrorDropped(ex);
            }
        }
    }

    static interface JoinSupport {
        public void innerError(Throwable var1);

        public void innerComplete(LeftRightSubscriber var1);

        public void innerValue(boolean var1, Object var2);

        public void innerClose(boolean var1, LeftRightEndSubscriber var2);

        public void innerCloseError(Throwable var1);
    }
}

