/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.BooleanSupplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.publisher.DrainUtils;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.Operators;
import reactor.core.publisher.Signal;

final class FluxMaterialize<T>
extends FluxSource<T, Signal<T>> {
    public FluxMaterialize(Publisher<T> source) {
        super(source);
    }

    @Override
    public void subscribe(Subscriber<? super Signal<T>> subscriber) {
        this.source.subscribe(new MaterializeAction(subscriber));
    }

    static final class MaterializeAction<T>
    extends AbstractQueue<Signal<T>>
    implements Subscriber<T>,
    Subscription,
    BooleanSupplier {
        final Subscriber<? super Signal<T>> actual;
        Signal<T> value;
        volatile boolean cancelled;
        volatile long requested;
        static final AtomicLongFieldUpdater<MaterializeAction> REQUESTED = AtomicLongFieldUpdater.newUpdater(MaterializeAction.class, "requested");
        long produced;
        Subscription s;

        public MaterializeAction(Subscriber<? super Signal<T>> subscriber) {
            this.actual = subscriber;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T ev) {
            ++this.produced;
            this.actual.onNext(Signal.next(ev));
        }

        public void onError(Throwable ev) {
            this.value = Signal.error(ev);
            long p = this.produced;
            if (p != 0L) {
                REQUESTED.addAndGet(this, -p);
            }
            DrainUtils.postComplete(this.actual, this, REQUESTED, this, this);
        }

        public void onComplete() {
            this.value = Signal.complete();
            long p = this.produced;
            if (p != 0L) {
                REQUESTED.addAndGet(this, -p);
            }
            DrainUtils.postComplete(this.actual, this, REQUESTED, this, this);
        }

        public void request(long n) {
            if (Operators.validate(n) && !DrainUtils.postCompleteRequest(n, this.actual, this, REQUESTED, this, this)) {
                this.s.request(n);
            }
        }

        public void cancel() {
            this.cancelled = true;
            this.s.cancel();
        }

        @Override
        public boolean getAsBoolean() {
            return this.cancelled;
        }

        @Override
        public boolean offer(Signal<T> e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Signal<T> poll() {
            Signal<T> v = this.value;
            if (v != null) {
                this.value = null;
                return v;
            }
            return null;
        }

        @Override
        public Signal<T> peek() {
            return this.value;
        }

        @Override
        public Iterator<Signal<T>> iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.value == null ? 0 : 1;
        }
    }
}

