/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Loopback;
import reactor.core.Producer;
import reactor.core.Trackable;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.Operators;

final class FluxOnBackpressureDrop<T>
extends FluxSource<T, T> {
    static final Consumer<Object> NOOP = t -> {};
    final Consumer<? super T> onDrop;

    public FluxOnBackpressureDrop(Publisher<? extends T> source) {
        super(source);
        this.onDrop = NOOP;
    }

    public FluxOnBackpressureDrop(Publisher<? extends T> source, Consumer<? super T> onDrop) {
        super(source);
        this.onDrop = Objects.requireNonNull(onDrop, "onDrop");
    }

    @Override
    public long getPrefetch() {
        return Long.MAX_VALUE;
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        this.source.subscribe(new DropSubscriber<T>(s, this.onDrop));
    }

    static final class DropSubscriber<T>
    implements Subscriber<T>,
    Subscription,
    Producer,
    Loopback,
    Trackable {
        final Subscriber<? super T> actual;
        final Consumer<? super T> onDrop;
        Subscription s;
        volatile long requested;
        static final AtomicLongFieldUpdater<DropSubscriber> REQUESTED = AtomicLongFieldUpdater.newUpdater(DropSubscriber.class, "requested");
        boolean done;

        public DropSubscriber(Subscriber<? super T> actual, Consumer<? super T> onDrop) {
            this.actual = actual;
            this.onDrop = onDrop;
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                Operators.getAndAddCap(REQUESTED, this, n);
            }
        }

        public void cancel() {
            this.s.cancel();
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            if (this.done) {
                try {
                    this.onDrop.accept(t);
                }
                catch (Throwable e) {
                    Operators.onErrorDropped(e);
                }
                return;
            }
            long r = this.requested;
            if (r != 0L) {
                this.actual.onNext(t);
                if (r != Long.MAX_VALUE) {
                    REQUESTED.decrementAndGet(this);
                }
            } else {
                try {
                    this.onDrop.accept(t);
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e, t));
                }
            }
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }

        @Override
        public boolean isStarted() {
            return this.s != null && !this.done;
        }

        @Override
        public boolean isTerminated() {
            return this.done;
        }

        @Override
        public Object downstream() {
            return this.actual;
        }

        @Override
        public long requestedFromDownstream() {
            return this.requested;
        }

        @Override
        public Object connectedInput() {
            return this.onDrop;
        }
    }
}

