/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.Producer;
import reactor.core.Receiver;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.Operators;
import reactor.core.publisher.SignalPeekStateful;

final class FluxPeekStateful<T, S>
extends FluxSource<T, T>
implements SignalPeekStateful<T, S> {
    final Supplier<S> stateSeeder;
    final BiConsumer<? super Subscription, S> onSubscribeCall;
    final BiConsumer<? super T, S> onNextCall;
    final BiConsumer<? super Throwable, S> onErrorCall;
    final Consumer<S> onCompleteCall;
    final Consumer<S> onAfterTerminateCall;
    final BiConsumer<Long, S> onRequestCall;
    final Consumer<S> onCancelCall;

    public FluxPeekStateful(Publisher<? extends T> source, Supplier<S> stateSeeder, BiConsumer<? super Subscription, S> onSubscribeCall, BiConsumer<? super T, S> onNextCall, BiConsumer<? super Throwable, S> onErrorCall, Consumer<S> onCompleteCall, Consumer<S> onAfterTerminateCall, BiConsumer<Long, S> onRequestCall, Consumer<S> onCancelCall) {
        super(source);
        this.stateSeeder = stateSeeder;
        this.onSubscribeCall = onSubscribeCall;
        this.onNextCall = onNextCall;
        this.onErrorCall = onErrorCall;
        this.onCompleteCall = onCompleteCall;
        this.onAfterTerminateCall = onAfterTerminateCall;
        this.onRequestCall = onRequestCall;
        this.onCancelCall = onCancelCall;
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        this.source.subscribe(new PeekStatefulSubscriber<T, S>(s, this, this.stateSeeder.get()));
    }

    @Override
    public BiConsumer<? super Subscription, S> onSubscribeCall() {
        return this.onSubscribeCall;
    }

    @Override
    public BiConsumer<? super T, S> onNextCall() {
        return this.onNextCall;
    }

    @Override
    public BiConsumer<? super Throwable, S> onErrorCall() {
        return this.onErrorCall;
    }

    @Override
    public Consumer<S> onCompleteCall() {
        return this.onCompleteCall;
    }

    @Override
    public Consumer<S> onAfterTerminateCall() {
        return this.onAfterTerminateCall;
    }

    @Override
    public BiConsumer<Long, S> onRequestCall() {
        return this.onRequestCall;
    }

    @Override
    public Consumer<S> onCancelCall() {
        return this.onCancelCall;
    }

    static final class PeekStatefulSubscriber<T, S>
    implements Subscriber<T>,
    Subscription,
    Receiver,
    Producer {
        final Subscriber<? super T> actual;
        final SignalPeekStateful<T, S> parent;
        final S state;
        Subscription s;
        boolean done;

        public PeekStatefulSubscriber(Subscriber<? super T> actual, SignalPeekStateful<T, S> parent, S state) {
            this.actual = actual;
            this.parent = parent;
            this.state = state;
        }

        public void request(long n) {
            if (this.parent.onRequestCall() != null) {
                try {
                    this.parent.onRequestCall().accept(n, this.state);
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e));
                    return;
                }
            }
            this.s.request(n);
        }

        public void cancel() {
            if (this.parent.onCancelCall() != null) {
                try {
                    this.parent.onCancelCall().accept(this.state);
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e));
                    return;
                }
            }
            this.s.cancel();
        }

        public void onSubscribe(Subscription s) {
            if (this.parent.onSubscribeCall() != null) {
                try {
                    this.parent.onSubscribeCall().accept(s, this.state);
                }
                catch (Throwable e) {
                    Operators.error(this.actual, Operators.onOperatorError(s, e));
                    return;
                }
            }
            this.s = s;
            this.actual.onSubscribe((Subscription)this);
        }

        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            if (this.parent.onNextCall() != null) {
                try {
                    this.parent.onNextCall().accept(t, this.state);
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e, t));
                    return;
                }
            }
            this.actual.onNext(t);
        }

        public void onError(Throwable t) {
            block9: {
                if (this.done) {
                    Operators.onErrorDropped(t);
                    return;
                }
                this.done = true;
                if (this.parent.onErrorCall() != null) {
                    try {
                        this.parent.onErrorCall().accept(t, this.state);
                    }
                    catch (Throwable e) {
                        t = Operators.onOperatorError(null, e, t);
                    }
                }
                try {
                    this.actual.onError(t);
                }
                catch (UnsupportedOperationException use) {
                    if (this.parent.onErrorCall() != null && (Exceptions.isErrorCallbackNotImplemented(use) || use.getCause() == t)) break block9;
                    throw use;
                }
            }
            if (this.parent.onAfterTerminateCall() != null) {
                try {
                    this.parent.onAfterTerminateCall().accept(this.state);
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal(e);
                    Throwable _e = Operators.onOperatorError(null, e, t);
                    Operators.onErrorDropped(_e);
                }
            }
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            if (this.parent.onCompleteCall() != null) {
                try {
                    this.parent.onCompleteCall().accept(this.state);
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e));
                    return;
                }
            }
            this.done = true;
            this.actual.onComplete();
            if (this.parent.onAfterTerminateCall() != null) {
                try {
                    this.parent.onAfterTerminateCall().accept(this.state);
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal(e);
                    Throwable _e = Operators.onOperatorError(e);
                    Operators.onErrorDropped(_e);
                }
            }
        }

        @Override
        public Object downstream() {
            return this.actual;
        }

        @Override
        public Object upstream() {
            return this.s;
        }
    }
}

