/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.Operators;

final class FluxPublishMulticast<T, R>
extends FluxSource<T, R>
implements Fuseable {
    final Function<? super Flux<T>, ? extends Publisher<? extends R>> transform;
    final Supplier<? extends Queue<T>> queueSupplier;
    final int prefetch;

    public FluxPublishMulticast(Publisher<? extends T> source, Function<? super Flux<T>, ? extends Publisher<? extends R>> transform, int prefetch, Supplier<? extends Queue<T>> queueSupplier) {
        super(source);
        if (prefetch < 1) {
            throw new IllegalArgumentException("prefetch > 0 required but it was " + prefetch);
        }
        this.prefetch = prefetch;
        this.transform = Objects.requireNonNull(transform, "transform");
        this.queueSupplier = Objects.requireNonNull(queueSupplier, "queueSupplier");
    }

    @Override
    public long getPrefetch() {
        return this.prefetch;
    }

    @Override
    public void subscribe(Subscriber<? super R> s) {
        Publisher<? extends R> out;
        FluxPublishMulticaster multicast = new FluxPublishMulticaster(this.prefetch, this.queueSupplier);
        try {
            out = this.transform.apply(multicast);
        }
        catch (Throwable ex) {
            Operators.error(s, Operators.onOperatorError(ex));
            return;
        }
        if (out == null) {
            Operators.error(s, new NullPointerException("The transform returned a null Publisher"));
            return;
        }
        if (out instanceof Fuseable) {
            out.subscribe(new CancelFuseableMulticaster<R>(s, multicast));
        } else {
            out.subscribe(new CancelMulticaster<R>(s, multicast));
        }
        this.source.subscribe(multicast);
    }

    static final class CancelFuseableMulticaster<T>
    implements Subscriber<T>,
    Fuseable.QueueSubscription<T> {
        final Subscriber<? super T> actual;
        final FluxPublishMulticaster<?, ?> parent;
        Fuseable.QueueSubscription<T> s;

        public CancelFuseableMulticaster(Subscriber<? super T> actual, FluxPublishMulticaster<?, ?> parent) {
            this.actual = actual;
            this.parent = parent;
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
            this.parent.cancel();
        }

        public void onSubscribe(Subscription s) {
            this.s = (Fuseable.QueueSubscription)s;
            this.actual.onSubscribe((Subscription)this);
        }

        public void onNext(T t) {
            this.actual.onNext(t);
        }

        public void onError(Throwable t) {
            this.parent.terminate();
            this.actual.onError(t);
        }

        public void onComplete() {
            this.parent.terminate();
            this.actual.onComplete();
        }

        @Override
        public int requestFusion(int requestedMode) {
            return this.s.requestFusion(requestedMode);
        }

        @Override
        public T poll() {
            return (T)this.s.poll();
        }

        @Override
        public boolean isEmpty() {
            return this.s.isEmpty();
        }

        @Override
        public int size() {
            return this.s.size();
        }

        @Override
        public void clear() {
            this.s.clear();
        }
    }

    static final class CancelMulticaster<T>
    implements Subscriber<T>,
    Fuseable.QueueSubscription<T> {
        final Subscriber<? super T> actual;
        final FluxPublishMulticaster<?, ?> parent;
        Subscription s;

        public CancelMulticaster(Subscriber<? super T> actual, FluxPublishMulticaster<?, ?> parent) {
            this.actual = actual;
            this.parent = parent;
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
            this.parent.cancel();
        }

        public void onSubscribe(Subscription s) {
            this.s = s;
            this.actual.onSubscribe((Subscription)this);
        }

        public void onNext(T t) {
            this.actual.onNext(t);
        }

        public void onError(Throwable t) {
            this.parent.terminate();
            this.actual.onError(t);
        }

        public void onComplete() {
            this.parent.terminate();
            this.actual.onComplete();
        }

        @Override
        public int requestFusion(int requestedMode) {
            return 0;
        }

        @Override
        public void clear() {
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public T poll() {
            return null;
        }
    }

    static final class PublishClientSubscription<T>
    implements Subscription {
        final FluxPublishMulticaster<T, ?> parent;
        final Subscriber<? super T> actual;
        volatile long requested;
        static final AtomicLongFieldUpdater<PublishClientSubscription> REQUESTED = AtomicLongFieldUpdater.newUpdater(PublishClientSubscription.class, "requested");
        volatile int once;
        static final AtomicIntegerFieldUpdater<PublishClientSubscription> ONCE = AtomicIntegerFieldUpdater.newUpdater(PublishClientSubscription.class, "once");

        public PublishClientSubscription(FluxPublishMulticaster<T, ?> parent, Subscriber<? super T> actual) {
            this.parent = parent;
            this.actual = actual;
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                Operators.getAndAddCap(REQUESTED, this, n);
                this.parent.drain();
            }
        }

        public void cancel() {
            if (ONCE.compareAndSet(this, 0, 1)) {
                this.parent.removeAndDrain(this);
            }
        }

        void produced(long n) {
            if (this.requested != Long.MAX_VALUE) {
                REQUESTED.addAndGet(this, -n);
            }
        }
    }

    static final class FluxPublishMulticaster<T, R>
    extends Flux<T>
    implements Subscriber<T> {
        final int limit;
        final int prefetch;
        final Supplier<? extends Queue<T>> queueSupplier;
        Queue<T> queue;
        volatile Subscription s;
        static final AtomicReferenceFieldUpdater<FluxPublishMulticaster, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(FluxPublishMulticaster.class, Subscription.class, "s");
        volatile int wip;
        static final AtomicIntegerFieldUpdater<FluxPublishMulticaster> WIP = AtomicIntegerFieldUpdater.newUpdater(FluxPublishMulticaster.class, "wip");
        volatile PublishClientSubscription<T>[] subscribers;
        static final AtomicReferenceFieldUpdater<FluxPublishMulticaster, PublishClientSubscription[]> SUBSCRIBERS = AtomicReferenceFieldUpdater.newUpdater(FluxPublishMulticaster.class, PublishClientSubscription[].class, "subscribers");
        static final PublishClientSubscription[] EMPTY = new PublishClientSubscription[0];
        static final PublishClientSubscription[] TERMINATED = new PublishClientSubscription[0];
        volatile boolean done;
        volatile boolean connected;
        volatile boolean cancelled;
        Throwable error;
        int produced;
        int sourceMode;

        public FluxPublishMulticaster(int prefetch, Supplier<? extends Queue<T>> queueSupplier) {
            this.prefetch = prefetch;
            this.limit = prefetch - (prefetch >> 2);
            this.queueSupplier = queueSupplier;
            this.subscribers = EMPTY;
        }

        public void subscribe(Subscriber<? super T> s) {
            PublishClientSubscription<? super T> pcs = new PublishClientSubscription<T>(this, s);
            s.onSubscribe(pcs);
            if (this.add(pcs)) {
                if (pcs.once != 0) {
                    this.removeAndDrain(pcs);
                } else {
                    this.drain();
                }
            } else {
                Throwable ex = this.error;
                if (ex != null) {
                    s.onError(ex);
                } else {
                    s.onComplete();
                }
            }
        }

        public void onSubscribe(Subscription s) {
            if (Operators.setOnce(S, this, s)) {
                if (s instanceof Fuseable.QueueSubscription) {
                    Fuseable.QueueSubscription qs = (Fuseable.QueueSubscription)s;
                    int m = qs.requestFusion(3);
                    if (m == 1) {
                        this.sourceMode = m;
                        this.queue = qs;
                        this.done = true;
                        this.connected = true;
                        this.drain();
                        return;
                    }
                    if (m == 2) {
                        this.sourceMode = m;
                        this.queue = qs;
                        this.connected = true;
                        s.request((long)this.prefetch);
                        return;
                    }
                }
                try {
                    this.queue = this.queueSupplier.get();
                }
                catch (Throwable ex) {
                    this.onError(Operators.onOperatorError(s, ex));
                    return;
                }
                this.connected = true;
                s.request((long)this.prefetch);
            }
        }

        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            if (this.sourceMode != 2 && !this.queue.offer(t)) {
                this.onError(Operators.onOperatorError(this.s, Exceptions.failWithOverflow("Queue full?!"), t));
                return;
            }
            this.drain();
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.error = t;
            this.done = true;
            this.drain();
        }

        public void onComplete() {
            this.done = true;
            this.drain();
        }

        void drain() {
            if (WIP.getAndIncrement(this) != 0) {
                return;
            }
            if (this.sourceMode == 1) {
                this.drainSync();
            } else {
                this.drainAsync();
            }
        }

        void drainSync() {
            int missed = 1;
            do {
                boolean empty;
                int i;
                long e;
                if (!this.connected) continue;
                if (this.cancelled) {
                    this.queue.clear();
                    return;
                }
                Queue<T> queue = this.queue;
                PublishClientSubscription<T>[] a = this.subscribers;
                int n = a.length;
                if (n == 0) continue;
                long r = Long.MAX_VALUE;
                for (int i2 = 0; i2 < n; ++i2) {
                    r = Math.min(r, a[i2].requested);
                }
                for (e = 0L; e != r; ++e) {
                    T v;
                    if (this.cancelled) {
                        queue.clear();
                        return;
                    }
                    try {
                        v = queue.poll();
                    }
                    catch (Throwable ex) {
                        this.error = Operators.onOperatorError(this.s, ex);
                        queue.clear();
                        a = SUBSCRIBERS.getAndSet(this, TERMINATED);
                        for (int i3 = 0; i3 < n; ++i3) {
                            a[i3].actual.onError(ex);
                        }
                        return;
                    }
                    if (v == null) {
                        a = SUBSCRIBERS.getAndSet(this, TERMINATED);
                        for (i = 0; i < n; ++i) {
                            a[i].actual.onComplete();
                        }
                        return;
                    }
                    for (i = 0; i < n; ++i) {
                        a[i].actual.onNext(v);
                    }
                }
                if (this.cancelled) {
                    queue.clear();
                    return;
                }
                try {
                    empty = queue.isEmpty();
                }
                catch (Throwable ex) {
                    queue.clear();
                    this.error = Operators.onOperatorError(this.s, ex);
                    a = SUBSCRIBERS.getAndSet(this, TERMINATED);
                    for (int i4 = 0; i4 < n; ++i4) {
                        a[i4].actual.onError(ex);
                    }
                    return;
                }
                if (empty) {
                    a = SUBSCRIBERS.getAndSet(this, TERMINATED);
                    for (i = 0; i < n; ++i) {
                        a[i].actual.onComplete();
                    }
                    return;
                }
                if (e == 0L) continue;
                for (i = 0; i < n; ++i) {
                    a[i].produced(e);
                }
            } while ((missed = WIP.addAndGet(this, -missed)) != 0);
        }

        void drainAsync() {
            int missed = 1;
            int p = this.produced;
            do {
                if (this.connected) {
                    if (this.cancelled) {
                        this.queue.clear();
                        return;
                    }
                    Queue<T> queue = this.queue;
                    PublishClientSubscription<T>[] a = this.subscribers;
                    int n = a.length;
                    if (n != 0) {
                        boolean d;
                        long e;
                        long r = Long.MAX_VALUE;
                        for (int i = 0; i < n; ++i) {
                            r = Math.min(r, a[i].requested);
                        }
                        for (e = 0L; e != r; ++e) {
                            boolean empty;
                            T v;
                            if (this.cancelled) {
                                queue.clear();
                                return;
                            }
                            d = this.done;
                            try {
                                v = queue.poll();
                            }
                            catch (Throwable ex) {
                                queue.clear();
                                this.error = Operators.onOperatorError(this.s, ex);
                                a = SUBSCRIBERS.getAndSet(this, TERMINATED);
                                for (int i = 0; i < n; ++i) {
                                    a[i].actual.onError(ex);
                                }
                                return;
                            }
                            boolean bl = empty = v == null;
                            if (d) {
                                Throwable ex = this.error;
                                if (ex != null) {
                                    queue.clear();
                                    a = SUBSCRIBERS.getAndSet(this, TERMINATED);
                                    for (int i = 0; i < n; ++i) {
                                        a[i].actual.onError(ex);
                                    }
                                    return;
                                }
                                if (empty) {
                                    a = SUBSCRIBERS.getAndSet(this, TERMINATED);
                                    for (int i = 0; i < n; ++i) {
                                        a[i].actual.onComplete();
                                    }
                                    return;
                                }
                            }
                            if (empty) break;
                            for (int i = 0; i < n; ++i) {
                                a[i].actual.onNext(v);
                            }
                            if (++p != this.limit) continue;
                            this.s.request((long)p);
                            p = 0;
                        }
                        if (e == r) {
                            boolean empty;
                            if (this.cancelled) {
                                queue.clear();
                                return;
                            }
                            d = this.done;
                            try {
                                empty = queue.isEmpty();
                            }
                            catch (Throwable ex) {
                                queue.clear();
                                this.error = Operators.onOperatorError(this.s, ex);
                                a = SUBSCRIBERS.getAndSet(this, TERMINATED);
                                for (int i = 0; i < n; ++i) {
                                    a[i].actual.onError(ex);
                                }
                                return;
                            }
                            if (d) {
                                ex = this.error;
                                if (ex != null) {
                                    queue.clear();
                                    a = SUBSCRIBERS.getAndSet(this, TERMINATED);
                                    for (int i = 0; i < n; ++i) {
                                        a[i].actual.onError(ex);
                                    }
                                    return;
                                }
                                if (empty) {
                                    a = SUBSCRIBERS.getAndSet(this, TERMINATED);
                                    for (int i = 0; i < n; ++i) {
                                        a[i].actual.onComplete();
                                    }
                                    return;
                                }
                            }
                        }
                        if (e != 0L) {
                            for (int i = 0; i < n; ++i) {
                                a[i].produced(e);
                            }
                        }
                    }
                }
                this.produced = p;
            } while ((missed = WIP.addAndGet(this, -missed)) != 0);
        }

        boolean add(PublishClientSubscription<T> s) {
            PublishClientSubscription[] b;
            PublishClientSubscription<T>[] a;
            do {
                if ((a = this.subscribers) == TERMINATED) {
                    return false;
                }
                int n = a.length;
                b = new PublishClientSubscription[n + 1];
                System.arraycopy(a, 0, b, 0, n);
                b[n] = s;
            } while (!SUBSCRIBERS.compareAndSet(this, a, b));
            return true;
        }

        void removeAndDrain(PublishClientSubscription<T> s) {
            PublishClientSubscription[] b;
            PublishClientSubscription<T>[] a;
            do {
                if ((a = this.subscribers) == TERMINATED || a == EMPTY) {
                    return;
                }
                int n = a.length;
                int j = -1;
                for (int i = 0; i < n; ++i) {
                    if (a[i] != s) continue;
                    j = i;
                    break;
                }
                if (j < 0) {
                    return;
                }
                if (n == 1) {
                    b = EMPTY;
                    continue;
                }
                b = new PublishClientSubscription[n - 1];
                System.arraycopy(a, 0, b, 0, j);
                System.arraycopy(a, j + 1, b, j, n - j - 1);
            } while (!SUBSCRIBERS.compareAndSet(this, a, b));
            this.drain();
        }

        void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.terminate();
            }
        }

        void terminate() {
            Operators.terminate(S, this);
            this.subscribers = TERMINATED;
            if (WIP.getAndIncrement(this) == 0 && this.connected) {
                this.queue.clear();
            }
        }
    }
}

