/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Subscriber;
import reactor.core.Cancellation;
import reactor.core.Fuseable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Operators;
import reactor.core.scheduler.Scheduler;

final class FluxSubscribeOnCallable<T>
extends Flux<T>
implements Fuseable {
    final Callable<? extends T> callable;
    final Scheduler scheduler;

    public FluxSubscribeOnCallable(Callable<? extends T> callable, Scheduler scheduler) {
        this.callable = Objects.requireNonNull(callable, "callable");
        this.scheduler = Objects.requireNonNull(scheduler, "scheduler");
    }

    public void subscribe(Subscriber<? super T> s) {
        FluxSubscribeOnCallable.subscribe(this.callable, s, this.scheduler);
    }

    public static <T> void subscribe(Callable<T> callable, Subscriber<? super T> s, Scheduler scheduler) {
        CallableSubscribeOnSubscription<T> parent = new CallableSubscribeOnSubscription<T>(s, callable, scheduler);
        s.onSubscribe(parent);
        Cancellation f = scheduler.schedule(parent);
        if (f == Scheduler.REJECTED) {
            if (parent.state != 4) {
                s.onError((Throwable)Operators.onRejectedExecution());
            }
        } else {
            parent.setMainFuture(f);
        }
    }

    static final class CallableSubscribeOnSubscription<T>
    implements Fuseable.QueueSubscription<T>,
    Runnable {
        final Subscriber<? super T> actual;
        final Callable<? extends T> callable;
        final Scheduler scheduler;
        volatile int state;
        static final AtomicIntegerFieldUpdater<CallableSubscribeOnSubscription> STATE = AtomicIntegerFieldUpdater.newUpdater(CallableSubscribeOnSubscription.class, "state");
        T value;
        static final int NO_REQUEST_NO_VALUE = 0;
        static final int NO_REQUEST_HAS_VALUE = 1;
        static final int HAS_REQUEST_NO_VALUE = 2;
        static final int HAS_REQUEST_HAS_VALUE = 3;
        static final int CANCELLED = 4;
        int fusionState;
        static final int NOT_FUSED = 0;
        static final int NO_VALUE = 1;
        static final int HAS_VALUE = 2;
        static final int COMPLETE = 3;
        volatile Cancellation mainFuture;
        static final AtomicReferenceFieldUpdater<CallableSubscribeOnSubscription, Cancellation> MAIN_FUTURE = AtomicReferenceFieldUpdater.newUpdater(CallableSubscribeOnSubscription.class, Cancellation.class, "mainFuture");
        volatile Cancellation requestFuture;
        static final AtomicReferenceFieldUpdater<CallableSubscribeOnSubscription, Cancellation> REQUEST_FUTURE = AtomicReferenceFieldUpdater.newUpdater(CallableSubscribeOnSubscription.class, Cancellation.class, "requestFuture");
        static final Cancellation CANCEL = () -> {};

        public CallableSubscribeOnSubscription(Subscriber<? super T> actual, Callable<? extends T> callable, Scheduler scheduler) {
            this.actual = actual;
            this.callable = callable;
            this.scheduler = scheduler;
        }

        public void cancel() {
            this.state = 4;
            this.fusionState = 3;
            Cancellation a = this.mainFuture;
            if (a != CANCEL && (a = MAIN_FUTURE.getAndSet(this, CANCEL)) != null && a != CANCEL) {
                a.dispose();
            }
            if ((a = this.requestFuture) != CANCEL && (a = REQUEST_FUTURE.getAndSet(this, CANCEL)) != null && a != CANCEL) {
                a.dispose();
            }
        }

        @Override
        public void clear() {
            this.value = null;
            this.fusionState = 3;
        }

        @Override
        public boolean isEmpty() {
            return this.fusionState != 2;
        }

        @Override
        public T poll() {
            if (this.fusionState == 2) {
                this.fusionState = 3;
                return this.value;
            }
            return null;
        }

        @Override
        public int requestFusion(int requestedMode) {
            if ((requestedMode & 2) != 0 && (requestedMode & 4) == 0) {
                this.fusionState = 1;
                return 2;
            }
            return 0;
        }

        @Override
        public int size() {
            return this.isEmpty() ? 0 : 1;
        }

        void setMainFuture(Cancellation c) {
            Cancellation a;
            do {
                if ((a = this.mainFuture) != CANCEL) continue;
                c.dispose();
                return;
            } while (!MAIN_FUTURE.compareAndSet(this, a, c));
        }

        void setRequestFuture(Cancellation c) {
            Cancellation a;
            do {
                if ((a = this.requestFuture) != CANCEL) continue;
                c.dispose();
                return;
            } while (!REQUEST_FUTURE.compareAndSet(this, a, c));
        }

        @Override
        public void run() {
            int s;
            T v;
            try {
                v = this.callable.call();
            }
            catch (Throwable ex) {
                this.actual.onError(Operators.onOperatorError(this, ex));
                return;
            }
            if (v == null) {
                this.actual.onError(Operators.onOperatorError(this, new NullPointerException("The callable returned null")));
                return;
            }
            do {
                if ((s = this.state) == 4 || s == 3 || s == 1) {
                    return;
                }
                if (s == 2) {
                    if (this.fusionState == 1) {
                        this.value = v;
                        this.fusionState = 2;
                    }
                    this.actual.onNext(v);
                    if (this.state != 4) {
                        this.actual.onComplete();
                    }
                    return;
                }
                this.value = v;
            } while (!STATE.compareAndSet(this, s, 1));
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                int s;
                do {
                    if ((s = this.state) == 4 || s == 2 || s == 3) {
                        return;
                    }
                    if (s != 1) continue;
                    if (STATE.compareAndSet(this, s, 3)) {
                        Cancellation f = this.scheduler.schedule(this::emitValue);
                        if (f == Scheduler.REJECTED) {
                            this.actual.onError((Throwable)Operators.onRejectedExecution());
                        } else {
                            this.setRequestFuture(f);
                        }
                    }
                    return;
                } while (!STATE.compareAndSet(this, s, 2));
                return;
            }
        }

        void emitValue() {
            if (this.fusionState == 1) {
                this.fusionState = 2;
            }
            this.actual.onNext(this.value);
            if (this.state != 4) {
                this.actual.onComplete();
            }
        }
    }
}

