/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.Supplier;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Disposable;
import reactor.core.MultiProducer;
import reactor.core.Producer;
import reactor.core.Receiver;
import reactor.core.Trackable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.Operators;
import reactor.core.publisher.UnicastProcessor;

final class FluxWindow<T>
extends FluxSource<T, Flux<T>> {
    final int size;
    final int skip;
    final Supplier<? extends Queue<T>> processorQueueSupplier;
    final Supplier<? extends Queue<UnicastProcessor<T>>> overflowQueueSupplier;

    public FluxWindow(Publisher<? extends T> source, int size, Supplier<? extends Queue<T>> processorQueueSupplier) {
        super(source);
        if (size <= 0) {
            throw new IllegalArgumentException("size > 0 required but it was " + size);
        }
        this.size = size;
        this.skip = size;
        this.processorQueueSupplier = Objects.requireNonNull(processorQueueSupplier, "processorQueueSupplier");
        this.overflowQueueSupplier = null;
    }

    public FluxWindow(Publisher<? extends T> source, int size, int skip, Supplier<? extends Queue<T>> processorQueueSupplier, Supplier<? extends Queue<UnicastProcessor<T>>> overflowQueueSupplier) {
        super(source);
        if (size <= 0) {
            throw new IllegalArgumentException("size > 0 required but it was " + size);
        }
        if (skip <= 0) {
            throw new IllegalArgumentException("skip > 0 required but it was " + skip);
        }
        this.size = size;
        this.skip = skip;
        this.processorQueueSupplier = Objects.requireNonNull(processorQueueSupplier, "processorQueueSupplier");
        this.overflowQueueSupplier = Objects.requireNonNull(overflowQueueSupplier, "overflowQueueSupplier");
    }

    @Override
    public void subscribe(Subscriber<? super Flux<T>> s) {
        if (this.skip == this.size) {
            this.source.subscribe(new WindowExactSubscriber(s, this.size, this.processorQueueSupplier));
        } else if (this.skip > this.size) {
            this.source.subscribe(new WindowSkipSubscriber(s, this.size, this.skip, this.processorQueueSupplier));
        } else {
            Queue<UnicastProcessor<T>> overflowQueue;
            try {
                overflowQueue = this.overflowQueueSupplier.get();
            }
            catch (Throwable e) {
                Operators.error(s, Operators.onOperatorError(e));
                return;
            }
            if (overflowQueue == null) {
                Operators.error(s, Operators.onOperatorError(new NullPointerException("The overflowQueueSupplier returned a null queue")));
                return;
            }
            this.source.subscribe(new WindowOverlapSubscriber<T>(s, this.size, this.skip, this.processorQueueSupplier, overflowQueue));
        }
    }

    static final class WindowOverlapSubscriber<T>
    implements Subscriber<T>,
    Subscription,
    Disposable,
    Producer,
    MultiProducer,
    Receiver,
    Trackable {
        final Subscriber<? super Flux<T>> actual;
        final Supplier<? extends Queue<T>> processorQueueSupplier;
        final Queue<UnicastProcessor<T>> queue;
        final int size;
        final int skip;
        final ArrayDeque<UnicastProcessor<T>> windows;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<WindowOverlapSubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(WindowOverlapSubscriber.class, "wip");
        volatile int once;
        static final AtomicIntegerFieldUpdater<WindowOverlapSubscriber> ONCE = AtomicIntegerFieldUpdater.newUpdater(WindowOverlapSubscriber.class, "once");
        volatile int firstRequest;
        static final AtomicIntegerFieldUpdater<WindowOverlapSubscriber> FIRST_REQUEST = AtomicIntegerFieldUpdater.newUpdater(WindowOverlapSubscriber.class, "firstRequest");
        volatile long requested;
        static final AtomicLongFieldUpdater<WindowOverlapSubscriber> REQUESTED = AtomicLongFieldUpdater.newUpdater(WindowOverlapSubscriber.class, "requested");
        volatile int dw;
        static final AtomicIntegerFieldUpdater<WindowOverlapSubscriber> DW = AtomicIntegerFieldUpdater.newUpdater(WindowOverlapSubscriber.class, "dw");
        int index;
        int produced;
        Subscription s;
        volatile boolean done;
        Throwable error;
        volatile boolean cancelled;

        public WindowOverlapSubscriber(Subscriber<? super Flux<T>> actual, int size, int skip, Supplier<? extends Queue<T>> processorQueueSupplier, Queue<UnicastProcessor<T>> overflowQueue) {
            this.actual = actual;
            this.size = size;
            this.skip = skip;
            this.processorQueueSupplier = processorQueueSupplier;
            this.wip = 1;
            this.queue = overflowQueue;
            this.windows = new ArrayDeque();
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            int i = this.index;
            if (i == 0 && !this.cancelled) {
                Queue<T> q;
                WIP.getAndIncrement(this);
                try {
                    q = this.processorQueueSupplier.get();
                }
                catch (Throwable throwable) {
                    WIP.decrementAndGet(this);
                    this.done = true;
                    this.cancel();
                    this.actual.onError(throwable);
                    return;
                }
                if (q == null) {
                    WIP.decrementAndGet(this);
                    this.done = true;
                    this.cancel();
                    this.actual.onError((Throwable)new NullPointerException("The processorQueueSupplier returned a null queue"));
                    return;
                }
                UnicastProcessor unicastProcessor = new UnicastProcessor(q, this);
                this.windows.offer(unicastProcessor);
                this.queue.offer(unicastProcessor);
                this.drain();
            }
            ++i;
            for (Processor processor : this.windows) {
                processor.onNext(t);
            }
            int p = this.produced + 1;
            if (p == this.size) {
                this.produced = p - this.skip;
                Processor processor = this.windows.poll();
                if (processor != null) {
                    processor.onComplete();
                }
            } else {
                this.produced = p;
            }
            this.index = i == this.skip ? 0 : i;
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            for (Processor processor : this.windows) {
                processor.onError(t);
            }
            this.windows.clear();
            this.error = t;
            this.done = true;
            this.drain();
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            for (Processor processor : this.windows) {
                processor.onComplete();
            }
            this.windows.clear();
            this.done = true;
            this.drain();
        }

        void drain() {
            if (DW.getAndIncrement(this) != 0) {
                return;
            }
            Subscriber<? super Flux<T>> a = this.actual;
            Queue<UnicastProcessor<T>> q = this.queue;
            int missed = 1;
            do {
                long e;
                long r = this.requested;
                for (e = 0L; e != r; ++e) {
                    boolean empty;
                    boolean d = this.done;
                    UnicastProcessor<T> t = q.poll();
                    boolean bl = empty = t == null;
                    if (this.checkTerminated(d, empty, a, q)) {
                        return;
                    }
                    if (empty) break;
                    a.onNext(t);
                }
                if (e == r && this.checkTerminated(this.done, q.isEmpty(), a, q)) {
                    return;
                }
                if (e == 0L || r == Long.MAX_VALUE) continue;
                REQUESTED.addAndGet(this, -e);
            } while ((missed = DW.addAndGet(this, -missed)) != 0);
        }

        boolean checkTerminated(boolean d, boolean empty, Subscriber<?> a, Queue<?> q) {
            if (this.cancelled) {
                q.clear();
                return true;
            }
            if (d) {
                Throwable e = this.error;
                if (e != null) {
                    q.clear();
                    a.onError(e);
                    return true;
                }
                if (empty) {
                    a.onComplete();
                    return true;
                }
            }
            return false;
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                Operators.getAndAddCap(REQUESTED, this, n);
                if (this.firstRequest == 0 && FIRST_REQUEST.compareAndSet(this, 0, 1)) {
                    long u = Operators.multiplyCap(this.skip, n - 1L);
                    long v = Operators.addCap(this.size, u);
                    this.s.request(v);
                } else {
                    long u = Operators.multiplyCap(this.skip, n);
                    this.s.request(u);
                }
                this.drain();
            }
        }

        public void cancel() {
            this.cancelled = true;
            if (ONCE.compareAndSet(this, 0, 1)) {
                this.dispose();
            }
        }

        @Override
        public void dispose() {
            if (WIP.decrementAndGet(this) == 0) {
                this.s.cancel();
            }
        }

        @Override
        public Object downstream() {
            return this.actual;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public boolean isStarted() {
            return this.s != null && !this.done && !this.cancelled;
        }

        @Override
        public boolean isTerminated() {
            return this.done;
        }

        @Override
        public Object upstream() {
            return this.s;
        }

        @Override
        public Throwable getError() {
            return this.error;
        }

        @Override
        public long expectedFromUpstream() {
            return this.size + this.skip - this.produced;
        }

        @Override
        public long limit() {
            return this.skip;
        }

        @Override
        public Iterator<?> downstreams() {
            return Arrays.asList(this.windows.toArray()).iterator();
        }

        @Override
        public long downstreamCount() {
            return this.windows.size();
        }

        @Override
        public long getCapacity() {
            return this.size;
        }

        @Override
        public long getPending() {
            return this.size - this.produced;
        }
    }

    static final class WindowSkipSubscriber<T>
    implements Subscriber<T>,
    Subscription,
    Disposable,
    Receiver,
    MultiProducer,
    Producer,
    Trackable {
        final Subscriber<? super Flux<T>> actual;
        final Supplier<? extends Queue<T>> processorQueueSupplier;
        final int size;
        final int skip;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<WindowSkipSubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(WindowSkipSubscriber.class, "wip");
        volatile int once;
        static final AtomicIntegerFieldUpdater<WindowSkipSubscriber> ONCE = AtomicIntegerFieldUpdater.newUpdater(WindowSkipSubscriber.class, "once");
        volatile int firstRequest;
        static final AtomicIntegerFieldUpdater<WindowSkipSubscriber> FIRST_REQUEST = AtomicIntegerFieldUpdater.newUpdater(WindowSkipSubscriber.class, "firstRequest");
        int index;
        Subscription s;
        UnicastProcessor<T> window;
        boolean done;

        public WindowSkipSubscriber(Subscriber<? super Flux<T>> actual, int size, int skip, Supplier<? extends Queue<T>> processorQueueSupplier) {
            this.actual = actual;
            this.size = size;
            this.skip = skip;
            this.processorQueueSupplier = processorQueueSupplier;
            this.wip = 1;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            int i = this.index;
            UnicastProcessor<T> w = this.window;
            if (i == 0) {
                Queue<T> q;
                WIP.getAndIncrement(this);
                try {
                    q = this.processorQueueSupplier.get();
                }
                catch (Throwable ex) {
                    WIP.decrementAndGet(this);
                    this.done = true;
                    this.cancel();
                    this.actual.onError(ex);
                    return;
                }
                if (q == null) {
                    WIP.decrementAndGet(this);
                    this.done = true;
                    this.cancel();
                    this.actual.onError((Throwable)new NullPointerException("The processorQueueSupplier returned a null queue"));
                    return;
                }
                w = new UnicastProcessor<T>(q, this);
                this.window = w;
                this.actual.onNext(w);
            }
            ++i;
            if (w != null) {
                w.onNext(t);
            }
            if (i == this.size) {
                this.window = null;
                if (w != null) {
                    w.onComplete();
                }
            }
            this.index = i == this.skip ? 0 : i;
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            UnicastProcessor<T> w = this.window;
            if (w != null) {
                this.window = null;
                w.onError(t);
            }
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            UnicastProcessor<T> w = this.window;
            if (w != null) {
                this.window = null;
                w.onComplete();
            }
            this.actual.onComplete();
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                if (this.firstRequest == 0 && FIRST_REQUEST.compareAndSet(this, 0, 1)) {
                    long u = Operators.multiplyCap(this.size, n);
                    long v = Operators.multiplyCap(this.skip - this.size, n - 1L);
                    long w = Operators.addCap(u, v);
                    this.s.request(w);
                } else {
                    long u = Operators.multiplyCap(this.skip, n);
                    this.s.request(u);
                }
            }
        }

        public void cancel() {
            if (ONCE.compareAndSet(this, 0, 1)) {
                this.dispose();
            }
        }

        @Override
        public void dispose() {
            if (WIP.decrementAndGet(this) == 0) {
                this.s.cancel();
            }
        }

        @Override
        public Object downstream() {
            return this.actual;
        }

        @Override
        public boolean isStarted() {
            return this.s != null && !this.done;
        }

        @Override
        public boolean isTerminated() {
            return this.done;
        }

        @Override
        public Object upstream() {
            return this.s;
        }

        @Override
        public Iterator<?> downstreams() {
            return Collections.singletonList(this.window).iterator();
        }

        @Override
        public long downstreamCount() {
            return this.window != null ? 1L : 0L;
        }

        @Override
        public long getCapacity() {
            return this.size;
        }

        @Override
        public long getPending() {
            return this.skip + this.size - this.index;
        }
    }

    static final class WindowExactSubscriber<T>
    implements Subscriber<T>,
    Subscription,
    Disposable,
    Producer,
    Receiver,
    MultiProducer,
    Trackable {
        final Subscriber<? super Flux<T>> actual;
        final Supplier<? extends Queue<T>> processorQueueSupplier;
        final int size;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<WindowExactSubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(WindowExactSubscriber.class, "wip");
        volatile int once;
        static final AtomicIntegerFieldUpdater<WindowExactSubscriber> ONCE = AtomicIntegerFieldUpdater.newUpdater(WindowExactSubscriber.class, "once");
        int index;
        Subscription s;
        UnicastProcessor<T> window;
        boolean done;

        public WindowExactSubscriber(Subscriber<? super Flux<T>> actual, int size, Supplier<? extends Queue<T>> processorQueueSupplier) {
            this.actual = actual;
            this.size = size;
            this.processorQueueSupplier = processorQueueSupplier;
            this.wip = 1;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            int i = this.index;
            UnicastProcessor<T> w = this.window;
            if (i == 0) {
                Queue<T> q;
                WIP.getAndIncrement(this);
                try {
                    q = this.processorQueueSupplier.get();
                }
                catch (Throwable ex) {
                    WIP.decrementAndGet(this);
                    this.done = true;
                    this.cancel();
                    this.actual.onError(ex);
                    return;
                }
                if (q == null) {
                    WIP.decrementAndGet(this);
                    this.done = true;
                    this.cancel();
                    this.actual.onError((Throwable)new NullPointerException("The processorQueueSupplier returned a null queue"));
                    return;
                }
                w = new UnicastProcessor<T>(q, this);
                this.window = w;
                this.actual.onNext(w);
            }
            w.onNext(t);
            if (++i == this.size) {
                this.index = 0;
                this.window = null;
                w.onComplete();
            } else {
                this.index = i;
            }
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            UnicastProcessor<T> w = this.window;
            if (w != null) {
                this.window = null;
                w.onError(t);
            }
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            UnicastProcessor<T> w = this.window;
            if (w != null) {
                this.window = null;
                w.onComplete();
            }
            this.actual.onComplete();
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                long u = Operators.multiplyCap(this.size, n);
                this.s.request(u);
            }
        }

        public void cancel() {
            if (ONCE.compareAndSet(this, 0, 1)) {
                this.dispose();
            }
        }

        @Override
        public void dispose() {
            if (WIP.decrementAndGet(this) == 0) {
                this.s.cancel();
            }
        }

        @Override
        public Object downstream() {
            return this.actual;
        }

        @Override
        public boolean isStarted() {
            return this.s != null && !this.done;
        }

        @Override
        public boolean isTerminated() {
            return this.done;
        }

        @Override
        public Object upstream() {
            return this.s;
        }

        @Override
        public Iterator<?> downstreams() {
            return Collections.singletonList(this.window).iterator();
        }

        @Override
        public long downstreamCount() {
            return this.window != null ? 1L : 0L;
        }

        @Override
        public long expectedFromUpstream() {
            return this.size - this.index;
        }

        @Override
        public long limit() {
            return this.size;
        }
    }
}

