/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Disposable;
import reactor.core.MultiProducer;
import reactor.core.Producer;
import reactor.core.Receiver;
import reactor.core.Trackable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.Operators;
import reactor.core.publisher.UnicastProcessor;

final class FluxWindowOnCancel<T>
extends FluxSource<T, Flux<T>> {
    final Supplier<? extends Queue<T>> processorQueueSupplier;

    public FluxWindowOnCancel(Publisher<? extends T> source, Supplier<? extends Queue<T>> processorQueueSupplier) {
        super(source);
        this.processorQueueSupplier = Objects.requireNonNull(processorQueueSupplier, "processorQueueSupplier");
    }

    @Override
    public void subscribe(Subscriber<? super Flux<T>> s) {
        this.source.subscribe(new WindowOnCancelSubscriber(s, this.processorQueueSupplier));
    }

    static final class WindowOnCancelSubscriber<T>
    implements Subscriber<T>,
    Subscription,
    Disposable,
    Producer,
    MultiProducer,
    Receiver,
    Trackable {
        final Subscriber<? super Flux<T>> actual;
        final Supplier<? extends Queue<T>> processorQueueSupplier;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<WindowOnCancelSubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(WindowOnCancelSubscriber.class, "wip");
        volatile int once;
        static final AtomicIntegerFieldUpdater<WindowOnCancelSubscriber> ONCE = AtomicIntegerFieldUpdater.newUpdater(WindowOnCancelSubscriber.class, "once");
        Subscription s;
        UnicastProcessor<T> window;
        boolean done;

        public WindowOnCancelSubscriber(Subscriber<? super Flux<T>> actual, Supplier<? extends Queue<T>> processorQueueSupplier) {
            this.actual = actual;
            this.processorQueueSupplier = processorQueueSupplier;
            this.wip = 1;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            UnicastProcessor<T> w = this.window;
            if (w == null || w.cancelled) {
                Queue<T> q;
                WIP.getAndIncrement(this);
                try {
                    q = this.processorQueueSupplier.get();
                }
                catch (Throwable ex) {
                    this.done = true;
                    this.cancel();
                    this.actual.onError(ex);
                    return;
                }
                if (q == null) {
                    this.done = true;
                    this.cancel();
                    this.actual.onError((Throwable)new NullPointerException("The processorQueueSupplier returned a null queue"));
                    return;
                }
                w = new UnicastProcessor<T>(q, this);
                this.window = w;
                this.actual.onNext(w);
            }
            w.onNext(t);
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            UnicastProcessor<T> w = this.window;
            if (w != null) {
                this.window = null;
                w.onError(t);
            }
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            UnicastProcessor<T> w = this.window;
            if (w != null) {
                this.window = null;
                w.onComplete();
            }
            this.actual.onComplete();
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                this.s.request(n);
            }
        }

        public void cancel() {
            if (ONCE.compareAndSet(this, 0, 1)) {
                this.dispose();
            }
        }

        @Override
        public void dispose() {
            if (WIP.decrementAndGet(this) == 0) {
                this.s.cancel();
            }
        }

        @Override
        public Object downstream() {
            return this.actual;
        }

        @Override
        public boolean isStarted() {
            return this.s != null && !this.done;
        }

        @Override
        public boolean isTerminated() {
            return this.done;
        }

        @Override
        public Object upstream() {
            return this.s;
        }

        @Override
        public Iterator<?> downstreams() {
            return Collections.singletonList(this.window).iterator();
        }

        @Override
        public long downstreamCount() {
            return this.window != null ? 1L : 0L;
        }
    }
}

