/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Disposable;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.Operators;
import reactor.core.publisher.UnicastProcessor;

final class FluxWindowStartEnd<T, U, V>
extends FluxSource<T, Flux<T>> {
    final Publisher<U> start;
    final Function<? super U, ? extends Publisher<V>> end;
    final Supplier<? extends Queue<Object>> drainQueueSupplier;
    final Supplier<? extends Queue<T>> processorQueueSupplier;

    public FluxWindowStartEnd(Publisher<? extends T> source, Publisher<U> start, Function<? super U, ? extends Publisher<V>> end, Supplier<? extends Queue<Object>> drainQueueSupplier, Supplier<? extends Queue<T>> processorQueueSupplier) {
        super(source);
        this.start = Objects.requireNonNull(start, "start");
        this.end = Objects.requireNonNull(end, "end");
        this.drainQueueSupplier = Objects.requireNonNull(drainQueueSupplier, "drainQueueSupplier");
        this.processorQueueSupplier = Objects.requireNonNull(processorQueueSupplier, "processorQueueSupplier");
    }

    @Override
    public long getPrefetch() {
        return Long.MAX_VALUE;
    }

    @Override
    public void subscribe(Subscriber<? super Flux<T>> s) {
        Queue<Object> q;
        try {
            q = this.drainQueueSupplier.get();
        }
        catch (Throwable e) {
            Operators.error(s, Operators.onOperatorError(e));
            return;
        }
        if (q == null) {
            Operators.error(s, Operators.onOperatorError(new NullPointerException("The drainQueueSupplier returned a null queue")));
            return;
        }
        WindowStartEndMainSubscriber main = new WindowStartEndMainSubscriber(s, q, this.end, this.processorQueueSupplier);
        s.onSubscribe(main);
        this.start.subscribe(main.starter);
        this.source.subscribe(main);
    }

    static final class NewWindow<U> {
        final U value;

        public NewWindow(U value) {
            this.value = value;
        }
    }

    static final class WindowStartEndEnder<T, V>
    extends Operators.DeferredSubscription
    implements Subscriber<V> {
        final WindowStartEndMainSubscriber<T, ?, V> main;
        final UnicastProcessor<T> window;

        public WindowStartEndEnder(WindowStartEndMainSubscriber<T, ?, V> main, UnicastProcessor<T> window) {
            this.main = main;
            this.window = window;
        }

        public void onSubscribe(Subscription s) {
            if (this.set(s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(V t) {
            this.cancel();
            this.main.endSignal(this);
        }

        public void onError(Throwable t) {
            this.main.endError(t);
        }

        public void onComplete() {
            this.main.endSignal(this);
        }
    }

    static final class WindowStartEndStarter<T, U, V>
    extends Operators.DeferredSubscription
    implements Subscriber<U> {
        final WindowStartEndMainSubscriber<T, U, V> main;

        public WindowStartEndStarter(WindowStartEndMainSubscriber<T, U, V> main) {
            this.main = main;
        }

        public void onSubscribe(Subscription s) {
            if (this.set(s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(U t) {
            this.main.starterNext(t);
        }

        public void onError(Throwable t) {
            this.main.starterError(t);
        }

        public void onComplete() {
            this.main.starterComplete();
        }
    }

    static final class WindowStartEndMainSubscriber<T, U, V>
    implements Subscriber<T>,
    Subscription,
    Disposable {
        final Subscriber<? super Flux<T>> actual;
        final Queue<Object> queue;
        final WindowStartEndStarter<T, U, V> starter;
        final Function<? super U, ? extends Publisher<V>> end;
        final Supplier<? extends Queue<T>> processorQueueSupplier;
        volatile long requested;
        static final AtomicLongFieldUpdater<WindowStartEndMainSubscriber> REQUESTED = AtomicLongFieldUpdater.newUpdater(WindowStartEndMainSubscriber.class, "requested");
        volatile int wip;
        static final AtomicIntegerFieldUpdater<WindowStartEndMainSubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(WindowStartEndMainSubscriber.class, "wip");
        volatile boolean cancelled;
        volatile Subscription s;
        static final AtomicReferenceFieldUpdater<WindowStartEndMainSubscriber, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(WindowStartEndMainSubscriber.class, Subscription.class, "s");
        volatile int once;
        static final AtomicIntegerFieldUpdater<WindowStartEndMainSubscriber> ONCE = AtomicIntegerFieldUpdater.newUpdater(WindowStartEndMainSubscriber.class, "once");
        volatile int open;
        static final AtomicIntegerFieldUpdater<WindowStartEndMainSubscriber> OPEN = AtomicIntegerFieldUpdater.newUpdater(WindowStartEndMainSubscriber.class, "open");
        Set<WindowStartEndEnder<T, V>> windowEnds;
        Set<UnicastProcessor<T>> windows;
        volatile boolean mainDone;
        volatile Throwable error;
        static final AtomicReferenceFieldUpdater<WindowStartEndMainSubscriber, Throwable> ERROR = AtomicReferenceFieldUpdater.newUpdater(WindowStartEndMainSubscriber.class, Throwable.class, "error");

        public WindowStartEndMainSubscriber(Subscriber<? super Flux<T>> actual, Queue<Object> queue, Function<? super U, ? extends Publisher<V>> end, Supplier<? extends Queue<T>> processorQueueSupplier) {
            this.actual = actual;
            this.queue = queue;
            this.starter = new WindowStartEndStarter(this);
            this.end = end;
            this.windowEnds = new HashSet<WindowStartEndEnder<T, V>>();
            this.windows = new HashSet<UnicastProcessor<T>>();
            this.processorQueueSupplier = processorQueueSupplier;
            this.open = 1;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.setOnce(S, this, s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(T t) {
            WindowStartEndMainSubscriber windowStartEndMainSubscriber = this;
            synchronized (windowStartEndMainSubscriber) {
                this.queue.offer(t);
            }
            this.drain();
        }

        public void onError(Throwable t) {
            if (Exceptions.addThrowable(ERROR, this, t)) {
                this.drain();
            } else {
                Operators.onErrorDropped(t);
            }
        }

        public void onComplete() {
            this.closeMain();
            this.starter.cancel();
            this.mainDone = true;
            this.drain();
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                Operators.getAndAddCap(REQUESTED, this, n);
            }
        }

        public void cancel() {
            this.cancelled = true;
            this.starter.cancel();
            this.closeMain();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void starterNext(U u) {
            NewWindow<U> nw = new NewWindow<U>(u);
            WindowStartEndMainSubscriber windowStartEndMainSubscriber = this;
            synchronized (windowStartEndMainSubscriber) {
                this.queue.offer(nw);
            }
            this.drain();
        }

        void starterError(Throwable e) {
            if (Exceptions.addThrowable(ERROR, this, e)) {
                this.drain();
            } else {
                Operators.onErrorDropped(e);
            }
        }

        void starterComplete() {
            this.closeMain();
            this.drain();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void endSignal(WindowStartEndEnder<T, V> end) {
            this.remove(end);
            WindowStartEndMainSubscriber windowStartEndMainSubscriber = this;
            synchronized (windowStartEndMainSubscriber) {
                this.queue.offer(end);
            }
            this.drain();
        }

        void endError(Throwable e) {
            if (Exceptions.addThrowable(ERROR, this, e)) {
                this.drain();
            } else {
                Operators.onErrorDropped(e);
            }
        }

        void closeMain() {
            if (ONCE.compareAndSet(this, 0, 1)) {
                this.dispose();
            }
        }

        @Override
        public void dispose() {
            if (OPEN.decrementAndGet(this) == 0) {
                Operators.terminate(S, this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean add(WindowStartEndEnder<T, V> ender) {
            WindowStartEndStarter<T, U, V> windowStartEndStarter = this.starter;
            synchronized (windowStartEndStarter) {
                Set<WindowStartEndEnder<T, V>> set = this.windowEnds;
                if (set != null) {
                    set.add(ender);
                    return true;
                }
            }
            ender.cancel();
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remove(WindowStartEndEnder<T, V> ender) {
            WindowStartEndStarter<T, U, V> windowStartEndStarter = this.starter;
            synchronized (windowStartEndStarter) {
                Set<WindowStartEndEnder<T, V>> set = this.windowEnds;
                if (set != null) {
                    set.remove(ender);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeAll() {
            Set<WindowStartEndEnder<T, V>> set;
            WindowStartEndStarter<T, U, V> windowStartEndStarter = this.starter;
            synchronized (windowStartEndStarter) {
                set = this.windowEnds;
                if (set == null) {
                    return;
                }
                this.windowEnds = null;
            }
            for (Subscription subscription : set) {
                subscription.cancel();
            }
        }

        void drain() {
            if (WIP.getAndIncrement(this) != 0) {
                return;
            }
            Subscriber<? super Flux<T>> a = this.actual;
            Queue<Object> q = this.queue;
            int missed = 1;
            block4: while (true) {
                Throwable e;
                if ((e = this.error) != null) {
                    e = Exceptions.terminate(ERROR, this);
                    if (e != Exceptions.TERMINATED) {
                        Operators.terminate(S, this);
                        this.starter.cancel();
                        this.removeAll();
                        for (UnicastProcessor<T> w : this.windows) {
                            w.onError(e);
                        }
                        this.windows = null;
                        q.clear();
                        a.onError(e);
                    }
                    return;
                }
                if (this.mainDone || this.open == 0) {
                    this.removeAll();
                    for (UnicastProcessor<T> w : this.windows) {
                        w.onComplete();
                    }
                    this.windows = null;
                    a.onComplete();
                    return;
                }
                Object o = q.poll();
                if (o != null) {
                    if (o instanceof NewWindow) {
                        Publisher<V> p;
                        Queue<T> pq;
                        if (this.cancelled || this.open == 0 || this.mainDone) continue;
                        NewWindow newWindow = (NewWindow)o;
                        try {
                            pq = this.processorQueueSupplier.get();
                        }
                        catch (Throwable ex) {
                            Exceptions.addThrowable(ERROR, this, Operators.onOperatorError(this.s, ex, newWindow.value));
                            continue;
                        }
                        if (pq == null) {
                            Exceptions.addThrowable(ERROR, this, Operators.onOperatorError(this.s, new NullPointerException("The processorQueueSupplier returned a null queue"), newWindow.value));
                            continue;
                        }
                        try {
                            p = this.end.apply(newWindow.value);
                        }
                        catch (Throwable ex) {
                            Exceptions.addThrowable(ERROR, this, Operators.onOperatorError(this.s, ex, newWindow.value));
                            continue;
                        }
                        if (p == null) {
                            Exceptions.addThrowable(ERROR, this, Operators.onOperatorError(this.s, new NullPointerException("The end returned a null publisher"), newWindow.value));
                            continue;
                        }
                        OPEN.getAndIncrement(this);
                        UnicastProcessor<T> w = new UnicastProcessor<T>(pq, this);
                        WindowStartEndEnder end = new WindowStartEndEnder(this, w);
                        this.windows.add(w);
                        if (!this.add(end)) continue;
                        long r = this.requested;
                        if (r != 0L) {
                            a.onNext(w);
                            if (r != Long.MAX_VALUE) {
                                REQUESTED.decrementAndGet(this);
                            }
                        } else {
                            Exceptions.addThrowable(ERROR, this, Exceptions.failWithOverflow("Could not emit window due to lack of requests"));
                            continue;
                        }
                        p.subscribe(end);
                        continue;
                    }
                    if (o instanceof WindowStartEndEnder) {
                        WindowStartEndEnder end = (WindowStartEndEnder)o;
                        end.window.onComplete();
                        continue;
                    }
                    Object v = o;
                    Iterator<UnicastProcessor<T>> iterator = this.windows.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block4;
                        UnicastProcessor<Object> w = iterator.next();
                        w.onNext(v);
                    }
                }
                if ((missed = WIP.addAndGet(this, -missed)) == 0) break;
            }
        }
    }
}

