/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.stream.LongStream;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Disposable;
import reactor.core.Fuseable;
import reactor.core.publisher.BlockingFirstSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxCallable;
import reactor.core.publisher.FluxFlatMap;
import reactor.core.publisher.FluxFlattenIterable;
import reactor.core.publisher.FluxMapSignal;
import reactor.core.publisher.FluxMaterialize;
import reactor.core.publisher.FluxPublishMulticast;
import reactor.core.publisher.FluxRepeat;
import reactor.core.publisher.FluxRepeatPredicate;
import reactor.core.publisher.FluxRepeatWhen;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.FluxZip;
import reactor.core.publisher.Hooks;
import reactor.core.publisher.LambdaFirstSubscriber;
import reactor.core.publisher.MonoAwaitOnSubscribe;
import reactor.core.publisher.MonoCallable;
import reactor.core.publisher.MonoCancelOn;
import reactor.core.publisher.MonoCompletableFuture;
import reactor.core.publisher.MonoCreate;
import reactor.core.publisher.MonoDefaultIfEmpty;
import reactor.core.publisher.MonoDefer;
import reactor.core.publisher.MonoDelay;
import reactor.core.publisher.MonoDelaySubscription;
import reactor.core.publisher.MonoDematerialize;
import reactor.core.publisher.MonoDetach;
import reactor.core.publisher.MonoDoFinally;
import reactor.core.publisher.MonoDoFinallyFuseable;
import reactor.core.publisher.MonoElapsed;
import reactor.core.publisher.MonoEmpty;
import reactor.core.publisher.MonoError;
import reactor.core.publisher.MonoFilter;
import reactor.core.publisher.MonoFilterFuseable;
import reactor.core.publisher.MonoFirst;
import reactor.core.publisher.MonoFlatMap;
import reactor.core.publisher.MonoHandle;
import reactor.core.publisher.MonoHandleFuseable;
import reactor.core.publisher.MonoHasElements;
import reactor.core.publisher.MonoHide;
import reactor.core.publisher.MonoIgnoreThen;
import reactor.core.publisher.MonoJust;
import reactor.core.publisher.MonoMap;
import reactor.core.publisher.MonoMapFuseable;
import reactor.core.publisher.MonoNever;
import reactor.core.publisher.MonoNext;
import reactor.core.publisher.MonoOtherwise;
import reactor.core.publisher.MonoOtherwiseIfEmpty;
import reactor.core.publisher.MonoPeek;
import reactor.core.publisher.MonoPeekFuseable;
import reactor.core.publisher.MonoPeekTerminal;
import reactor.core.publisher.MonoProcessor;
import reactor.core.publisher.MonoPublishOn;
import reactor.core.publisher.MonoRetry;
import reactor.core.publisher.MonoRetryPredicate;
import reactor.core.publisher.MonoRetryWhen;
import reactor.core.publisher.MonoRunnable;
import reactor.core.publisher.MonoSequenceEqual;
import reactor.core.publisher.MonoSink;
import reactor.core.publisher.MonoSource;
import reactor.core.publisher.MonoSubscribeOn;
import reactor.core.publisher.MonoSubscribeOnCallable;
import reactor.core.publisher.MonoSubscribeOnValue;
import reactor.core.publisher.MonoSupplier;
import reactor.core.publisher.MonoThenIgnore;
import reactor.core.publisher.MonoThenMap;
import reactor.core.publisher.MonoTimeout;
import reactor.core.publisher.MonoToCompletableFuture;
import reactor.core.publisher.MonoUsing;
import reactor.core.publisher.MonoWhen;
import reactor.core.publisher.Signal;
import reactor.core.publisher.SignalLogger;
import reactor.core.publisher.SignalType;
import reactor.core.publisher.SynchronousSink;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.core.scheduler.TimedScheduler;
import reactor.util.concurrent.QueueSupplier;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuple3;
import reactor.util.function.Tuple4;
import reactor.util.function.Tuple5;
import reactor.util.function.Tuple6;
import reactor.util.function.Tuples;

public abstract class Mono<T>
implements Publisher<T> {
    static final Function<? super Object[], Void> VOID_FUNCTION = t -> null;
    static final BiPredicate EQUALS_BIPREDICATE = Object::equals;

    public static <T> Mono<T> create(Consumer<MonoSink<T>> callback) {
        return Mono.onAssembly(new MonoCreate<T>(callback));
    }

    public static <T> Mono<T> defer(Supplier<? extends Mono<? extends T>> supplier) {
        return Mono.onAssembly(new MonoDefer(supplier));
    }

    public static Mono<Long> delay(Duration duration) {
        return Mono.delayMillis(duration.toMillis());
    }

    public static Mono<Long> delayMillis(long duration) {
        return Mono.delayMillis(duration, Schedulers.timer());
    }

    public static Mono<Long> delayMillis(long duration, TimedScheduler timer) {
        return Mono.onAssembly(new MonoDelay(duration, TimeUnit.MILLISECONDS, timer));
    }

    public static <T> Mono<T> empty() {
        return MonoEmpty.instance();
    }

    public static <T> Mono<Void> empty(Publisher<T> source) {
        MonoIgnoreThen<T> then = new MonoIgnoreThen<T>(source);
        return Mono.onAssembly(then);
    }

    public static <T> Mono<T> error(Throwable error) {
        return Mono.onAssembly(new MonoError(error));
    }

    @SafeVarargs
    public static <T> Mono<T> first(Mono<? extends T> ... monos) {
        return new MonoFirst<T>(monos);
    }

    public static <T> Mono<T> first(Iterable<? extends Mono<? extends T>> monos) {
        return new MonoFirst(monos);
    }

    public static <T> Mono<T> from(Publisher<? extends T> source) {
        if (source instanceof Mono) {
            Mono casted = (Mono)source;
            return casted;
        }
        if (source instanceof Fuseable.ScalarCallable) {
            Object t = ((Fuseable.ScalarCallable)source).call();
            if (t != null) {
                return Mono.just(t);
            }
            return Mono.empty();
        }
        return Mono.onAssembly(new MonoNext<T>(source));
    }

    public static <T> Mono<T> fromCallable(Callable<? extends T> supplier) {
        return Mono.onAssembly(new MonoCallable<T>(supplier));
    }

    public static <T> Mono<T> fromFuture(CompletableFuture<? extends T> future) {
        return Mono.onAssembly(new MonoCompletableFuture<T>(future));
    }

    public static Mono<Void> fromRunnable(Runnable runnable) {
        return Mono.onAssembly(new MonoRunnable(runnable));
    }

    public static <T> Mono<T> fromSupplier(Supplier<? extends T> supplier) {
        return Mono.onAssembly(new MonoSupplier<T>(supplier));
    }

    public static <T> Mono<T> ignoreElements(Publisher<T> source) {
        return Mono.onAssembly(new MonoIgnoreThen<T>(source));
    }

    public static <T> Mono<T> just(T data) {
        return Mono.onAssembly(new MonoJust<T>(data));
    }

    public static <T> Mono<T> justOrEmpty(Optional<? extends T> data) {
        return data != null && data.isPresent() ? Mono.just(data.get()) : Mono.empty();
    }

    public static <T> Mono<T> justOrEmpty(T data) {
        return data != null ? Mono.just(data) : Mono.empty();
    }

    public static <T> Mono<T> never() {
        return MonoNever.instance();
    }

    public static <T> Mono<Boolean> sequenceEqual(Publisher<? extends T> source1, Publisher<? extends T> source2) {
        return Mono.sequenceEqual(source1, source2, Mono.equalsBiPredicate(), QueueSupplier.SMALL_BUFFER_SIZE);
    }

    public static <T> Mono<Boolean> sequenceEqual(Publisher<? extends T> source1, Publisher<? extends T> source2, BiPredicate<? super T, ? super T> isEqual) {
        return Mono.sequenceEqual(source1, source2, isEqual, QueueSupplier.SMALL_BUFFER_SIZE);
    }

    public static <T> Mono<Boolean> sequenceEqual(Publisher<? extends T> source1, Publisher<? extends T> source2, BiPredicate<? super T, ? super T> isEqual, int bufferSize) {
        return Mono.onAssembly(new MonoSequenceEqual<T>(source1, source2, isEqual, bufferSize));
    }

    public static <T, D> Mono<T> using(Callable<? extends D> resourceSupplier, Function<? super D, ? extends Mono<? extends T>> sourceSupplier, Consumer<? super D> resourceCleanup, boolean eager) {
        return Mono.onAssembly(new MonoUsing(resourceSupplier, sourceSupplier, resourceCleanup, eager));
    }

    public static <T, D> Mono<T> using(Callable<? extends D> resourceSupplier, Function<? super D, ? extends Mono<? extends T>> sourceSupplier, Consumer<? super D> resourceCleanup) {
        return Mono.using(resourceSupplier, sourceSupplier, resourceCleanup, true);
    }

    public static <T1, T2> Mono<Tuple2<T1, T2>> when(Mono<? extends T1> p1, Mono<? extends T2> p2) {
        return Mono.when(p1, p2, Flux.tuple2Function());
    }

    public static <T1, T2, O> Mono<O> when(Mono<? extends T1> p1, Mono<? extends T2> p2, BiFunction<? super T1, ? super T2, ? extends O> combinator) {
        return Mono.onAssembly(new MonoWhen<T1, O>(false, p1, p2, combinator));
    }

    public static <T1, T2, T3> Mono<Tuple3<T1, T2, T3>> when(Mono<? extends T1> p1, Mono<? extends T2> p2, Mono<? extends T3> p3) {
        return Mono.onAssembly(new MonoWhen(false, a -> Tuples.fromArray((Object[])a), p1, p2, p3));
    }

    public static <T1, T2, T3, T4> Mono<Tuple4<T1, T2, T3, T4>> when(Mono<? extends T1> p1, Mono<? extends T2> p2, Mono<? extends T3> p3, Mono<? extends T4> p4) {
        return Mono.onAssembly(new MonoWhen(false, a -> Tuples.fromArray((Object[])a), p1, p2, p3, p4));
    }

    public static <T1, T2, T3, T4, T5> Mono<Tuple5<T1, T2, T3, T4, T5>> when(Mono<? extends T1> p1, Mono<? extends T2> p2, Mono<? extends T3> p3, Mono<? extends T4> p4, Mono<? extends T5> p5) {
        return Mono.onAssembly(new MonoWhen(false, a -> Tuples.fromArray((Object[])a), p1, p2, p3, p4, p5));
    }

    public static <T1, T2, T3, T4, T5, T6> Mono<Tuple6<T1, T2, T3, T4, T5, T6>> when(Mono<? extends T1> p1, Mono<? extends T2> p2, Mono<? extends T3> p3, Mono<? extends T4> p4, Mono<? extends T5> p5, Mono<? extends T6> p6) {
        return Mono.onAssembly(new MonoWhen(false, a -> Tuples.fromArray((Object[])a), p1, p2, p3, p4, p5, p6));
    }

    public static Mono<Void> when(Iterable<? extends Publisher<Void>> sources) {
        return Mono.onAssembly(new MonoWhen(false, VOID_FUNCTION, sources));
    }

    public static <R> Mono<R> when(Iterable<? extends Mono<?>> monos, Function<? super Object[], ? extends R> combinator) {
        return Mono.onAssembly(new MonoWhen(false, combinator, monos));
    }

    @SafeVarargs
    public static Mono<Void> when(Publisher<Void> ... sources) {
        if (sources.length == 0) {
            return Mono.empty();
        }
        if (sources.length == 1) {
            return Mono.from(sources[0]);
        }
        return Mono.onAssembly(new MonoWhen(false, VOID_FUNCTION, sources));
    }

    public static <R> Mono<R> when(Function<? super Object[], ? extends R> combinator, Mono<?> ... monos) {
        if (monos.length == 0) {
            return Mono.empty();
        }
        if (monos.length == 1) {
            return monos[0].map(d -> combinator.apply(new Object[]{d}));
        }
        return Mono.onAssembly(new MonoWhen(false, combinator, monos));
    }

    public static <T1, T2> Mono<Tuple2<T1, T2>> whenDelayError(Mono<? extends T1> p1, Mono<? extends T2> p2) {
        return Mono.onAssembly(new MonoWhen(true, a -> Tuples.fromArray((Object[])a), p1, p2));
    }

    public static <T1, T2, T3> Mono<Tuple3<T1, T2, T3>> whenDelayError(Mono<? extends T1> p1, Mono<? extends T2> p2, Mono<? extends T3> p3) {
        return Mono.onAssembly(new MonoWhen(true, a -> Tuples.fromArray((Object[])a), p2, p3));
    }

    public static <T1, T2, T3, T4> Mono<Tuple4<T1, T2, T3, T4>> whenDelayError(Mono<? extends T1> p1, Mono<? extends T2> p2, Mono<? extends T3> p3, Mono<? extends T4> p4) {
        return Mono.onAssembly(new MonoWhen(true, a -> Tuples.fromArray((Object[])a), p1, p2, p3, p4));
    }

    public static <T1, T2, T3, T4, T5> Mono<Tuple5<T1, T2, T3, T4, T5>> whenDelayError(Mono<? extends T1> p1, Mono<? extends T2> p2, Mono<? extends T3> p3, Mono<? extends T4> p4, Mono<? extends T5> p5) {
        return Mono.onAssembly(new MonoWhen(true, a -> Tuples.fromArray((Object[])a), p1, p2, p3, p4, p5));
    }

    public static <T1, T2, T3, T4, T5, T6> Mono<Tuple6<T1, T2, T3, T4, T5, T6>> whenDelayError(Mono<? extends T1> p1, Mono<? extends T2> p2, Mono<? extends T3> p3, Mono<? extends T4> p4, Mono<? extends T5> p5, Mono<? extends T6> p6) {
        return Mono.onAssembly(new MonoWhen(true, a -> Tuples.fromArray((Object[])a), p1, p2, p3, p4, p5, p6));
    }

    @SafeVarargs
    public static Mono<Void> whenDelayError(Publisher<Void> ... sources) {
        if (sources.length == 0) {
            return Mono.empty();
        }
        if (sources.length == 1) {
            return Mono.from(sources[0]);
        }
        return Mono.onAssembly(new MonoWhen(true, VOID_FUNCTION, sources));
    }

    public static <R> Mono<R> whenDelayError(Function<? super Object[], ? extends R> combinator, Mono<?> ... monos) {
        if (monos.length == 0) {
            return Mono.empty();
        }
        if (monos.length == 1) {
            return monos[0].map(d -> combinator.apply(new Object[]{d}));
        }
        return Mono.onAssembly(new MonoWhen(true, combinator, monos));
    }

    @SafeVarargs
    public static <T, V> Mono<V> zip(Function<? super Object[], ? extends V> combinator, Mono<? extends T> ... monos) {
        return MonoSource.wrap(new FluxZip<T, V>(monos, combinator, QueueSupplier.one(), 1));
    }

    public static <T, V> Mono<V> zip(Function<? super Object[], ? extends V> combinator, Iterable<? extends Mono<? extends T>> monos) {
        return MonoSource.wrap(new FluxZip(monos, combinator, QueueSupplier.one(), 1));
    }

    public final <P> P as(Function<? super Mono<T>, P> transformer) {
        return transformer.apply(this);
    }

    public final <T2> Mono<Tuple2<T, T2>> and(Mono<? extends T2> other) {
        return this.and(other, Flux.tuple2Function());
    }

    public final <T2, O> Mono<O> and(Mono<? extends T2> other, BiFunction<? super T, ? super T2, ? extends O> combinator) {
        MonoWhen o;
        Mono result;
        if (this instanceof MonoWhen && (result = (o = (MonoWhen)this).whenAdditionalSource(other, combinator)) != null) {
            return result;
        }
        return Mono.when(this, other, combinator);
    }

    public final <T2> Mono<Tuple2<T, T2>> and(Function<T, Mono<? extends T2>> rightGenerator) {
        return this.and(rightGenerator, Tuples::of);
    }

    public final <T2, O> Mono<O> and(Function<T, Mono<? extends T2>> rightGenerator, BiFunction<T, T2, O> combinator) {
        Objects.requireNonNull(rightGenerator, "rightGenerator function is mandatory to get the right-hand side Mono");
        Objects.requireNonNull(combinator, "combinator function is mandatory to combine results from both Monos");
        return this.then((? super T t) -> ((Mono)rightGenerator.apply(t)).map(t2 -> combinator.apply(t, t2)));
    }

    public final Mono<T> awaitOnSubscribe() {
        return Mono.onAssembly(new MonoAwaitOnSubscribe(this));
    }

    public T block() {
        BlockingFirstSubscriber subscriber = new BlockingFirstSubscriber();
        this.subscribe(subscriber);
        return subscriber.blockingGet();
    }

    public final T block(Duration timeout) {
        return this.blockMillis(timeout.toMillis());
    }

    public T blockMillis(long timeout) {
        BlockingFirstSubscriber subscriber = new BlockingFirstSubscriber();
        this.subscribe(subscriber);
        return subscriber.blockingGet(timeout, TimeUnit.MILLISECONDS);
    }

    public final <E> Mono<E> cast(Class<E> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        return this.map(clazz::cast);
    }

    public final Mono<T> cache() {
        return Mono.onAssembly(new MonoProcessor(this));
    }

    public final Mono<T> cancelOn(Scheduler scheduler) {
        return Mono.onAssembly(new MonoCancelOn(this, scheduler));
    }

    public final <V> Mono<V> compose(Function<? super Mono<T>, ? extends Publisher<V>> transformer) {
        return Mono.defer(() -> Mono.from((Publisher)transformer.apply(this)));
    }

    public final Flux<T> concatWith(Publisher<? extends T> other) {
        return Flux.concat(this, other);
    }

    public final Mono<T> defaultIfEmpty(T defaultV) {
        if (this instanceof Fuseable.ScalarCallable) {
            T v = this.block();
            if (v == null) {
                return Mono.just(defaultV);
            }
            return this;
        }
        return Mono.onAssembly(new MonoDefaultIfEmpty<T>(this, defaultV));
    }

    public final Mono<T> delaySubscription(Duration delay) {
        return this.delaySubscription(Mono.delay(delay));
    }

    public final <U> Mono<T> delaySubscription(Publisher<U> subscriptionDelay) {
        return Mono.onAssembly(new MonoDelaySubscription(this, subscriptionDelay));
    }

    public final Mono<T> delaySubscriptionMillis(long delay) {
        return this.delaySubscriptionMillis(delay, Schedulers.timer());
    }

    public final Mono<T> delaySubscriptionMillis(long delay, TimedScheduler timer) {
        return this.delaySubscription(Mono.delayMillis(delay, timer));
    }

    public final <X> Mono<X> dematerialize() {
        Mono thiz = this;
        return Mono.onAssembly(new MonoDematerialize(thiz));
    }

    public final Mono<T> doAfterTerminate(BiConsumer<? super T, Throwable> afterTerminate) {
        return Mono.onAssembly(new MonoPeekTerminal<T>(this, null, null, afterTerminate));
    }

    public final Mono<T> doFinally(Consumer<SignalType> onFinally) {
        Objects.requireNonNull(onFinally, "onFinally");
        MonoSource monoDoFinally = this instanceof Fuseable ? new MonoDoFinallyFuseable(this, onFinally) : new MonoDoFinally(this, onFinally);
        return Mono.onAssembly(monoDoFinally);
    }

    public final Mono<T> doOnCancel(Runnable onCancel) {
        Objects.requireNonNull(onCancel, "onCancel");
        return Mono.doOnSignal(this, null, null, null, null, null, null, onCancel);
    }

    public final Mono<T> doOnNext(Consumer<? super T> onNext) {
        Objects.requireNonNull(onNext, "onNext");
        return Mono.doOnSignal(this, null, onNext, null, null, null, null, null);
    }

    public final Mono<T> doOnSuccess(Consumer<? super T> onSuccess) {
        return Mono.onAssembly(new MonoPeekTerminal<T>(this, onSuccess, null, null));
    }

    public final Mono<T> doOnError(Consumer<? super Throwable> onError) {
        Objects.requireNonNull(onError, "onError");
        return Mono.doOnSignal(this, null, null, onError, null, null, null, null);
    }

    public final <E extends Throwable> Mono<T> doOnError(Class<E> exceptionType, Consumer<? super E> onError) {
        Objects.requireNonNull(exceptionType, "type");
        Consumer<? super E> handler = onError;
        return this.doOnError(exceptionType::isInstance, handler);
    }

    public final Mono<T> doOnError(Predicate<? super Throwable> predicate, Consumer<? super Throwable> onError) {
        Objects.requireNonNull(predicate, "predicate");
        return this.doOnError(t -> {
            if (predicate.test((Throwable)t)) {
                onError.accept((Throwable)t);
            }
        });
    }

    public final Mono<T> doOnRequest(LongConsumer consumer) {
        Objects.requireNonNull(consumer, "consumer");
        return Mono.doOnSignal(this, null, null, null, null, null, consumer, null);
    }

    public final Mono<T> doOnSubscribe(Consumer<? super Subscription> onSubscribe) {
        Objects.requireNonNull(onSubscribe, "onSubscribe");
        return Mono.doOnSignal(this, onSubscribe, null, null, null, null, null, null);
    }

    public final Mono<T> doOnTerminate(BiConsumer<? super T, Throwable> onTerminate) {
        Objects.requireNonNull(onTerminate, "onTerminate");
        return Mono.onAssembly(new MonoPeekTerminal<T>(this, null, onTerminate, null));
    }

    public final Mono<Tuple2<Long, T>> elapsed() {
        return this.elapsed(Schedulers.timer());
    }

    public final Mono<Tuple2<Long, T>> elapsed(TimedScheduler scheduler) {
        return Mono.onAssembly(new MonoElapsed(this, scheduler));
    }

    public final Mono<T> filter(Predicate<? super T> tester) {
        if (this instanceof Fuseable) {
            return Mono.onAssembly(new MonoFilterFuseable<T>(this, tester));
        }
        return Mono.onAssembly(new MonoFilter<T>(this, tester));
    }

    public final <R> Flux<R> flatMap(Function<? super T, ? extends Publisher<? extends R>> mapper) {
        return Flux.onAssembly(new MonoFlatMap(this, mapper));
    }

    public final <R> Flux<R> flatMap(Function<? super T, ? extends Publisher<? extends R>> mapperOnNext, Function<Throwable, ? extends Publisher<? extends R>> mapperOnError, Supplier<? extends Publisher<? extends R>> mapperOnComplete) {
        return Flux.onAssembly(new FluxFlatMap(new FluxMapSignal<T, Publisher<? extends R>>(this, mapperOnNext, mapperOnError, mapperOnComplete), Flux.identityFunction(), false, Integer.MAX_VALUE, QueueSupplier.xs(), QueueSupplier.XS_BUFFER_SIZE, QueueSupplier.xs()));
    }

    public final <R> Flux<R> flatMapIterable(Function<? super T, ? extends Iterable<? extends R>> mapper) {
        return Flux.onAssembly(new FluxFlattenIterable(this, mapper, Integer.MAX_VALUE, QueueSupplier.one()));
    }

    public final Flux<T> flux() {
        if (this instanceof Callable) {
            if (this instanceof Fuseable.ScalarCallable) {
                T v = this.block();
                if (v == null) {
                    return Flux.empty();
                }
                return Flux.just(v);
            }
            Callable thiz = (Callable)((Object)this);
            return Flux.onAssembly(new FluxCallable(thiz));
        }
        return FluxSource.wrap(this);
    }

    public final Mono<Boolean> hasElement() {
        return Mono.onAssembly(new MonoHasElements(this));
    }

    public final <R> Mono<R> handle(BiConsumer<? super T, SynchronousSink<R>> handler) {
        if (this instanceof Fuseable) {
            return Mono.onAssembly(new MonoHandleFuseable<T, R>(this, handler));
        }
        return Mono.onAssembly(new MonoHandle<T, R>(this, handler));
    }

    public final Mono<T> hide() {
        return Mono.onAssembly(new MonoHide(this));
    }

    public final Mono<T> ignoreElement() {
        return Mono.ignoreElements(this);
    }

    public final Mono<T> log() {
        return this.log(null, Level.INFO, new SignalType[0]);
    }

    public final Mono<T> log(String category) {
        return this.log(category, Level.INFO, new SignalType[0]);
    }

    public final Mono<T> log(String category, Level level, SignalType ... options) {
        return this.log(category, level, false, options);
    }

    public final Mono<T> log(String category, Level level, boolean showOperatorLine, SignalType ... options) {
        SignalLogger log = new SignalLogger(this, category, level, showOperatorLine, options);
        return Mono.doOnSignal(this, log.onSubscribeCall(), log.onNextCall(), log.onErrorCall(), log.onCompleteCall(), log.onAfterTerminateCall(), log.onRequestCall(), log.onCancelCall());
    }

    public final <R> Mono<R> map(Function<? super T, ? extends R> mapper) {
        if (this instanceof Fuseable) {
            return Mono.onAssembly(new MonoMapFuseable<T, R>(this, mapper));
        }
        return Mono.onAssembly(new MonoMap<T, R>(this, mapper));
    }

    public final Mono<T> mapError(Function<Throwable, ? extends Throwable> mapper) {
        return this.otherwise(e -> Mono.error((Throwable)mapper.apply((Throwable)e)));
    }

    public final <E extends Throwable> Mono<T> mapError(Class<E> type, Function<? super E, ? extends Throwable> mapper) {
        Function<? super E, ? extends Throwable> handler = mapper;
        return this.mapError(type::isInstance, handler);
    }

    public final Mono<T> mapError(Predicate<? super Throwable> predicate, Function<? super Throwable, ? extends Throwable> mapper) {
        return this.otherwise(predicate, (? super Throwable e) -> Mono.error((Throwable)mapper.apply((Throwable)e)));
    }

    public final Mono<Signal<T>> materialize() {
        return Mono.onAssembly(new FluxMaterialize(this).next());
    }

    public final Flux<T> mergeWith(Publisher<? extends T> other) {
        return Flux.merge(this, other);
    }

    public final Mono<T> or(Mono<? extends T> other) {
        if (this instanceof MonoFirst) {
            MonoFirst a = (MonoFirst)this;
            return a.orAdditionalSource(other);
        }
        return Mono.first(this, other);
    }

    public final <U> Mono<U> ofType(Class<U> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        return this.filter(o -> clazz.isAssignableFrom(o.getClass())).cast(clazz);
    }

    public final Mono<T> otherwise(Function<? super Throwable, ? extends Mono<? extends T>> fallback) {
        return Mono.onAssembly(new MonoOtherwise(this, fallback));
    }

    public final <E extends Throwable> Mono<T> otherwise(Class<E> type, Function<? super E, ? extends Mono<? extends T>> fallback) {
        Objects.requireNonNull(type, "type");
        Function<? super E, ? extends Mono<? extends T>> handler = fallback;
        return this.otherwise(type::isInstance, handler);
    }

    public final Mono<T> otherwise(Predicate<? super Throwable> predicate, Function<? super Throwable, ? extends Mono<? extends T>> fallback) {
        Objects.requireNonNull(predicate, "predicate");
        return this.otherwise(e -> predicate.test((Throwable)e) ? (Mono)fallback.apply((Throwable)e) : Mono.error(e));
    }

    public final Mono<T> otherwiseIfEmpty(Mono<? extends T> alternate) {
        return Mono.onAssembly(new MonoOtherwiseIfEmpty<T>(this, alternate));
    }

    public final Mono<T> otherwiseReturn(T fallback) {
        return this.otherwise(throwable -> Mono.just(fallback));
    }

    public final <E extends Throwable> Mono<T> otherwiseReturn(Class<E> type, T fallbackValue) {
        return this.otherwise(type, (? super E throwable) -> Mono.just(fallbackValue));
    }

    public final <E extends Throwable> Mono<T> otherwiseReturn(Predicate<? super Throwable> predicate, T fallbackValue) {
        return this.otherwise(predicate, (? super Throwable throwable) -> Mono.just(fallbackValue));
    }

    public final Mono<T> onTerminateDetach() {
        return new MonoDetach(this);
    }

    public final <R> Mono<R> publish(Function<? super Mono<T>, ? extends Mono<? extends R>> transform) {
        return MonoSource.wrap(new FluxPublishMulticast(this, f -> (Mono)transform.apply(Mono.from(f)), Integer.MAX_VALUE, QueueSupplier.one()));
    }

    public final Mono<T> publishOn(Scheduler scheduler) {
        if (this instanceof Fuseable.ScalarCallable) {
            T value = this.block();
            return Mono.onAssembly(new MonoSubscribeOnValue<T>(value, scheduler));
        }
        return Mono.onAssembly(new MonoPublishOn(this, scheduler));
    }

    public final Flux<T> repeat() {
        return this.repeat(Flux.ALWAYS_BOOLEAN_SUPPLIER);
    }

    public final Flux<T> repeat(BooleanSupplier predicate) {
        return Flux.onAssembly(new FluxRepeatPredicate(this, predicate));
    }

    public final Flux<T> repeat(long numRepeat) {
        return Flux.onAssembly(new FluxRepeat(this, numRepeat));
    }

    public final Flux<T> repeat(long numRepeat, BooleanSupplier predicate) {
        return Flux.defer(() -> this.repeat(Flux.countingBooleanSupplier(predicate, numRepeat)));
    }

    public final Flux<T> repeatWhen(Function<Flux<Long>, ? extends Publisher<?>> whenFactory) {
        return Flux.onAssembly(new FluxRepeatWhen(this, whenFactory));
    }

    public final Mono<T> repeatWhenEmpty(Function<Flux<Long>, ? extends Publisher<?>> repeatFactory) {
        return this.repeatWhenEmpty(Integer.MAX_VALUE, repeatFactory);
    }

    public final Mono<T> repeatWhenEmpty(int maxRepeat, Function<Flux<Long>, ? extends Publisher<?>> repeatFactory) {
        return Mono.defer(() -> {
            Flux<Long> iterations = maxRepeat == Integer.MAX_VALUE ? Flux.fromStream(LongStream.range(0L, Long.MAX_VALUE).mapToObj(Long::new)) : Flux.range(0, maxRepeat).map(Integer::longValue).concatWith(Flux.error(new IllegalStateException("Exceeded maximum number of repeats"), true));
            AtomicBoolean nonEmpty = new AtomicBoolean();
            return this.doOnSuccess(e -> nonEmpty.lazySet(e != null)).repeatWhen(o -> (Publisher)repeatFactory.apply(o.takeWhile(e -> !nonEmpty.get()).zipWith(iterations, 1, (c, i) -> i))).next();
        });
    }

    public final Mono<T> retry() {
        return this.retry(Long.MAX_VALUE);
    }

    public final Mono<T> retry(long numRetries) {
        return Mono.onAssembly(new MonoRetry(this, numRetries));
    }

    public final Mono<T> retry(Predicate<Throwable> retryMatcher) {
        return Mono.onAssembly(new MonoRetryPredicate(this, retryMatcher));
    }

    public final Mono<T> retry(long numRetries, Predicate<Throwable> retryMatcher) {
        return Mono.defer(() -> this.retry(Flux.countingPredicate(retryMatcher, numRetries)));
    }

    public final Mono<T> retryWhen(Function<Flux<Throwable>, ? extends Publisher<?>> whenFactory) {
        return Mono.onAssembly(new MonoRetryWhen(this, whenFactory));
    }

    public final MonoProcessor<T> subscribe() {
        MonoProcessor s = this instanceof MonoProcessor ? (MonoProcessor)this : new MonoProcessor(this);
        s.connect();
        return s;
    }

    public final Disposable subscribe(Consumer<? super T> consumer) {
        Objects.requireNonNull(consumer, "consumer");
        return this.subscribe(consumer, null, null);
    }

    public final Disposable subscribe(Consumer<? super T> consumer, Consumer<? super Throwable> errorConsumer) {
        Objects.requireNonNull(errorConsumer, "errorConsumer");
        return this.subscribe(consumer, errorConsumer, null);
    }

    public final Disposable subscribe(Consumer<? super T> consumer, Consumer<? super Throwable> errorConsumer, Runnable completeConsumer) {
        return this.subscribe(consumer, errorConsumer, completeConsumer, null);
    }

    public final Disposable subscribe(Consumer<? super T> consumer, Consumer<? super Throwable> errorConsumer, Runnable completeConsumer, Consumer<? super Subscription> subscriptionConsumer) {
        return this.subscribeWith(new LambdaFirstSubscriber<T>(consumer, errorConsumer, completeConsumer, subscriptionConsumer));
    }

    public final Mono<T> subscribeOn(Scheduler scheduler) {
        if (this instanceof Callable) {
            if (this instanceof Fuseable.ScalarCallable) {
                T value = this.block();
                return Mono.onAssembly(new MonoSubscribeOnValue<T>(value, scheduler));
            }
            Callable c = (Callable)((Object)this);
            return Mono.onAssembly(new MonoSubscribeOnCallable(c, scheduler));
        }
        return Mono.onAssembly(new MonoSubscribeOn(this, scheduler));
    }

    public final <E extends Subscriber<? super T>> E subscribeWith(E subscriber) {
        this.subscribe(subscriber);
        return subscriber;
    }

    public final Mono<Void> then() {
        return Mono.empty(this);
    }

    public final <R> Mono<R> then(Function<? super T, ? extends Mono<? extends R>> transformer) {
        return Mono.onAssembly(new MonoThenMap(this, transformer));
    }

    public final <V> Mono<V> then(Mono<V> other) {
        if (this instanceof MonoThenIgnore) {
            MonoThenIgnore a = (MonoThenIgnore)this;
            return a.shift(other);
        }
        return Mono.onAssembly(new MonoThenIgnore<V>(new Mono[]{this}, other));
    }

    public final <V> Mono<V> then(Supplier<? extends Mono<V>> sourceSupplier) {
        return this.then(Mono.defer(sourceSupplier));
    }

    public final Mono<Void> thenEmpty(Publisher<Void> other) {
        MonoIgnoreThen ignored = new MonoIgnoreThen(this);
        Mono<Void> then = ignored.then(MonoSource.wrap(other));
        return Mono.onAssembly(then);
    }

    public final <V> Flux<V> thenMany(Publisher<V> other) {
        Flux concat = Flux.concat(this.ignoreElement(), other);
        return Flux.onAssembly(concat);
    }

    public final <V> Flux<V> thenMany(Supplier<? extends Publisher<V>> afterSupplier) {
        return this.thenMany(Flux.defer(afterSupplier));
    }

    public final Mono<T> timeout(Duration timeout) {
        return this.timeoutMillis(timeout.toMillis());
    }

    public final Mono<T> timeout(Duration timeout, Mono<? extends T> fallback) {
        return this.timeoutMillis(timeout.toMillis(), fallback);
    }

    public final <U> Mono<T> timeout(Publisher<U> firstTimeout) {
        return Mono.onAssembly(new MonoTimeout(this, firstTimeout));
    }

    public final <U> Mono<T> timeout(Publisher<U> firstTimeout, Mono<? extends T> fallback) {
        return Mono.onAssembly(new MonoTimeout(this, firstTimeout, fallback));
    }

    public final Mono<T> timeoutMillis(long timeout) {
        return this.timeoutMillis(timeout, Schedulers.timer());
    }

    public final Mono<T> timeoutMillis(long timeout, TimedScheduler timer) {
        return this.timeoutMillis(timeout, null, timer);
    }

    public final Mono<T> timeoutMillis(long timeout, Mono<? extends T> fallback) {
        return this.timeoutMillis(timeout, fallback, Schedulers.timer());
    }

    public final Mono<T> timeoutMillis(long timeout, Mono<? extends T> fallback, TimedScheduler timer) {
        Mono<Long> _timer = Mono.delayMillis(timeout, timer).otherwiseReturn(0L);
        if (fallback == null) {
            return Mono.onAssembly(new MonoTimeout(this, _timer));
        }
        return Mono.onAssembly(new MonoTimeout(this, _timer, fallback));
    }

    public final Mono<Tuple2<Long, T>> timestamp() {
        return this.timestamp(Schedulers.timer());
    }

    public final Mono<Tuple2<Long, T>> timestamp(TimedScheduler scheduler) {
        return this.map(d -> Tuples.of(scheduler.now(TimeUnit.MILLISECONDS), d));
    }

    public final CompletableFuture<T> toFuture() {
        return this.subscribeWith(new MonoToCompletableFuture());
    }

    public final <V> Mono<V> transform(Function<? super Mono<T>, ? extends Publisher<V>> transformer) {
        return Mono.from(transformer.apply(this));
    }

    protected static <T> Mono<T> onAssembly(Mono<T> source) {
        Hooks.OnOperatorCreate<?> hook = Hooks.onOperatorCreate;
        if (hook == null) {
            return source;
        }
        return (Mono)hook.apply((Publisher<?>)source);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    static <T> Mono<T> doOnSignal(Publisher<T> source, Consumer<? super Subscription> onSubscribe, Consumer<? super T> onNext, Consumer<? super Throwable> onError, Runnable onComplete, Runnable onAfterTerminate, LongConsumer onRequest, Runnable onCancel) {
        if (source instanceof Fuseable) {
            return Mono.onAssembly(new MonoPeekFuseable<T>(source, onSubscribe, onNext, onError, onComplete, onAfterTerminate, onRequest, onCancel));
        }
        return Mono.onAssembly(new MonoPeek<T>(source, onSubscribe, onNext, onError, onComplete, onAfterTerminate, onRequest, onCancel));
    }

    static <T> BiPredicate<? super T, ? super T> equalsBiPredicate() {
        return EQUALS_BIPREDICATE;
    }
}

