/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Collection;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Fuseable;
import reactor.core.publisher.MonoSource;
import reactor.core.publisher.Operators;

final class MonoCollectList<T, C extends Collection<? super T>>
extends MonoSource<T, C>
implements Fuseable {
    final Supplier<C> collectionSupplier;

    protected MonoCollectList(Publisher<? extends T> source, Supplier<C> collectionSupplier) {
        super(source);
        this.collectionSupplier = collectionSupplier;
    }

    @Override
    public void subscribe(Subscriber<? super C> s) {
        Collection collection;
        try {
            collection = (Collection)this.collectionSupplier.get();
        }
        catch (Throwable ex) {
            Operators.error(s, Operators.onOperatorError(ex));
            return;
        }
        if (collection == null) {
            Operators.error(s, Operators.onOperatorError(new NullPointerException("The collectionSupplier returned a null collection")));
            return;
        }
        this.source.subscribe(new MonoBufferAllSubscriber(s, collection));
    }

    static final class MonoBufferAllSubscriber<T, C extends Collection<? super T>>
    extends Operators.MonoSubscriber<T, C>
    implements Subscriber<T>,
    Subscription {
        C collection;
        Subscription s;

        public MonoBufferAllSubscriber(Subscriber<? super C> actual, C collection) {
            super(actual);
            this.collection = collection;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t) {
            this.collection.add(t);
        }

        @Override
        public void onError(Throwable t) {
            C c = this.collection;
            if (c == null) {
                return;
            }
            this.collection = null;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            C c = this.collection;
            if (c == null) {
                return;
            }
            this.collection = null;
            this.complete(c);
        }

        @Override
        public void cancel() {
            super.cancel();
            this.s.cancel();
        }
    }
}

