/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.LongSupplier;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Disposable;
import reactor.core.Exceptions;
import reactor.core.MultiProducer;
import reactor.core.Producer;
import reactor.core.Receiver;
import reactor.core.Trackable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.core.publisher.ReplayProcessor;
import reactor.util.concurrent.WaitStrategy;

public final class MonoProcessor<O>
extends Mono<O>
implements Processor<O, O>,
Disposable,
Subscription,
Trackable,
Receiver,
Producer,
LongSupplier,
MultiProducer {
    final Publisher<? extends O> source;
    final WaitStrategy waitStrategy;
    Subscription subscription;
    volatile Processor<O, O> processor;
    volatile O value;
    volatile Throwable error;
    volatile int state;
    volatile int wip;
    volatile int requested;
    volatile int connected;
    static final MultiProducer EMPTY_MP = Collections::emptyIterator;
    static final NoopProcessor NOOP_PROCESSOR = new NoopProcessor();
    static final AtomicIntegerFieldUpdater<MonoProcessor> STATE = AtomicIntegerFieldUpdater.newUpdater(MonoProcessor.class, "state");
    static final AtomicIntegerFieldUpdater<MonoProcessor> WIP = AtomicIntegerFieldUpdater.newUpdater(MonoProcessor.class, "wip");
    static final AtomicIntegerFieldUpdater<MonoProcessor> CONNECTED = AtomicIntegerFieldUpdater.newUpdater(MonoProcessor.class, "connected");
    static final AtomicReferenceFieldUpdater<MonoProcessor, Processor> PROCESSOR = AtomicReferenceFieldUpdater.newUpdater(MonoProcessor.class, Processor.class, "processor");
    static final int STATE_CANCELLED = -1;
    static final int STATE_READY = 0;
    static final int STATE_SUBSCRIBED = 1;
    static final int STATE_POST_SUBSCRIBED = 2;
    static final int STATE_SUCCESS_VALUE = 3;
    static final int STATE_COMPLETE_NO_VALUE = 4;
    static final int STATE_ERROR = 5;

    public static <T> MonoProcessor<T> create() {
        return new MonoProcessor(null);
    }

    public static <T> MonoProcessor<T> create(WaitStrategy waitStrategy) {
        return new MonoProcessor(null, waitStrategy);
    }

    MonoProcessor(Publisher<? extends O> source) {
        this(source, WaitStrategy.sleeping());
    }

    MonoProcessor(Publisher<? extends O> source, WaitStrategy waitStrategy) {
        this.source = source;
        this.waitStrategy = Objects.requireNonNull(waitStrategy, "waitStrategy");
    }

    public final void cancel() {
        int state = this.state;
        while (true) {
            if (state != 0 && state != 1 && state != 2) {
                return;
            }
            if (STATE.compareAndSet(this, state, -1)) break;
            state = this.state;
        }
        if (WIP.getAndIncrement(this) == 0) {
            this.drainLoop();
        }
    }

    @Override
    public void dispose() {
        this.cancel();
    }

    public final Subscriber<O> downstream() {
        return this.processor;
    }

    @Override
    public long expectedFromUpstream() {
        return !this.isPending() ? 0L : ((long)this.requested != 0L ? 1L : 0L);
    }

    @Override
    public O block() {
        return this.blockMillis(300000L);
    }

    @Override
    public O blockMillis(long timeout) {
        try {
            if (!this.isPending()) {
                return this.peek();
            }
            if (this.subscription == null) {
                this.getOrStart();
            }
            long delay = System.nanoTime() + TimeUnit.NANOSECONDS.convert(timeout, TimeUnit.MILLISECONDS);
            try {
                long endState = this.waitStrategy.waitFor(3L, this, () -> {
                    if (delay < System.nanoTime()) {
                        throw Exceptions.failWithCancel();
                    }
                });
                switch ((int)endState) {
                    case 3: {
                        return this.value;
                    }
                    case 5: {
                        if (this.error instanceof RuntimeException) {
                            throw (RuntimeException)this.error;
                        }
                        throw Exceptions.propagate(this.error);
                    }
                    case 4: {
                        return null;
                    }
                }
                throw new IllegalStateException("Mono has been cancelled");
            }
            catch (RuntimeException ce) {
                if (Exceptions.isCancel(ce)) {
                    this.cancel();
                    throw new IllegalStateException("Timeout on Mono blocking read");
                }
                throw ce;
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Thread Interruption on Mono blocking read");
        }
    }

    @Override
    public final Throwable getError() {
        return this.error;
    }

    @Override
    public long getPending() {
        return this.isPending() ? 0L : 1L;
    }

    @Override
    public boolean isCancelled() {
        return this.state == -1;
    }

    public final boolean isError() {
        return this.state == 5;
    }

    @Override
    public final boolean isStarted() {
        return this.state > 0 && this.subscription != null && !this.isTerminated();
    }

    public final boolean isSuccess() {
        return this.state == 4 || this.state == 3;
    }

    @Override
    public final boolean isTerminated() {
        return this.state > 2;
    }

    @Override
    public boolean isDisposed() {
        return this.isTerminated();
    }

    @Override
    public long limit() {
        return 1L;
    }

    public final void onComplete() {
        this.onNext(null);
    }

    public final void onError(Throwable cause) {
        Subscription s = this.subscription;
        if (this.source != null && s == null || this.error != null) {
            Operators.onErrorDropped(cause);
            return;
        }
        this.error = cause;
        this.subscription = null;
        int state = this.state;
        while (true) {
            if (state != 0 && state != 1 && state != 2) {
                Operators.onErrorDropped(cause);
                return;
            }
            if (STATE.compareAndSet(this, state, 5)) break;
            state = this.state;
        }
        this.waitStrategy.signalAllWhenBlocking();
        if (WIP.getAndIncrement(this) == 0) {
            this.drainLoop();
        }
    }

    public final void onNext(O value) {
        int finalState;
        Subscription s = this.subscription;
        if (value != null && (this.source != null && s == null || this.value != null)) {
            Operators.onNextDropped(value);
            return;
        }
        this.subscription = null;
        if (value != null) {
            finalState = 3;
            this.value = value;
            if (s != null) {
                s.cancel();
            }
        } else {
            finalState = 4;
        }
        int state = this.state;
        while (true) {
            if (state != 0 && state != 1 && state != 2) {
                if (value != null) {
                    Operators.onNextDropped(value);
                }
                return;
            }
            if (STATE.compareAndSet(this, state, finalState)) break;
            state = this.state;
        }
        this.waitStrategy.signalAllWhenBlocking();
        if (WIP.getAndIncrement(this) == 0) {
            this.drainLoop();
        }
    }

    public final void onSubscribe(Subscription subscription) {
        if (Operators.validate(this.subscription, subscription)) {
            this.subscription = subscription;
            if (STATE.compareAndSet(this, 0, 1)) {
                subscription.request(Long.MAX_VALUE);
            }
            if (WIP.getAndIncrement(this) == 0) {
                this.drainLoop();
            }
        }
    }

    @Override
    public long getAsLong() {
        return this.state;
    }

    public O peek() {
        int endState = this.state;
        if (endState == 3) {
            return this.value;
        }
        if (endState == 5) {
            if (this.error instanceof RuntimeException) {
                throw (RuntimeException)this.error;
            }
            Operators.onErrorDropped(this.error);
            return null;
        }
        return null;
    }

    public final void request(long n) {
        try {
            Operators.checkRequest(n);
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            this.onError(e);
        }
        if (WIP.getAndIncrement(this) == 0) {
            this.drainLoop();
        }
    }

    public void subscribe(Subscriber<? super O> subscriber) {
        Processor<O, O> out;
        do {
            int endState;
            if ((endState = this.state) == 4) {
                Operators.complete(subscriber);
                return;
            }
            if (endState == 3) {
                subscriber.onSubscribe(new Operators.ScalarSubscription<O>(subscriber, this.value));
                return;
            }
            if (endState == 5) {
                Operators.error(subscriber, this.error);
                return;
            }
            if (endState != -1) continue;
            Operators.error(subscriber, new CancellationException("Mono has previously been cancelled"));
            return;
        } while ((out = this.getOrStart()) == NOOP_PROCESSOR);
        out.subscribe(subscriber);
        if (WIP.getAndIncrement(this) == 0) {
            this.drainLoop();
        }
    }

    @Override
    public final Object upstream() {
        return this.subscription;
    }

    final boolean isPending() {
        return !this.isTerminated() && !this.isCancelled();
    }

    final void connect() {
        if (CONNECTED.compareAndSet(this, 0, 1)) {
            if (this.source == null) {
                this.onSubscribe(Operators.emptySubscription());
            } else {
                this.source.subscribe((Subscriber)this);
            }
        }
    }

    final MultiProducer asMultiProducer() {
        if (this.processor instanceof MultiProducer) {
            return (MultiProducer)this.processor;
        }
        return EMPTY_MP;
    }

    @Override
    public Iterator<?> downstreams() {
        return this.asMultiProducer().downstreams();
    }

    @Override
    public long downstreamCount() {
        return this.asMultiProducer().downstreamCount();
    }

    @Override
    public boolean hasDownstreams() {
        return this.asMultiProducer().hasDownstreams();
    }

    final void drainLoop() {
        int missed = 1;
        do {
            Processor p;
            Processor p2;
            int state;
            if ((state = this.state) > 2 && (p2 = PROCESSOR.getAndSet(this, NOOP_PROCESSOR)) != NOOP_PROCESSOR && p2 != null) {
                switch (state) {
                    case 4: {
                        p2.onComplete();
                        break;
                    }
                    case 3: {
                        p2.onNext(this.value);
                        p2.onComplete();
                        break;
                    }
                    case 5: {
                        p2.onError(this.error);
                    }
                }
                return;
            }
            Subscription subscription = this.subscription;
            if (subscription != null && state == -1 && PROCESSOR.getAndSet(this, NOOP_PROCESSOR) != NOOP_PROCESSOR) {
                this.subscription = null;
                subscription.cancel();
                return;
            }
            if (state != 1 || !STATE.compareAndSet(this, 1, 2) || (p = PROCESSOR.get(this)) == null || p == NOOP_PROCESSOR) continue;
            p.onSubscribe((Subscription)this);
        } while ((missed = WIP.addAndGet(this, -missed)) != 0);
    }

    Processor<O, O> getOrStart() {
        ReplayProcessor<O> out = this.processor;
        if (out == null) {
            out = ReplayProcessor.cacheLastOrDefault(this.value);
            if (PROCESSOR.compareAndSet(this, null, out)) {
                this.connect();
            } else {
                out = PROCESSOR.get(this);
            }
        }
        return out;
    }

    static final class NoopProcessor
    implements Processor {
        NoopProcessor() {
        }

        public void onComplete() {
        }

        public void onError(Throwable t) {
        }

        public void onNext(Object o) {
        }

        public void onSubscribe(Subscription s) {
        }

        public void subscribe(Subscriber s) {
        }
    }
}

