/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.BiFunction;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Fuseable;
import reactor.core.publisher.MonoSource;
import reactor.core.publisher.Operators;

final class MonoReduce<T>
extends MonoSource<T, T>
implements Fuseable {
    final BiFunction<T, T, T> aggregator;

    public MonoReduce(Publisher<? extends T> source, BiFunction<T, T, T> aggregator) {
        super(source);
        this.aggregator = Objects.requireNonNull(aggregator, "aggregator");
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        this.source.subscribe(new AggregateSubscriber<T>(s, this.aggregator));
    }

    static final class AggregateSubscriber<T>
    extends Operators.MonoSubscriber<T, T> {
        final BiFunction<T, T, T> aggregator;
        Subscription s;
        T result;
        boolean done;

        public AggregateSubscriber(Subscriber<? super T> actual, BiFunction<T, T, T> aggregator) {
            super(actual);
            this.aggregator = aggregator;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            T r = this.result;
            if (r == null) {
                this.result = t;
            } else {
                try {
                    r = this.aggregator.apply(r, t);
                }
                catch (Throwable ex) {
                    this.result = null;
                    this.done = true;
                    this.actual.onError(Operators.onOperatorError(this.s, ex, t));
                    return;
                }
                if (r == null) {
                    this.result = null;
                    this.done = true;
                    this.actual.onError(Operators.onOperatorError(this.s, new NullPointerException("The aggregator returned a null value"), t));
                    return;
                }
                this.result = r;
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.result = null;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            T r = this.result;
            if (r != null) {
                this.complete(r);
            } else {
                this.actual.onComplete();
            }
        }

        @Override
        public void cancel() {
            super.cancel();
            this.s.cancel();
        }
    }
}

