/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.NoSuchElementException;
import java.util.Objects;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Fuseable;
import reactor.core.Receiver;
import reactor.core.publisher.MonoSource;
import reactor.core.publisher.Operators;

final class MonoSingle<T>
extends MonoSource<T, T>
implements Fuseable {
    final T defaultValue;
    final boolean completeOnEmpty;

    public MonoSingle(Publisher<? extends T> source) {
        super(source);
        this.defaultValue = null;
        this.completeOnEmpty = false;
    }

    public MonoSingle(Publisher<? extends T> source, T defaultValue, boolean completeOnEmpty) {
        super(source);
        this.defaultValue = completeOnEmpty ? defaultValue : Objects.requireNonNull(defaultValue, "defaultValue");
        this.completeOnEmpty = completeOnEmpty;
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        this.source.subscribe(new SingleSubscriber<T>(s, this.defaultValue, this.completeOnEmpty));
    }

    static final class SingleSubscriber<T>
    extends Operators.MonoSubscriber<T, T>
    implements Receiver {
        final T defaultValue;
        final boolean completeOnEmpty;
        Subscription s;
        int count;
        boolean done;

        public SingleSubscriber(Subscriber<? super T> actual, T defaultValue, boolean completeOnEmpty) {
            super(actual);
            this.defaultValue = defaultValue;
            this.completeOnEmpty = completeOnEmpty;
        }

        @Override
        public void request(long n) {
            super.request(n);
            if (n > 0L) {
                this.s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void cancel() {
            super.cancel();
            this.s.cancel();
        }

        @Override
        public void setValue(T value) {
            this.value = value;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            this.value = t;
            if (++this.count > 1) {
                this.cancel();
                this.onError(new IndexOutOfBoundsException("Source emitted more than one item"));
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            int c = this.count;
            if (c == 0) {
                if (this.completeOnEmpty) {
                    this.actual.onComplete();
                    return;
                }
                T t = this.defaultValue;
                if (t != null) {
                    this.complete(t);
                } else {
                    this.actual.onError(Operators.onOperatorError(this, new NoSuchElementException("Source was empty")));
                }
            } else if (c == 1) {
                this.complete(this.value);
            }
        }

        @Override
        public boolean isTerminated() {
            return this.done;
        }

        @Override
        public Object upstream() {
            return this.s;
        }

        @Override
        public Object connectedInput() {
            return this.value;
        }
    }
}

