/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.function.Supplier;
import reactor.core.publisher.NotFunRingBufferFields;
import reactor.core.publisher.RingBuffer;
import reactor.core.publisher.RingBufferProducer;

final class NotFunRingBuffer<E>
extends NotFunRingBufferFields<E> {
    NotFunRingBuffer(Supplier<E> eventFactory, RingBufferProducer sequenceProducer) {
        super(eventFactory, sequenceProducer);
    }

    @Override
    public E get(long sequence) {
        return this.elementAt(sequence);
    }

    @Override
    public long next() {
        return this.sequenceProducer.next();
    }

    @Override
    public long next(int n) {
        return this.sequenceProducer.next(n);
    }

    @Override
    public void addGatingSequence(RingBuffer.Sequence gatingSequence) {
        this.sequenceProducer.addGatingSequence(gatingSequence);
    }

    @Override
    public long getMinimumGatingSequence() {
        return this.getMinimumGatingSequence(null);
    }

    @Override
    public long getMinimumGatingSequence(RingBuffer.Sequence sequence) {
        return this.sequenceProducer.getMinimumSequence(sequence);
    }

    @Override
    public boolean removeGatingSequence(RingBuffer.Sequence sequence) {
        return this.sequenceProducer.removeGatingSequence(sequence);
    }

    @Override
    public RingBuffer.Reader newReader() {
        return this.sequenceProducer.newBarrier();
    }

    @Override
    public long getCursor() {
        return this.sequenceProducer.getCursor();
    }

    @Override
    public RingBuffer.Sequence getSequence() {
        return this.sequenceProducer.getSequence();
    }

    @Override
    public int bufferSize() {
        return this.bufferSize;
    }

    @Override
    public void publish(long sequence) {
        this.sequenceProducer.publish(sequence);
    }

    @Override
    public void publish(long lo, long hi) {
        this.sequenceProducer.publish(lo, hi);
    }

    @Override
    public long remainingCapacity() {
        return this.sequenceProducer.remainingCapacity();
    }

    @Override
    public int getPending() {
        return (int)this.sequenceProducer.getPending();
    }

    @Override
    public RingBufferProducer getSequencer() {
        return this.sequenceProducer;
    }
}

