/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Fuseable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxArray;
import reactor.core.publisher.GroupedFlux;
import reactor.core.publisher.Operators;
import reactor.core.publisher.ParallelFlux;

final class ParallelGroup<T>
extends Flux<GroupedFlux<Integer, T>>
implements Fuseable {
    final ParallelFlux<? extends T> source;

    public ParallelGroup(ParallelFlux<? extends T> source) {
        this.source = source;
    }

    public void subscribe(Subscriber<? super GroupedFlux<Integer, T>> s) {
        int n = this.source.parallelism();
        ParallelInnerGroup[] groups = new ParallelInnerGroup[n];
        for (int i = 0; i < n; ++i) {
            groups[i] = new ParallelInnerGroup(i);
        }
        FluxArray.subscribe(s, groups);
        this.source.subscribe(groups);
    }

    static final class ParallelInnerGroup<T>
    extends GroupedFlux<Integer, T>
    implements Subscriber<T>,
    Subscription {
        final int key;
        volatile int once;
        static final AtomicIntegerFieldUpdater<ParallelInnerGroup> ONCE = AtomicIntegerFieldUpdater.newUpdater(ParallelInnerGroup.class, "once");
        volatile Subscription s;
        static final AtomicReferenceFieldUpdater<ParallelInnerGroup, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(ParallelInnerGroup.class, Subscription.class, "s");
        volatile long requested;
        static final AtomicLongFieldUpdater<ParallelInnerGroup> REQUESTED = AtomicLongFieldUpdater.newUpdater(ParallelInnerGroup.class, "requested");
        Subscriber<? super T> actual;

        public ParallelInnerGroup(int key) {
            this.key = key;
        }

        @Override
        public Integer key() {
            return this.key;
        }

        public void subscribe(Subscriber<? super T> s) {
            if (ONCE.compareAndSet(this, 0, 1)) {
                this.actual = s;
                s.onSubscribe((Subscription)this);
            } else {
                Operators.error(s, new IllegalStateException("This ParallelGroup can be subscribed to at most once."));
            }
        }

        public void onSubscribe(Subscription s) {
            long r;
            if (Operators.setOnce(S, this, s) && (r = REQUESTED.getAndSet(this, 0L)) != 0L) {
                s.request(r);
            }
        }

        public void onNext(T t) {
            this.actual.onNext(t);
        }

        public void onError(Throwable t) {
            this.actual.onError(t);
        }

        public void onComplete() {
            this.actual.onComplete();
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                Subscription a = this.s;
                if (a == null) {
                    long r;
                    Operators.getAndAddCap(REQUESTED, this, n);
                    a = this.s;
                    if (a != null && (r = REQUESTED.getAndSet(this, 0L)) != 0L) {
                        a.request(n);
                    }
                } else {
                    a.request(n);
                }
            }
        }

        public void cancel() {
            Operators.terminate(S, this);
        }
    }
}

