/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.time.Duration;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Fuseable;
import reactor.core.MultiProducer;
import reactor.core.Producer;
import reactor.core.Receiver;
import reactor.core.Trackable;
import reactor.core.publisher.FluxProcessor;
import reactor.core.publisher.Operators;
import reactor.core.scheduler.Schedulers;
import reactor.core.scheduler.TimedScheduler;
import reactor.util.concurrent.QueueSupplier;

public final class ReplayProcessor<T>
extends FluxProcessor<T, T>
implements Fuseable,
MultiProducer,
Receiver {
    final ReplayBuffer<T> buffer;
    Subscription subscription;
    volatile ReplaySubscription<T>[] subscribers;
    static final AtomicReferenceFieldUpdater<ReplayProcessor, ReplaySubscription[]> SUBSCRIBERS = AtomicReferenceFieldUpdater.newUpdater(ReplayProcessor.class, ReplaySubscription[].class, "subscribers");
    static final ReplaySubscription[] EMPTY = new ReplaySubscription[0];
    static final ReplaySubscription[] TERMINATED = new ReplaySubscription[0];

    public static <T> ReplayProcessor<T> cacheLast() {
        return ReplayProcessor.cacheLastOrDefault(null);
    }

    public static <T> ReplayProcessor<T> cacheLastOrDefault(T value) {
        ReplayProcessor b = ReplayProcessor.create(1);
        if (value != null) {
            b.onNext(value);
        }
        return b;
    }

    public static <E> ReplayProcessor<E> create() {
        return ReplayProcessor.create(QueueSupplier.SMALL_BUFFER_SIZE, true);
    }

    public static <E> ReplayProcessor<E> create(int historySize) {
        return ReplayProcessor.create(historySize, false);
    }

    public static <E> ReplayProcessor<E> create(int historySize, boolean unbounded) {
        ReplayBuffer buffer = unbounded ? new UnboundedReplayBuffer(historySize) : new SizeBoundReplayBuffer(historySize);
        return new ReplayProcessor(buffer);
    }

    public static <T> ReplayProcessor<T> createTimeout(Duration maxAge) {
        return ReplayProcessor.createTimeoutMillis(maxAge.toMillis(), Schedulers.timer());
    }

    public static <T> ReplayProcessor<T> createTimeoutMillis(long maxAge, TimedScheduler scheduler) {
        return ReplayProcessor.createSizeAndTimeoutMillis(Integer.MAX_VALUE, maxAge, scheduler);
    }

    public static <T> ReplayProcessor<T> createSizeAndTimeout(int size, Duration maxAge) {
        return ReplayProcessor.createSizeAndTimeoutMillis(size, maxAge.toMillis(), Schedulers.timer());
    }

    public static <T> ReplayProcessor<T> createSizeAndTimeoutMillis(int size, long maxAge, TimedScheduler scheduler) {
        Objects.requireNonNull(scheduler, "scheduler is null");
        if (size <= 0) {
            throw new IllegalArgumentException("size > 0 required but it was " + size);
        }
        return new ReplayProcessor(new SizeAndTimeBoundReplayBuffer(size, maxAge, scheduler));
    }

    ReplayProcessor(ReplayBuffer<T> buffer) {
        this.buffer = buffer;
        SUBSCRIBERS.lazySet(this, EMPTY);
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        ReplayProcessorSubscription<T> rs = new ReplayProcessorSubscription<T>(s, this);
        s.onSubscribe(rs);
        if (this.add(rs) && rs.isCancelled()) {
            this.remove(rs);
            return;
        }
        this.buffer.replay(rs);
    }

    @Override
    public Iterator<?> downstreams() {
        return Arrays.asList(this.subscribers).iterator();
    }

    @Override
    public long downstreamCount() {
        return this.subscribers.length;
    }

    @Override
    public long getCapacity() {
        return this.buffer.capacity();
    }

    @Override
    public boolean isTerminated() {
        return this.buffer.isDone();
    }

    @Override
    public boolean isStarted() {
        return this.subscription != null;
    }

    @Override
    public Object upstream() {
        return this.subscription;
    }

    boolean add(ReplaySubscription<T> rs) {
        ReplayProcessorSubscription[] b;
        ReplaySubscription<T>[] a;
        do {
            if ((a = this.subscribers) == TERMINATED) {
                return false;
            }
            int n = a.length;
            b = new ReplayProcessorSubscription[n + 1];
            System.arraycopy(a, 0, b, 0, n);
            b[n] = rs;
        } while (!SUBSCRIBERS.compareAndSet(this, a, b));
        return true;
    }

    void remove(ReplaySubscription<T> rs) {
        block0: while (true) {
            ReplaySubscription<T>[] a;
            if ((a = this.subscribers) == TERMINATED || a == EMPTY) {
                return;
            }
            int n = a.length;
            for (int i = 0; i < n; ++i) {
                ReplaySubscription[] b;
                if (a[i] != rs) continue;
                if (n == 1) {
                    b = EMPTY;
                } else {
                    b = new ReplayProcessorSubscription[n - 1];
                    System.arraycopy(a, 0, b, 0, i);
                    System.arraycopy(a, i + 1, b, i, n - i - 1);
                }
                if (!SUBSCRIBERS.compareAndSet(this, a, b)) continue block0;
                return;
            }
            break;
        }
    }

    public void onSubscribe(Subscription s) {
        if (this.buffer.isDone()) {
            s.cancel();
        } else {
            if (!Operators.validate(this.subscription, s)) {
                s.cancel();
                return;
            }
            this.subscription = s;
            s.request(Long.MAX_VALUE);
        }
    }

    @Override
    public long getPrefetch() {
        return Long.MAX_VALUE;
    }

    public void onNext(T t) {
        ReplayBuffer<T> b = this.buffer;
        if (b.isDone()) {
            Operators.onNextDropped(t);
        } else {
            b.add(t);
            for (ReplaySubscription<T> rs : this.subscribers) {
                b.replay(rs);
            }
        }
    }

    public void onError(Throwable t) {
        ReplayBuffer<T> b = this.buffer;
        if (b.isDone()) {
            Operators.onErrorDropped(t);
        } else {
            ReplaySubscription[] a;
            b.onError(t);
            for (ReplaySubscription rs : a = SUBSCRIBERS.getAndSet(this, TERMINATED)) {
                b.replay(rs);
            }
        }
    }

    public void onComplete() {
        ReplayBuffer<T> b = this.buffer;
        if (!b.isDone()) {
            ReplaySubscription[] a;
            b.onComplete();
            for (ReplaySubscription rs : a = SUBSCRIBERS.getAndSet(this, TERMINATED)) {
                b.replay(rs);
            }
        }
    }

    public ReplayProcessor<T> connect() {
        this.onSubscribe(Operators.emptySubscription());
        return this;
    }

    static final class ReplayProcessorSubscription<T>
    implements Fuseable.QueueSubscription<T>,
    Producer,
    ReplaySubscription<T>,
    Receiver {
        final Subscriber<? super T> actual;
        final ReplayProcessor<T> parent;
        final ReplayBuffer<T> buffer;
        int index;
        int tailIndex;
        Object node;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<ReplayProcessorSubscription> WIP = AtomicIntegerFieldUpdater.newUpdater(ReplayProcessorSubscription.class, "wip");
        volatile long requested;
        static final AtomicLongFieldUpdater<ReplayProcessorSubscription> REQUESTED = AtomicLongFieldUpdater.newUpdater(ReplayProcessorSubscription.class, "requested");
        volatile boolean cancelled;
        int fusionMode;

        public ReplayProcessorSubscription(Subscriber<? super T> actual, ReplayProcessor<T> parent) {
            this.actual = actual;
            this.parent = parent;
            this.buffer = parent.buffer;
        }

        @Override
        public long requestedFromDownstream() {
            return this.requested;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public Subscriber<? super T> downstream() {
            return this.actual;
        }

        @Override
        public Object upstream() {
            return this.parent;
        }

        @Override
        public int requestFusion(int requestedMode) {
            if ((requestedMode & 2) != 0) {
                this.fusionMode = 2;
                return 2;
            }
            return 0;
        }

        @Override
        public T poll() {
            return this.buffer.poll(this);
        }

        @Override
        public void clear() {
            this.buffer.clear(this);
        }

        @Override
        public boolean isEmpty() {
            return this.buffer.isEmpty(this);
        }

        @Override
        public int size() {
            return this.buffer.size(this);
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                if (this.fusionMode() == 0) {
                    Operators.getAndAddCap(REQUESTED, this, n);
                }
                this.buffer.replay(this);
            }
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.parent.remove(this);
                if (this.enter()) {
                    this.node = null;
                }
            }
        }

        @Override
        public void node(Object node) {
            this.node = node;
        }

        @Override
        public int fusionMode() {
            return this.fusionMode;
        }

        @Override
        public Object node() {
            return this.node;
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public void index(int index) {
            this.index = index;
        }

        @Override
        public int tailIndex() {
            return this.tailIndex;
        }

        @Override
        public void tailIndex(int tailIndex) {
            this.tailIndex = tailIndex;
        }

        @Override
        public boolean enter() {
            return WIP.getAndIncrement(this) == 0;
        }

        @Override
        public int leave(int missed) {
            return WIP.addAndGet(this, -missed);
        }

        @Override
        public void produced(long n) {
            REQUESTED.addAndGet(this, -n);
        }
    }

    static interface ReplaySubscription<T>
    extends Producer,
    Trackable,
    Fuseable.QueueSubscription<T> {
        public Subscriber<? super T> downstream();

        public boolean enter();

        public int leave(int var1);

        public void produced(long var1);

        public void node(Object var1);

        public Object node();

        public int tailIndex();

        public void tailIndex(int var1);

        public int index();

        public void index(int var1);

        public int fusionMode();
    }

    static final class SizeAndTimeBoundReplayBuffer<T>
    implements ReplayBuffer<T> {
        final int limit;
        final long maxAge;
        final TimedScheduler scheduler;
        int size;
        volatile TimedNode<T> head;
        TimedNode<T> tail;
        Throwable error;
        volatile boolean done;

        public SizeAndTimeBoundReplayBuffer(int limit, long maxAge, TimedScheduler scheduler) {
            this.limit = limit;
            this.maxAge = maxAge;
            this.scheduler = scheduler;
            TimedNode<Object> h = new TimedNode<Object>(null, 0L);
            this.tail = h;
            this.head = h;
        }

        void replayNormal(ReplaySubscription<T> rs) {
            int missed = 1;
            Subscriber<T> a = rs.downstream();
            do {
                boolean d;
                long e;
                TimedNode node;
                if ((node = (TimedNode)rs.node()) == null) {
                    node = this.head;
                    if (!this.done) {
                        long ts;
                        long limit = this.scheduler.now(TimeUnit.MILLISECONDS) - this.maxAge;
                        TimedNode next = node;
                        while (next != null && (ts = next.time) <= limit) {
                            node = next;
                            next = (TimedNode)node.get();
                        }
                    }
                }
                long r = rs.requestedFromDownstream();
                for (e = 0L; e != r; ++e) {
                    boolean empty;
                    if (rs.isCancelled()) {
                        rs.node(null);
                        return;
                    }
                    d = this.done;
                    TimedNode next = (TimedNode)node.get();
                    boolean bl = empty = next == null;
                    if (d && empty) {
                        rs.node(null);
                        Throwable ex = this.error;
                        if (ex != null) {
                            a.onError(ex);
                        } else {
                            a.onComplete();
                        }
                        return;
                    }
                    if (empty) break;
                    a.onNext(next.value);
                    node = next;
                }
                if (e == r) {
                    boolean empty;
                    if (rs.isCancelled()) {
                        rs.node(null);
                        return;
                    }
                    d = this.done;
                    boolean bl = empty = node.get() == null;
                    if (d && empty) {
                        rs.node(null);
                        Throwable ex = this.error;
                        if (ex != null) {
                            a.onError(ex);
                        } else {
                            a.onComplete();
                        }
                        return;
                    }
                }
                if (e != 0L && r != Long.MAX_VALUE) {
                    rs.produced(e);
                }
                rs.node(node);
            } while ((missed = rs.leave(missed)) != 0);
        }

        void replayFused(ReplaySubscription<T> rs) {
            int missed = 1;
            Subscriber<T> a = rs.downstream();
            do {
                if (rs.isCancelled()) {
                    rs.node(null);
                    return;
                }
                boolean d = this.done;
                a.onNext(null);
                if (!d) continue;
                Throwable ex = this.error;
                if (ex != null) {
                    a.onError(ex);
                } else {
                    a.onComplete();
                }
                return;
            } while ((missed = rs.leave(missed)) != 0);
        }

        @Override
        public void onError(Throwable ex) {
            this.done = true;
            this.error = ex;
        }

        @Override
        public Throwable getError() {
            return this.error;
        }

        @Override
        public void onComplete() {
            this.done = true;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        TimedNode<T> latestHead(ReplaySubscription<T> rs) {
            TimedNode n;
            long now = this.scheduler.now(TimeUnit.MILLISECONDS) - this.maxAge;
            TimedNode h = (TimedNode)rs.node();
            if (h == null) {
                h = this.head;
            }
            while ((n = (TimedNode)h.get()) != null && n.time <= now) {
                h = n;
            }
            return h;
        }

        @Override
        public T poll(ReplaySubscription<T> rs) {
            TimedNode next;
            TimedNode node = this.latestHead(rs);
            long now = this.scheduler.now(TimeUnit.MILLISECONDS) - this.maxAge;
            while ((next = (TimedNode)node.get()) != null) {
                if (next.time > now) {
                    node = next;
                    break;
                }
                node = next;
            }
            if (next == null) {
                return null;
            }
            rs.node(next);
            return node.value;
        }

        @Override
        public void clear(ReplaySubscription<T> rs) {
            rs.node(null);
        }

        @Override
        public boolean isEmpty(ReplaySubscription<T> rs) {
            TimedNode<T> node = this.latestHead(rs);
            return node.get() == null;
        }

        @Override
        public int size(ReplaySubscription<T> rs) {
            TimedNode next;
            int count;
            TimedNode node = this.latestHead(rs);
            for (count = 0; (next = (TimedNode)node.get()) != null && count != Integer.MAX_VALUE; ++count) {
                node = next;
            }
            return count;
        }

        @Override
        public int size() {
            TimedNode next;
            int count;
            TimedNode node = this.head;
            for (count = 0; (next = (TimedNode)node.get()) != null && count != Integer.MAX_VALUE; ++count) {
                node = next;
            }
            return count;
        }

        @Override
        public int capacity() {
            return this.limit;
        }

        @Override
        public void add(T value) {
            TimedNode next;
            TimedNode<T> n = new TimedNode<T>(value, this.scheduler.now(TimeUnit.MILLISECONDS));
            this.tail.set(n);
            this.tail = n;
            int s = this.size;
            if (s == this.limit) {
                this.head = (TimedNode)this.head.get();
            } else {
                this.size = s + 1;
            }
            long limit = this.scheduler.now(TimeUnit.MILLISECONDS) - this.maxAge;
            TimedNode h = this.head;
            int removed = 0;
            while ((next = (TimedNode)h.get()) != null) {
                if (next.time > limit) {
                    if (removed == 0) break;
                    this.size -= removed;
                    this.head = h;
                    break;
                }
                h = next;
                ++removed;
            }
        }

        @Override
        public void replay(ReplaySubscription<T> rs) {
            if (!rs.enter()) {
                return;
            }
            if (rs.fusionMode() == 0) {
                this.replayNormal(rs);
            } else {
                this.replayFused(rs);
            }
        }

        static final class TimedNode<T>
        extends AtomicReference<TimedNode<T>> {
            final T value;
            final long time;

            public TimedNode(T value, long time) {
                this.value = value;
                this.time = time;
            }
        }
    }

    static final class SizeBoundReplayBuffer<T>
    implements ReplayBuffer<T> {
        final int limit;
        volatile Node<T> head;
        Node<T> tail;
        int size;
        volatile boolean done;
        Throwable error;

        public SizeBoundReplayBuffer(int limit) {
            this.limit = limit;
            Node<Object> n = new Node<Object>(null);
            this.tail = n;
            this.head = n;
        }

        @Override
        public int capacity() {
            return this.limit;
        }

        @Override
        public void add(T value) {
            Node<T> n = new Node<T>(value);
            this.tail.set(n);
            this.tail = n;
            int s = this.size;
            if (s == this.limit) {
                this.head = (Node)this.head.get();
            } else {
                this.size = s + 1;
            }
        }

        @Override
        public void onError(Throwable ex) {
            this.error = ex;
            this.done = true;
        }

        @Override
        public void onComplete() {
            this.done = true;
        }

        void replayNormal(ReplaySubscription<T> rs) {
            Subscriber<T> a = rs.downstream();
            int missed = 1;
            do {
                boolean d;
                long r = rs.requestedFromDownstream();
                long e = 0L;
                Node node = (Node)rs.node();
                if (node == null) {
                    node = this.head;
                }
                while (e != r) {
                    boolean empty;
                    if (rs.isCancelled()) {
                        rs.node(null);
                        return;
                    }
                    d = this.done;
                    Node next = (Node)node.get();
                    boolean bl = empty = next == null;
                    if (d && empty) {
                        rs.node(null);
                        Throwable ex = this.error;
                        if (ex != null) {
                            a.onError(ex);
                        } else {
                            a.onComplete();
                        }
                        return;
                    }
                    if (empty) break;
                    a.onNext(next.value);
                    ++e;
                    node = next;
                }
                if (e == r) {
                    boolean empty;
                    if (rs.isCancelled()) {
                        rs.node(null);
                        return;
                    }
                    d = this.done;
                    boolean bl = empty = node.get() == null;
                    if (d && empty) {
                        rs.node(null);
                        Throwable ex = this.error;
                        if (ex != null) {
                            a.onError(ex);
                        } else {
                            a.onComplete();
                        }
                        return;
                    }
                }
                if (e != 0L && r != Long.MAX_VALUE) {
                    rs.produced(e);
                }
                rs.node(node);
            } while ((missed = rs.leave(missed)) != 0);
        }

        void replayFused(ReplaySubscription<T> rs) {
            int missed = 1;
            Subscriber<T> a = rs.downstream();
            do {
                if (rs.isCancelled()) {
                    rs.node(null);
                    return;
                }
                boolean d = this.done;
                a.onNext(null);
                if (!d) continue;
                Throwable ex = this.error;
                if (ex != null) {
                    a.onError(ex);
                } else {
                    a.onComplete();
                }
                return;
            } while ((missed = rs.leave(missed)) != 0);
        }

        @Override
        public void replay(ReplaySubscription<T> rs) {
            if (!rs.enter()) {
                return;
            }
            if (rs.fusionMode() == 0) {
                this.replayNormal(rs);
            } else {
                this.replayFused(rs);
            }
        }

        @Override
        public Throwable getError() {
            return this.error;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        @Override
        public T poll(ReplaySubscription<T> rs) {
            Node next;
            Node<T> node = (Node<T>)rs.node();
            if (node == null) {
                node = this.head;
                rs.node(node);
            }
            if ((next = (Node)node.get()) == null) {
                return null;
            }
            rs.node(next);
            return next.value;
        }

        @Override
        public void clear(ReplaySubscription<T> rs) {
            rs.node(null);
        }

        @Override
        public boolean isEmpty(ReplaySubscription<T> rs) {
            Node<T> node = (Node<T>)rs.node();
            if (node == null) {
                node = this.head;
                rs.node(node);
            }
            return node.get() == null;
        }

        @Override
        public int size(ReplaySubscription<T> rs) {
            Node next;
            int count;
            Node node = (Node)rs.node();
            if (node == null) {
                node = this.head;
            }
            for (count = 0; (next = (Node)node.get()) != null && count != Integer.MAX_VALUE; ++count) {
                node = next;
            }
            return count;
        }

        @Override
        public int size() {
            Node next;
            int count;
            Node node = this.head;
            for (count = 0; (next = (Node)node.get()) != null && count != Integer.MAX_VALUE; ++count) {
                node = next;
            }
            return count;
        }

        static final class Node<T>
        extends AtomicReference<Node<T>> {
            private static final long serialVersionUID = 3713592843205853725L;
            final T value;

            public Node(T value) {
                this.value = value;
            }
        }
    }

    static final class UnboundedReplayBuffer<T>
    implements ReplayBuffer<T> {
        final int batchSize;
        volatile int size;
        final Object[] head;
        Object[] tail;
        int tailIndex;
        volatile boolean done;
        Throwable error;

        public UnboundedReplayBuffer(int batchSize) {
            this.batchSize = batchSize;
            Object[] n = new Object[batchSize + 1];
            this.tail = n;
            this.head = n;
        }

        @Override
        public Throwable getError() {
            return this.error;
        }

        @Override
        public int capacity() {
            return this.batchSize;
        }

        @Override
        public void add(T value) {
            int i = this.tailIndex;
            Object[] a = this.tail;
            if (i == a.length - 1) {
                Object[] b = new Object[a.length];
                b[0] = value;
                this.tailIndex = 1;
                a[i] = b;
                this.tail = b;
            } else {
                a[i] = value;
                this.tailIndex = i + 1;
            }
            ++this.size;
        }

        @Override
        public void onError(Throwable ex) {
            this.error = ex;
            this.done = true;
        }

        @Override
        public void onComplete() {
            this.done = true;
        }

        void replayNormal(ReplaySubscription<T> rs) {
            int missed = 1;
            Subscriber<T> a = rs.downstream();
            int n = this.batchSize;
            do {
                Throwable ex;
                boolean empty;
                boolean d;
                long r = rs.requestedFromDownstream();
                long e = 0L;
                Object[] node = (Object[])rs.node();
                if (node == null) {
                    node = this.head;
                }
                int tailIndex = rs.tailIndex();
                int index = rs.index();
                while (e != r) {
                    if (rs.isCancelled()) {
                        rs.node(null);
                        return;
                    }
                    d = this.done;
                    boolean bl = empty = index == this.size;
                    if (d && empty) {
                        rs.node(null);
                        ex = this.error;
                        if (ex != null) {
                            a.onError(ex);
                        } else {
                            a.onComplete();
                        }
                        return;
                    }
                    if (empty) break;
                    if (tailIndex == n) {
                        node = (Object[])node[tailIndex];
                        tailIndex = 0;
                    }
                    Object v = node[tailIndex];
                    a.onNext(v);
                    ++e;
                    ++tailIndex;
                    ++index;
                }
                if (e == r) {
                    if (rs.isCancelled()) {
                        rs.node(null);
                        return;
                    }
                    d = this.done;
                    boolean bl = empty = index == this.size;
                    if (d && empty) {
                        rs.node(null);
                        ex = this.error;
                        if (ex != null) {
                            a.onError(ex);
                        } else {
                            a.onComplete();
                        }
                        return;
                    }
                }
                if (e != 0L && r != Long.MAX_VALUE) {
                    rs.produced(e);
                }
                rs.index(index);
                rs.tailIndex(tailIndex);
                rs.node(node);
            } while ((missed = rs.leave(missed)) != 0);
        }

        void replayFused(ReplaySubscription<T> rs) {
            int missed = 1;
            Subscriber<T> a = rs.downstream();
            do {
                if (rs.isCancelled()) {
                    rs.node(null);
                    return;
                }
                boolean d = this.done;
                a.onNext(null);
                if (!d) continue;
                Throwable ex = this.error;
                if (ex != null) {
                    a.onError(ex);
                } else {
                    a.onComplete();
                }
                return;
            } while ((missed = rs.leave(missed)) != 0);
        }

        @Override
        public void replay(ReplaySubscription<T> rs) {
            if (!rs.enter()) {
                return;
            }
            if (rs.fusionMode() == 0) {
                this.replayNormal(rs);
            } else {
                this.replayFused(rs);
            }
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        @Override
        public T poll(ReplaySubscription<T> rs) {
            int tailIndex;
            int index = rs.index();
            if (index == this.size) {
                return null;
            }
            Object[] node = (Object[])rs.node();
            if (node == null) {
                node = this.head;
                rs.node(node);
            }
            if ((tailIndex = rs.tailIndex()) == this.batchSize) {
                node = (Object[])node[tailIndex];
                tailIndex = 0;
            }
            Object v = node[tailIndex];
            rs.index(index + 1);
            rs.tailIndex(tailIndex + 1);
            return (T)v;
        }

        @Override
        public void clear(ReplaySubscription<T> rs) {
            rs.node(null);
        }

        @Override
        public boolean isEmpty(ReplaySubscription<T> rs) {
            return rs.index() == this.size;
        }

        @Override
        public int size(ReplaySubscription<T> rs) {
            return this.size - rs.index();
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    static interface ReplayBuffer<T> {
        public void add(T var1);

        public void onError(Throwable var1);

        public Throwable getError();

        public void onComplete();

        public void replay(ReplaySubscription<T> var1);

        public boolean isDone();

        public T poll(ReplaySubscription<T> var1);

        public void clear(ReplaySubscription<T> var1);

        public boolean isEmpty(ReplaySubscription<T> var1);

        public int size(ReplaySubscription<T> var1);

        public int size();

        public int capacity();
    }
}

