/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import reactor.core.publisher.RingBuffer;

final class SequenceGroups {
    SequenceGroups() {
    }

    static <T> void addSequence(T holder, AtomicReferenceFieldUpdater<T, RingBuffer.Sequence[]> updater, RingBuffer.Sequence sequence) {
        RingBuffer.Sequence[] updatedSequences;
        RingBuffer.Sequence[] currentSequences;
        do {
            currentSequences = updater.get(holder);
            updatedSequences = Arrays.copyOf(currentSequences, currentSequences.length + 1);
            updatedSequences[currentSequences.length] = sequence;
        } while (!updater.compareAndSet(holder, currentSequences, updatedSequences));
    }

    static <T> boolean removeSequence(T holder, AtomicReferenceFieldUpdater<T, RingBuffer.Sequence[]> sequenceUpdater, RingBuffer.Sequence sequence) {
        RingBuffer.Sequence[] oldSequences;
        int numToRemove;
        while (0 != (numToRemove = SequenceGroups.countMatching(oldSequences = sequenceUpdater.get(holder), sequence))) {
            int oldSize = oldSequences.length;
            RingBuffer.Sequence[] newSequences = new RingBuffer.Sequence[oldSize - numToRemove];
            int pos = 0;
            for (int i = 0; i < oldSize; ++i) {
                RingBuffer.Sequence testSequence = oldSequences[i];
                if (sequence == testSequence) continue;
                newSequences[pos++] = testSequence;
            }
            if (!sequenceUpdater.compareAndSet(holder, oldSequences, newSequences)) continue;
        }
        return numToRemove != 0;
    }

    private static <T> int countMatching(T[] values, T toMatch) {
        int numToRemove = 0;
        for (T value : values) {
            if (value != toMatch) continue;
            ++numToRemove;
        }
        return numToRemove;
    }
}

