/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Supplier;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.Producer;
import reactor.core.Receiver;
import reactor.core.Trackable;
import reactor.core.publisher.EventLoopProcessor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Operators;
import reactor.core.publisher.RingBuffer;
import reactor.util.concurrent.QueueSupplier;
import reactor.util.concurrent.WaitStrategy;

public final class TopicProcessor<E>
extends EventLoopProcessor<E> {
    final RingBuffer.Reader barrier;
    final RingBuffer.Sequence minimum = RingBuffer.newSequence(-1L);

    public static <E> TopicProcessor<E> create() {
        return TopicProcessor.create(TopicProcessor.class.getSimpleName(), QueueSupplier.SMALL_BUFFER_SIZE, null, true);
    }

    public static <E> TopicProcessor<E> create(String name) {
        return TopicProcessor.create(name, QueueSupplier.SMALL_BUFFER_SIZE, true);
    }

    public static <E> TopicProcessor<E> create(boolean autoCancel) {
        return TopicProcessor.create(TopicProcessor.class.getSimpleName(), QueueSupplier.SMALL_BUFFER_SIZE, null, autoCancel);
    }

    public static <E> TopicProcessor<E> create(ExecutorService service) {
        return TopicProcessor.create(service, QueueSupplier.SMALL_BUFFER_SIZE, null, true);
    }

    public static <E> TopicProcessor<E> create(ExecutorService service, boolean autoCancel) {
        return TopicProcessor.create(service, QueueSupplier.SMALL_BUFFER_SIZE, null, autoCancel);
    }

    public static <E> TopicProcessor<E> create(String name, int bufferSize) {
        return TopicProcessor.create(name, bufferSize, null, true);
    }

    public static <E> TopicProcessor<E> create(String name, int bufferSize, boolean autoCancel) {
        return TopicProcessor.create(name, bufferSize, null, autoCancel);
    }

    public static <E> TopicProcessor<E> create(ExecutorService service, int bufferSize) {
        return TopicProcessor.create(service, bufferSize, WaitStrategy.liteBlocking(), true);
    }

    public static <E> TopicProcessor<E> create(ExecutorService service, int bufferSize, boolean autoCancel) {
        return TopicProcessor.create(service, bufferSize, WaitStrategy.liteBlocking(), autoCancel);
    }

    public static <E> TopicProcessor<E> create(String name, int bufferSize, WaitStrategy strategy) {
        return TopicProcessor.create(name, bufferSize, strategy, null);
    }

    public static <E> TopicProcessor<E> create(String name, int bufferSize, WaitStrategy strategy, Supplier<E> signalSupplier) {
        return new TopicProcessor<E>(name, bufferSize, strategy == null ? WaitStrategy.phasedOffLiteLock(200L, 100L, TimeUnit.MILLISECONDS) : strategy, false, true, signalSupplier);
    }

    public static <E> TopicProcessor<E> create(String name, int bufferSize, WaitStrategy strategy, boolean autoCancel) {
        return new TopicProcessor<E>(name, bufferSize, strategy == null ? WaitStrategy.phasedOffLiteLock(200L, 100L, TimeUnit.MILLISECONDS) : strategy, false, autoCancel, null);
    }

    public static <E> TopicProcessor<E> create(ExecutorService service, int bufferSize, WaitStrategy strategy) {
        return TopicProcessor.create(service, bufferSize, strategy, true);
    }

    public static <E> TopicProcessor<E> create(ExecutorService service, int bufferSize, WaitStrategy strategy, boolean autoCancel) {
        return new TopicProcessor<E>(null, service, bufferSize, strategy == null ? WaitStrategy.phasedOffLiteLock(200L, 100L, TimeUnit.MILLISECONDS) : strategy, false, autoCancel, null);
    }

    public static <E> TopicProcessor<E> share(boolean autoCancel) {
        return TopicProcessor.share(TopicProcessor.class.getSimpleName(), QueueSupplier.SMALL_BUFFER_SIZE, null, autoCancel);
    }

    public static <E> TopicProcessor<E> share(ExecutorService service) {
        return TopicProcessor.share(service, QueueSupplier.SMALL_BUFFER_SIZE, null, true);
    }

    public static <E> TopicProcessor<E> share(ExecutorService service, boolean autoCancel) {
        return TopicProcessor.share(service, QueueSupplier.SMALL_BUFFER_SIZE, null, autoCancel);
    }

    public static <E> TopicProcessor<E> share(String name, int bufferSize) {
        return TopicProcessor.share(name, bufferSize, null, true);
    }

    public static <E> TopicProcessor<E> share(String name, int bufferSize, boolean autoCancel) {
        return TopicProcessor.share(name, bufferSize, null, autoCancel);
    }

    public static <E> TopicProcessor<E> share(ExecutorService service, int bufferSize) {
        return TopicProcessor.share(service, bufferSize, null, true);
    }

    public static <E> TopicProcessor<E> share(ExecutorService service, int bufferSize, boolean autoCancel) {
        return TopicProcessor.share(service, bufferSize, null, autoCancel);
    }

    public static <E> TopicProcessor<E> share(String name, int bufferSize, WaitStrategy strategy) {
        return TopicProcessor.share(name, bufferSize, strategy, null);
    }

    public static <E> TopicProcessor<E> share(String name, int bufferSize, Supplier<E> signalSupplier) {
        return TopicProcessor.share(name, bufferSize, null, signalSupplier);
    }

    public static <E> TopicProcessor<E> share(String name, int bufferSize, WaitStrategy waitStrategy, Supplier<E> signalSupplier) {
        return new TopicProcessor<E>(name, bufferSize, waitStrategy == null ? WaitStrategy.phasedOffLiteLock(200L, 100L, TimeUnit.MILLISECONDS) : waitStrategy, true, true, signalSupplier);
    }

    public static <E> TopicProcessor<E> share(String name, int bufferSize, WaitStrategy strategy, boolean autoCancel) {
        return new TopicProcessor<E>(name, bufferSize, strategy == null ? WaitStrategy.phasedOffLiteLock(200L, 100L, TimeUnit.MILLISECONDS) : strategy, true, autoCancel, null);
    }

    public static <E> TopicProcessor<E> share(ExecutorService service, int bufferSize, WaitStrategy strategy) {
        return TopicProcessor.share(service, bufferSize, strategy, true);
    }

    public static <E> TopicProcessor<E> share(ExecutorService service, int bufferSize, WaitStrategy strategy, boolean autoCancel) {
        return new TopicProcessor<E>(null, service, bufferSize, strategy == null ? WaitStrategy.phasedOffLiteLock(200L, 100L, TimeUnit.MILLISECONDS) : strategy, true, autoCancel, null);
    }

    TopicProcessor(String name, int bufferSize, WaitStrategy waitStrategy, boolean shared, boolean autoCancel, Supplier<E> signalSupplier) {
        this(new EventLoopProcessor.EventLoopFactory(name, autoCancel), null, bufferSize, waitStrategy, shared, autoCancel, signalSupplier);
    }

    TopicProcessor(ThreadFactory threadFactory, ExecutorService executor, int bufferSize, WaitStrategy waitStrategy, boolean shared, boolean autoCancel, Supplier<E> signalSupplier) {
        super(bufferSize, threadFactory, executor, autoCancel, shared, () -> {
            EventLoopProcessor.Slot signal = new EventLoopProcessor.Slot();
            if (signalSupplier != null) {
                signal.value = signalSupplier.get();
            }
            return signal;
        }, waitStrategy);
        this.barrier = this.ringBuffer.newReader();
    }

    @Override
    public void subscribe(Subscriber<? super E> subscriber) {
        super.subscribe(subscriber);
        if (!this.alive()) {
            TopicProcessor.coldSource(this.ringBuffer, null, this.error, this.minimum).subscribe(subscriber);
            return;
        }
        RingBuffer.Sequence pendingRequest = RingBuffer.newSequence(0L);
        TopicSubscriberLoop<E> signalProcessor = new TopicSubscriberLoop<E>(this, pendingRequest, subscriber);
        if (this.incrementSubscribers()) {
            ((TopicSubscriberLoop)signalProcessor).sequence.set(this.minimum.getAsLong());
            this.ringBuffer.addGatingSequence(((TopicSubscriberLoop)signalProcessor).sequence);
        } else {
            ((TopicSubscriberLoop)signalProcessor).sequence.set(this.ringBuffer.getCursor());
            this.ringBuffer.addGatingSequence(((TopicSubscriberLoop)signalProcessor).sequence);
        }
        try {
            this.executor.execute(signalProcessor);
        }
        catch (Throwable t) {
            this.ringBuffer.removeGatingSequence(signalProcessor.getSequence());
            this.decrementSubscribers();
            if (!this.alive() && RejectedExecutionException.class.isAssignableFrom(t.getClass())) {
                TopicProcessor.coldSource(this.ringBuffer, t, this.error, this.minimum).subscribe(subscriber);
            }
            Operators.error(subscriber, t);
        }
    }

    @Override
    public Flux<E> drain() {
        return TopicProcessor.coldSource(this.ringBuffer, null, this.error, this.minimum);
    }

    @Override
    protected void doError(Throwable t) {
        this.barrier.signal();
    }

    @Override
    protected void doComplete() {
        this.barrier.signal();
    }

    @Override
    public long getPending() {
        return this.ringBuffer.getPending();
    }

    @Override
    protected void requestTask(Subscription s) {
        this.minimum.set(this.ringBuffer.getCursor());
        this.ringBuffer.addGatingSequence(this.minimum);
        new Thread(EventLoopProcessor.createRequestTask(s, () -> {
            if (!this.alive()) {
                if (this.cancelled) {
                    throw Exceptions.failWithCancel();
                }
                WaitStrategy.throwAlert();
            }
        }, this.minimum::set, () -> SUBSCRIBER_COUNT.get(this) == 0 ? this.minimum.getAsLong() : this.ringBuffer.getMinimumGatingSequence(this.minimum), this.readWait, this, this.ringBuffer.bufferSize()), this.name + "[request-task]").start();
    }

    @Override
    public long downstreamCount() {
        return this.ringBuffer.getSequenceReceivers().length - (this.isStarted() ? 1 : 0);
    }

    @Override
    public void run() {
        if (!this.alive() && SUBSCRIBER_COUNT.get(this) == 0) {
            WaitStrategy.throwAlert();
        }
    }

    private static final class TopicSubscriberLoop<T>
    implements Runnable,
    Producer,
    Receiver,
    Trackable,
    Subscription {
        private final AtomicBoolean running = new AtomicBoolean(false);
        private final RingBuffer.Sequence sequence = EventLoopProcessor.wrap(-1L, (Object)this);
        private final TopicProcessor<T> processor;
        private final RingBuffer.Sequence pendingRequest;
        private final Subscriber<? super T> subscriber;
        private final Runnable waiter = new Runnable(){

            @Override
            public void run() {
                if (!running.get() || processor.isTerminated()) {
                    WaitStrategy.throwAlert();
                }
            }
        };

        public TopicSubscriberLoop(TopicProcessor<T> processor, RingBuffer.Sequence pendingRequest, Subscriber<? super T> subscriber) {
            this.processor = processor;
            this.pendingRequest = pendingRequest;
            this.subscriber = subscriber;
        }

        public RingBuffer.Sequence getSequence() {
            return this.sequence;
        }

        public void halt() {
            this.running.set(false);
            this.processor.barrier.alert();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (!this.running.compareAndSet(false, true)) {
                    Operators.error(this.subscriber, new IllegalStateException("Thread is already running"));
                    return;
                }
                if (!this.processor.startSubscriber(this.subscriber, this)) {
                    return;
                }
                if (!EventLoopProcessor.waitRequestOrTerminalEvent(this.pendingRequest, this.processor.barrier, this.running, this.sequence, this.waiter)) {
                    if (!this.running.get()) {
                        return;
                    }
                    if (this.processor.terminated == 1) {
                        if (this.processor.ringBuffer.getAsLong() == -1L) {
                            if (this.processor.error != null) {
                                this.subscriber.onError(this.processor.error);
                                return;
                            }
                            this.subscriber.onComplete();
                            return;
                        }
                    } else if (this.processor.terminated == 2) {
                        return;
                    }
                }
                long nextSequence = this.sequence.getAsLong() + 1L;
                boolean unbounded = this.pendingRequest.getAsLong() == Long.MAX_VALUE;
                while (true) {
                    try {
                        while (true) {
                            long availableSequence = this.processor.barrier.waitFor(nextSequence, this.waiter);
                            while (nextSequence <= availableSequence) {
                                EventLoopProcessor.Slot event = (EventLoopProcessor.Slot)this.processor.ringBuffer.get(nextSequence);
                                while (!unbounded && EventLoopProcessor.getAndSub(this.pendingRequest, 1L) == 0L) {
                                    if (!this.running.get() || this.processor.isTerminated()) {
                                        WaitStrategy.throwAlert();
                                    }
                                    LockSupport.parkNanos(1L);
                                }
                                this.subscriber.onNext(event.value);
                                ++nextSequence;
                            }
                            this.sequence.set(availableSequence);
                            if (Operators.emptySubscription() == this.processor.upstreamSubscription) continue;
                            this.processor.readWait.signalAllWhenBlocking();
                        }
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                    catch (Throwable ex) {
                        if (WaitStrategy.isAlert(ex) || Exceptions.isCancel(ex)) {
                            if (!this.running.get()) {
                                break;
                            }
                            if (this.processor.terminated == 1) {
                                if (this.processor.error != null) {
                                    this.subscriber.onError(this.processor.error);
                                    break;
                                }
                                if (nextSequence > this.processor.ringBuffer.getAsLong()) {
                                    this.subscriber.onComplete();
                                    break;
                                }
                                LockSupport.parkNanos(1L);
                            } else if (this.processor.terminated == 2) {
                                break;
                            }
                            this.processor.barrier.clearAlert();
                            continue;
                        }
                        this.subscriber.onError(Operators.onOperatorError(ex));
                        this.sequence.set(nextSequence);
                        ++nextSequence;
                        continue;
                    }
                    break;
                }
            }
            finally {
                this.processor.ringBuffer.removeGatingSequence(this.sequence);
                this.processor.decrementSubscribers();
                this.running.set(false);
                this.processor.readWait.signalAllWhenBlocking();
            }
        }

        @Override
        public boolean isCancelled() {
            return !this.running.get();
        }

        @Override
        public boolean isStarted() {
            return this.sequence.getAsLong() != -1L;
        }

        @Override
        public boolean isTerminated() {
            return !this.running.get();
        }

        @Override
        public long requestedFromDownstream() {
            return this.pendingRequest.getAsLong();
        }

        @Override
        public long getPending() {
            return this.processor.ringBuffer.getCursor() - this.sequence.getAsLong();
        }

        @Override
        public long getCapacity() {
            return this.processor.getCapacity();
        }

        @Override
        public Object downstream() {
            return this.subscriber;
        }

        @Override
        public Object upstream() {
            return this.processor;
        }

        public void request(long n) {
            if (Operators.checkRequest(n, this.subscriber)) {
                if (!this.running.get()) {
                    return;
                }
                EventLoopProcessor.addCap(this.pendingRequest, n);
            }
        }

        public void cancel() {
            this.halt();
        }
    }
}

