/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.function.LongSupplier;
import reactor.core.publisher.RhsPadding;
import reactor.core.publisher.RingBuffer;
import reactor.core.publisher.Value;
import sun.misc.Unsafe;

final class UnsafeSequence
extends RhsPadding
implements RingBuffer.Sequence,
LongSupplier {
    private static final Unsafe UNSAFE = (Unsafe)RingBuffer.getUnsafe();
    private static final long VALUE_OFFSET;

    public UnsafeSequence(long initialValue) {
        UNSAFE.putOrderedLong(this, VALUE_OFFSET, initialValue);
    }

    @Override
    public long getAsLong() {
        return this.value;
    }

    @Override
    public void set(long value) {
        UNSAFE.putOrderedLong(this, VALUE_OFFSET, value);
    }

    @Override
    public void setVolatile(long value) {
        UNSAFE.putLongVolatile(this, VALUE_OFFSET, value);
    }

    @Override
    public boolean compareAndSet(long expectedValue, long newValue) {
        return UNSAFE.compareAndSwapLong(this, VALUE_OFFSET, expectedValue, newValue);
    }

    @Override
    public long incrementAndGet() {
        return this.addAndGet(1L);
    }

    @Override
    public long addAndGet(long increment) {
        long newValue;
        long currentValue;
        while (!this.compareAndSet(currentValue = this.getAsLong(), newValue = currentValue + increment)) {
        }
        return newValue;
    }

    public String toString() {
        return Long.toString(this.getAsLong());
    }

    static {
        try {
            VALUE_OFFSET = UNSAFE.objectFieldOffset(Value.class.getDeclaredField("value"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

