/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.scheduler;

import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import reactor.core.Disposable;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.core.scheduler.TimedScheduler;
import reactor.util.concurrent.OpenHashSet;

final class SingleTimedScheduler
implements TimedScheduler {
    static final AtomicLong COUNTER = new AtomicLong();
    final ScheduledThreadPoolExecutor executor;

    SingleTimedScheduler(ThreadFactory threadFactory) {
        ScheduledThreadPoolExecutor e = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(1, threadFactory);
        e.setRemoveOnCancelPolicy(true);
        this.executor = e;
    }

    @Override
    public Disposable schedule(Runnable task) {
        try {
            Future<?> f = this.executor.submit(task);
            return () -> f.cancel(false);
        }
        catch (RejectedExecutionException ex) {
            return REJECTED;
        }
    }

    @Override
    public Disposable schedule(Runnable task, long delay, TimeUnit unit) {
        try {
            ScheduledFuture<?> f = this.executor.schedule(task, delay, unit);
            return () -> f.cancel(false);
        }
        catch (RejectedExecutionException ex) {
            return REJECTED;
        }
    }

    @Override
    public Disposable schedulePeriodically(Runnable task, long initialDelay, long period, TimeUnit unit) {
        try {
            ScheduledFuture<?> f = this.executor.scheduleAtFixedRate(task, initialDelay, period, unit);
            return () -> f.cancel(false);
        }
        catch (RejectedExecutionException ex) {
            return REJECTED;
        }
    }

    @Override
    public void start() {
        throw new UnsupportedOperationException("Not supported, yet.");
    }

    @Override
    public boolean isDisposed() {
        return this.executor.isShutdown();
    }

    @Override
    public void shutdown() {
        this.dispose();
    }

    @Override
    public void dispose() {
        Schedulers.executorServiceShutdown(this.executor, "SingleTimed");
    }

    @Override
    public TimedScheduler.TimedWorker createWorker() {
        return new SingleTimedSchedulerWorker(this.executor);
    }

    static final class TimedPeriodicScheduledRunnable
    extends AtomicReference<Future<?>>
    implements Runnable,
    Disposable,
    CancelFuture {
        private static final long serialVersionUID = 2284024836904862408L;
        final Runnable task;
        final SingleTimedSchedulerWorker parent;
        volatile Thread current;
        static final AtomicReferenceFieldUpdater<TimedPeriodicScheduledRunnable, Thread> CURRENT = AtomicReferenceFieldUpdater.newUpdater(TimedPeriodicScheduledRunnable.class, Thread.class, "current");
        static final Runnable EMPTY = () -> {};
        static final Future<?> CANCELLED = new FutureTask<Object>(EMPTY, null);
        static final Future<?> FINISHED = new FutureTask<Object>(EMPTY, null);

        public TimedPeriodicScheduledRunnable(Runnable task, SingleTimedSchedulerWorker parent) {
            this.task = task;
            this.parent = parent;
        }

        @Override
        public void run() {
            block6: {
                CURRENT.lazySet(this, Thread.currentThread());
                try {
                    try {
                        this.task.run();
                    }
                    catch (Throwable ex) {
                        Future a;
                        Schedulers.handleError(ex);
                        do {
                            if ((a = (Future)this.get()) != CANCELLED) continue;
                            break block6;
                        } while (!this.compareAndSet(a, FINISHED));
                        this.parent.delete(this);
                    }
                }
                finally {
                    CURRENT.lazySet(this, null);
                }
            }
        }

        void doCancel(Future<?> a) {
            a.cancel(false);
        }

        @Override
        public void cancelFuture() {
            Future a;
            do {
                if ((a = (Future)this.get()) != FINISHED) continue;
                return;
            } while (!this.compareAndSet(a, CANCELLED));
            if (a != null) {
                this.doCancel(a);
            }
        }

        @Override
        public boolean isDisposed() {
            Future a = (Future)this.get();
            return FINISHED == a || CANCELLED == a;
        }

        @Override
        public void dispose() {
            Future a;
            do {
                if ((a = (Future)this.get()) != FINISHED) continue;
                return;
            } while (!this.compareAndSet(a, CANCELLED));
            if (a != null) {
                this.doCancel(a);
            }
            this.parent.delete(this);
        }

        void setFuture(Future<?> f) {
            do {
                Future a;
                if ((a = (Future)this.get()) == FINISHED) {
                    return;
                }
                if (a != CANCELLED) continue;
                this.doCancel(a);
                return;
            } while (!this.compareAndSet(null, f));
        }

        @Override
        public String toString() {
            return "TimedPeriodicScheduledRunnable[cancelled=" + this.get() + ", task=" + this.task + "]";
        }
    }

    static final class TimedScheduledRunnable
    extends AtomicReference<Future<?>>
    implements Runnable,
    Disposable,
    CancelFuture {
        private static final long serialVersionUID = 2284024836904862408L;
        final Runnable task;
        final SingleTimedSchedulerWorker parent;
        volatile Thread current;
        static final AtomicReferenceFieldUpdater<TimedScheduledRunnable, Thread> CURRENT = AtomicReferenceFieldUpdater.newUpdater(TimedScheduledRunnable.class, Thread.class, "current");
        static final Runnable EMPTY = () -> {};
        static final Future<?> CANCELLED_FUTURE = new FutureTask<Object>(EMPTY, null);
        static final Future<?> FINISHED = new FutureTask<Object>(EMPTY, null);

        public TimedScheduledRunnable(Runnable task, SingleTimedSchedulerWorker parent) {
            this.task = task;
            this.parent = parent;
        }

        @Override
        public void run() {
            CURRENT.lazySet(this, Thread.currentThread());
            try {
                try {
                    this.task.run();
                }
                catch (Throwable ex) {
                    Schedulers.handleError(ex);
                }
            }
            finally {
                Future a;
                while ((a = (Future)this.get()) != CANCELLED_FUTURE) {
                    if (!this.compareAndSet(a, FINISHED)) continue;
                    if (a != null) {
                        this.doCancel(a);
                    }
                    this.parent.delete(this);
                    break;
                }
                CURRENT.lazySet(this, null);
            }
        }

        void doCancel(Future<?> a) {
            a.cancel(Thread.currentThread() != this.current);
        }

        @Override
        public void cancelFuture() {
            Future a;
            do {
                if ((a = (Future)this.get()) != FINISHED) continue;
                return;
            } while (!this.compareAndSet(a, CANCELLED_FUTURE));
            if (a != null) {
                this.doCancel(a);
            }
        }

        @Override
        public void dispose() {
            Future a;
            do {
                if ((a = (Future)this.get()) != FINISHED) continue;
                return;
            } while (!this.compareAndSet(a, CANCELLED_FUTURE));
            if (a != null) {
                this.doCancel(a);
            }
            this.parent.delete(this);
        }

        void setFuture(Future<?> f) {
            do {
                Future a;
                if ((a = (Future)this.get()) == FINISHED) {
                    return;
                }
                if (a != CANCELLED_FUTURE) continue;
                this.doCancel(a);
                return;
            } while (!this.compareAndSet(null, f));
        }

        @Override
        public String toString() {
            return "TimedScheduledRunnable[cancelled=" + (this.get() == CANCELLED_FUTURE) + ", task=" + this.task + "]";
        }
    }

    static interface CancelFuture {
        public void cancelFuture();
    }

    static final class SingleTimedSchedulerWorker
    implements TimedScheduler.TimedWorker {
        final ScheduledThreadPoolExecutor executor;
        OpenHashSet<CancelFuture> tasks;
        volatile boolean terminated;

        public SingleTimedSchedulerWorker(ScheduledThreadPoolExecutor executor) {
            this.executor = executor;
            this.tasks = new OpenHashSet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Disposable schedule(Runnable task) {
            if (this.terminated) {
                return Scheduler.REJECTED;
            }
            TimedScheduledRunnable sr = new TimedScheduledRunnable(task, this);
            SingleTimedSchedulerWorker singleTimedSchedulerWorker = this;
            synchronized (singleTimedSchedulerWorker) {
                if (this.terminated) {
                    return Scheduler.REJECTED;
                }
                this.tasks.add(sr);
            }
            try {
                Future<?> f = this.executor.submit(sr);
                sr.set(f);
            }
            catch (RejectedExecutionException ex) {
                sr.dispose();
                return Scheduler.REJECTED;
            }
            return sr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void delete(CancelFuture r) {
            SingleTimedSchedulerWorker singleTimedSchedulerWorker = this;
            synchronized (singleTimedSchedulerWorker) {
                if (!this.terminated) {
                    this.tasks.remove(r);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Disposable schedule(Runnable task, long delay, TimeUnit unit) {
            if (this.terminated) {
                return Scheduler.REJECTED;
            }
            TimedScheduledRunnable sr = new TimedScheduledRunnable(task, this);
            SingleTimedSchedulerWorker singleTimedSchedulerWorker = this;
            synchronized (singleTimedSchedulerWorker) {
                if (this.terminated) {
                    return Scheduler.REJECTED;
                }
                this.tasks.add(sr);
            }
            try {
                ScheduledFuture<?> f = this.executor.schedule(sr, delay, unit);
                sr.set(f);
            }
            catch (RejectedExecutionException ex) {
                sr.dispose();
                return Scheduler.REJECTED;
            }
            return sr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Disposable schedulePeriodically(Runnable task, long initialDelay, long period, TimeUnit unit) {
            if (this.terminated) {
                return Scheduler.REJECTED;
            }
            TimedPeriodicScheduledRunnable sr = new TimedPeriodicScheduledRunnable(task, this);
            SingleTimedSchedulerWorker singleTimedSchedulerWorker = this;
            synchronized (singleTimedSchedulerWorker) {
                if (this.terminated) {
                    return Scheduler.REJECTED;
                }
                this.tasks.add(sr);
            }
            try {
                ScheduledFuture<?> f = this.executor.scheduleAtFixedRate(sr, initialDelay, period, unit);
                sr.set(f);
            }
            catch (RejectedExecutionException ex) {
                sr.dispose();
                return Scheduler.REJECTED;
            }
            return sr;
        }

        @Override
        public void shutdown() {
            this.dispose();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose() {
            OpenHashSet<CancelFuture> set;
            if (this.terminated) {
                return;
            }
            this.terminated = true;
            SingleTimedSchedulerWorker singleTimedSchedulerWorker = this;
            synchronized (singleTimedSchedulerWorker) {
                set = this.tasks;
                if (set == null) {
                    return;
                }
                this.tasks = null;
            }
            if (!set.isEmpty()) {
                Object[] keys;
                for (Object c : keys = set.keys()) {
                    if (c == null) continue;
                    ((CancelFuture)c).cancelFuture();
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.terminated;
        }
    }
}

