/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import io.micrometer.context.ContextSnapshot;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.observability.SignalListener;
import reactor.core.observability.SignalListenerFactory;
import reactor.core.publisher.ContextPropagation;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxOperator;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.InternalProducerAttr;
import reactor.core.publisher.Operators;
import reactor.core.publisher.SignalType;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

final class FluxTapRestoringThreadLocals<T, STATE>
extends FluxOperator<T, T> {
    final SignalListenerFactory<T, STATE> tapFactory;
    final STATE commonTapState;

    FluxTapRestoringThreadLocals(Flux<? extends T> source, SignalListenerFactory<T, STATE> tapFactory) {
        super(source);
        this.tapFactory = tapFactory;
        this.commonTapState = tapFactory.initializePublisherState(source);
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        Context alteredContext;
        SignalListener<T> signalListener;
        try {
            signalListener = this.tapFactory.createListener(this.source, actual.currentContext().readOnly(), this.commonTapState);
        }
        catch (Throwable generatorError) {
            Operators.error(actual, generatorError);
            return;
        }
        try {
            signalListener.doFirst();
        }
        catch (Throwable listenerError) {
            signalListener.handleListenerError(listenerError);
            Operators.error(actual, listenerError);
            return;
        }
        try {
            alteredContext = signalListener.addToContext(actual.currentContext());
        }
        catch (Throwable e) {
            IllegalStateException listenerError = new IllegalStateException("Unable to augment tap Context at subscription via addToContext", e);
            signalListener.handleListenerError(listenerError);
            Operators.error(actual, listenerError);
            return;
        }
        try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(alteredContext);){
            this.source.subscribe(new TapSubscriber<T>(actual, signalListener, alteredContext));
        }
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        if (key == InternalProducerAttr.INSTANCE) {
            return true;
        }
        return super.scanUnsafe(key);
    }

    static class TapSubscriber<T>
    implements Fuseable.ConditionalSubscriber<T>,
    InnerOperator<T, T> {
        final CoreSubscriber<? super T> actual;
        final Fuseable.ConditionalSubscriber<? super T> actualConditional;
        final Context context;
        final SignalListener<T> listener;
        boolean done;
        Subscription s;

        TapSubscriber(CoreSubscriber<? super T> actual, SignalListener<T> signalListener, Context ctx) {
            this.actual = actual;
            this.listener = signalListener;
            this.context = ctx;
            this.actualConditional = actual instanceof Fuseable.ConditionalSubscriber ? (Fuseable.ConditionalSubscriber)actual : null;
        }

        @Override
        public CoreSubscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        public Context currentContext() {
            return this.context;
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.done;
            }
            if (key == Scannable.Attr.RUN_STYLE) {
                return Scannable.Attr.RunStyle.SYNC;
            }
            if (key == InternalProducerAttr.INSTANCE) {
                return true;
            }
            return InnerOperator.super.scanUnsafe(key);
        }

        protected void handleListenerErrorPreSubscription(Throwable listenerError, Subscription toCancel) {
            toCancel.cancel();
            this.listener.handleListenerError(listenerError);
            try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(this.actual.currentContext());){
                Operators.error(this.actual, listenerError);
            }
        }

        protected void handleListenerErrorAndTerminate(Throwable listenerError) {
            this.s.cancel();
            this.listener.handleListenerError(listenerError);
            try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(this.actual.currentContext());){
                this.actual.onError(listenerError);
            }
        }

        protected void handleListenerErrorMultipleAndTerminate(Throwable listenerError, Throwable originalError) {
            this.s.cancel();
            this.listener.handleListenerError(listenerError);
            RuntimeException multiple = Exceptions.multiple(listenerError, originalError);
            try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(this.actual.currentContext());){
                this.actual.onError(multiple);
            }
        }

        protected void handleListenerErrorPostTermination(Throwable listenerError) {
            this.listener.handleListenerError(listenerError);
            Operators.onErrorDropped(listenerError, this.actual.currentContext());
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                try {
                    this.listener.doOnSubscription();
                }
                catch (Throwable observerError) {
                    this.handleListenerErrorPreSubscription(observerError, s);
                    return;
                }
                try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(this.actual.currentContext());){
                    this.actual.onSubscribe(this);
                }
            }
        }

        public void onNext(T t) {
            if (this.done) {
                try {
                    this.listener.doOnMalformedOnNext(t);
                }
                catch (Throwable observerError) {
                    this.handleListenerErrorPostTermination(observerError);
                }
                finally {
                    Operators.onNextDropped(t, this.currentContext());
                }
                return;
            }
            try {
                this.listener.doOnNext(t);
            }
            catch (Throwable observerError) {
                this.handleListenerErrorAndTerminate(observerError);
                return;
            }
            try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(this.actual.currentContext());){
                this.actual.onNext(t);
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(this.actual.currentContext());){
                if (this.actualConditional != null) {
                    if (!this.actualConditional.tryOnNext(t)) {
                        boolean bl = false;
                        return bl;
                    }
                } else {
                    this.actual.onNext(t);
                }
            }
            try {
                this.listener.doOnNext(t);
            }
            catch (Throwable listenerError) {
                this.handleListenerErrorAndTerminate(listenerError);
            }
            return true;
        }

        public void onError(Throwable t) {
            if (this.done) {
                try {
                    this.listener.doOnMalformedOnError(t);
                }
                catch (Throwable observerError) {
                    this.handleListenerErrorPostTermination(observerError);
                }
                finally {
                    Operators.onErrorDropped(t, this.currentContext());
                }
                return;
            }
            this.done = true;
            try {
                this.listener.doOnError(t);
            }
            catch (Throwable observerError) {
                this.handleListenerErrorMultipleAndTerminate(observerError, t);
                return;
            }
            try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(this.actual.currentContext());){
                this.actual.onError(t);
            }
            try {
                this.listener.doAfterError(t);
                this.listener.doFinally(SignalType.ON_ERROR);
            }
            catch (Throwable observerError) {
                this.handleListenerErrorPostTermination(observerError);
            }
        }

        public void onComplete() {
            if (this.done) {
                try {
                    this.listener.doOnMalformedOnComplete();
                }
                catch (Throwable observerError) {
                    this.handleListenerErrorPostTermination(observerError);
                }
                return;
            }
            this.done = true;
            try {
                this.listener.doOnComplete();
            }
            catch (Throwable observerError) {
                this.handleListenerErrorAndTerminate(observerError);
                return;
            }
            try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(this.actual.currentContext());){
                this.actual.onComplete();
            }
            try {
                this.listener.doAfterComplete();
                this.listener.doFinally(SignalType.ON_COMPLETE);
            }
            catch (Throwable observerError) {
                this.handleListenerErrorPostTermination(observerError);
            }
        }

        public void request(long n) {
            block20: {
                try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(this.context);){
                    if (!Operators.validate(n)) break block20;
                    try {
                        this.listener.doOnRequest(n);
                    }
                    catch (Throwable observerError) {
                        this.handleListenerErrorAndTerminate(observerError);
                        if (ignored != null) {
                            if (var4_3 != null) {
                                try {
                                    ignored.close();
                                }
                                catch (Throwable throwable) {
                                    var4_3.addSuppressed(throwable);
                                }
                            } else {
                                ignored.close();
                            }
                        }
                        return;
                    }
                    this.s.request(n);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(this.context);){
                try {
                    this.listener.doOnCancel();
                }
                catch (Throwable observerError) {
                    this.handleListenerErrorAndTerminate(observerError);
                    if (ignored != null) {
                        if (var2_2 != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable) {
                                var2_2.addSuppressed(throwable);
                            }
                        } else {
                            ignored.close();
                        }
                    }
                    return;
                }
                try {
                    this.s.cancel();
                }
                finally {
                    try {
                        this.listener.doFinally(SignalType.CANCEL);
                    }
                    catch (Throwable observerError) {
                        this.handleListenerErrorAndTerminate(observerError);
                    }
                }
            }
        }
    }
}

