/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.observability.micrometer;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.TimeUnit;
import reactor.core.observability.SignalListener;
import reactor.core.observability.micrometer.MicrometerMeterListenerConfiguration;
import reactor.core.observability.micrometer.MicrometerMeterListenerDocumentation;
import reactor.core.publisher.SignalType;
import reactor.util.annotation.Nullable;

final class MicrometerMeterListener<T>
implements SignalListener<T> {
    final MicrometerMeterListenerConfiguration configuration;
    @Nullable
    final DistributionSummary requestedCounter;
    @Nullable
    final Timer onNextIntervalTimer;
    Timer.Sample subscribeToTerminateSample;
    long lastNextEventNanos = -1L;
    boolean valued;
    static final Tags DEFAULT_TAGS_FLUX = Tags.of((String)MicrometerMeterListenerDocumentation.CommonTags.TYPE.asString(), (String)"Flux");
    static final Tags DEFAULT_TAGS_MONO = Tags.of((String)MicrometerMeterListenerDocumentation.CommonTags.TYPE.asString(), (String)"Mono");
    static final Tag TAG_ON_ERROR = Tag.of((String)MicrometerMeterListenerDocumentation.TerminationTags.STATUS.asString(), (String)"error");
    static final Tags TAG_ON_COMPLETE = Tags.of((String[])new String[]{MicrometerMeterListenerDocumentation.TerminationTags.STATUS.asString(), "completed", MicrometerMeterListenerDocumentation.TerminationTags.EXCEPTION.asString(), ""});
    static final Tags TAG_ON_COMPLETE_EMPTY = Tags.of((String[])new String[]{MicrometerMeterListenerDocumentation.TerminationTags.STATUS.asString(), "completedEmpty", MicrometerMeterListenerDocumentation.TerminationTags.EXCEPTION.asString(), ""});
    static final Tags TAG_CANCEL = Tags.of((String[])new String[]{MicrometerMeterListenerDocumentation.TerminationTags.STATUS.asString(), "cancelled", MicrometerMeterListenerDocumentation.TerminationTags.EXCEPTION.asString(), ""});

    MicrometerMeterListener(MicrometerMeterListenerConfiguration configuration) {
        this.configuration = configuration;
        this.valued = false;
        if (configuration.isMono) {
            this.onNextIntervalTimer = null;
            this.requestedCounter = null;
        } else {
            this.onNextIntervalTimer = Timer.builder((String)MicrometerMeterListenerDocumentation.ON_NEXT_DELAY.getName(new String[]{configuration.sequenceName})).tags((Iterable)configuration.commonTags).register(configuration.registry);
            this.requestedCounter = !"reactor".equals(configuration.sequenceName) ? DistributionSummary.builder((String)MicrometerMeterListenerDocumentation.REQUESTED_AMOUNT.getName(new String[]{configuration.sequenceName})).tags((Iterable)configuration.commonTags).register(configuration.registry) : null;
        }
    }

    public void doOnCancel() {
        MicrometerMeterListener.recordCancel(this.configuration.sequenceName, this.configuration.commonTags, this.configuration.registry, this.subscribeToTerminateSample);
    }

    public void doOnComplete() {
        if (!this.valued) {
            MicrometerMeterListener.recordOnCompleteEmpty(this.configuration.sequenceName, this.configuration.commonTags, this.configuration.registry, this.subscribeToTerminateSample);
        } else if (!this.configuration.isMono) {
            MicrometerMeterListener.recordOnComplete(this.configuration.sequenceName, this.configuration.commonTags, this.configuration.registry, this.subscribeToTerminateSample);
        }
    }

    public void doOnMalformedOnComplete() {
        MicrometerMeterListener.recordMalformed(this.configuration.sequenceName, this.configuration.commonTags, this.configuration.registry);
    }

    public void doOnError(Throwable e) {
        MicrometerMeterListener.recordOnError(this.configuration.sequenceName, this.configuration.commonTags, this.configuration.registry, this.subscribeToTerminateSample, e);
    }

    public void doOnMalformedOnError(Throwable e) {
        MicrometerMeterListener.recordMalformed(this.configuration.sequenceName, this.configuration.commonTags, this.configuration.registry);
    }

    public void doOnNext(T t) {
        this.valued = true;
        if (this.onNextIntervalTimer == null) {
            MicrometerMeterListener.recordOnComplete(this.configuration.sequenceName, this.configuration.commonTags, this.configuration.registry, this.subscribeToTerminateSample);
            return;
        }
        long last = this.lastNextEventNanos;
        this.lastNextEventNanos = this.configuration.registry.config().clock().monotonicTime();
        this.onNextIntervalTimer.record(this.lastNextEventNanos - last, TimeUnit.NANOSECONDS);
    }

    public void doOnMalformedOnNext(T value) {
        MicrometerMeterListener.recordMalformed(this.configuration.sequenceName, this.configuration.commonTags, this.configuration.registry);
    }

    public void doOnSubscription() {
        MicrometerMeterListener.recordOnSubscribe(this.configuration.sequenceName, this.configuration.commonTags, this.configuration.registry);
        this.subscribeToTerminateSample = Timer.start((MeterRegistry)this.configuration.registry);
        this.lastNextEventNanos = this.configuration.registry.config().clock().monotonicTime();
    }

    public void doOnRequest(long l) {
        if (this.requestedCounter != null) {
            this.requestedCounter.record((double)l);
        }
    }

    public void doFirst() {
    }

    public void doOnFusion(int negotiatedFusion) throws Throwable {
    }

    public void doFinally(SignalType terminationType) {
    }

    public void doAfterComplete() {
    }

    public void doAfterError(Throwable error) {
    }

    public void handleListenerError(Throwable listenerError) {
    }

    static void recordCancel(String name, Tags commonTags, MeterRegistry registry, Timer.Sample flowDuration) {
        Timer timer = Timer.builder((String)MicrometerMeterListenerDocumentation.FLOW_DURATION.getName(new String[]{name})).tags((Iterable)commonTags.and((Iterable)TAG_CANCEL)).description("Times the duration elapsed between a subscription and the cancellation of the sequence").register(registry);
        flowDuration.stop(timer);
    }

    static void recordMalformed(String name, Tags commonTags, MeterRegistry registry) {
        registry.counter(MicrometerMeterListenerDocumentation.MALFORMED_SOURCE_EVENTS.getName(new String[]{name}), (Iterable)commonTags).increment();
    }

    static void recordOnError(String name, Tags commonTags, MeterRegistry registry, Timer.Sample flowDuration, Throwable e) {
        Timer timer = Timer.builder((String)MicrometerMeterListenerDocumentation.FLOW_DURATION.getName(new String[]{name})).tags((Iterable)commonTags.and(new Tag[]{TAG_ON_ERROR})).tag(MicrometerMeterListenerDocumentation.TerminationTags.EXCEPTION.asString(), e.getClass().getName()).description("Times the duration elapsed between a subscription and the onError termination of the sequence, with the exception name as a tag.").register(registry);
        flowDuration.stop(timer);
    }

    static void recordOnComplete(String name, Tags commonTags, MeterRegistry registry, Timer.Sample flowDuration) {
        Timer timer = Timer.builder((String)MicrometerMeterListenerDocumentation.FLOW_DURATION.getName(new String[]{name})).tags((Iterable)commonTags.and((Iterable)TAG_ON_COMPLETE)).description("Times the duration elapsed between a subscription and the onComplete termination of a sequence that did emit some elements").register(registry);
        flowDuration.stop(timer);
    }

    static void recordOnCompleteEmpty(String name, Tags commonTags, MeterRegistry registry, Timer.Sample flowDuration) {
        Timer timer = Timer.builder((String)MicrometerMeterListenerDocumentation.FLOW_DURATION.getName(new String[]{name})).tags((Iterable)commonTags.and((Iterable)TAG_ON_COMPLETE_EMPTY)).description("Times the duration elapsed between a subscription and the onComplete termination of a sequence that didn't emit any element").register(registry);
        flowDuration.stop(timer);
    }

    static void recordOnSubscribe(String name, Tags commonTags, MeterRegistry registry) {
        Counter.builder((String)MicrometerMeterListenerDocumentation.SUBSCRIBED.getName(new String[]{name})).tags((Iterable)commonTags).register(registry).increment();
    }
}

