/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.observability.micrometer;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import java.util.function.Function;
import reactor.core.observability.SignalListener;
import reactor.core.observability.micrometer.MicrometerObservationListenerConfiguration;
import reactor.core.observability.micrometer.MicrometerObservationListenerDocumentation;
import reactor.core.publisher.SignalType;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

final class MicrometerObservationListener<T>
implements SignalListener<T> {
    private static final Logger LOGGER = Loggers.getLogger(MicrometerObservationListener.class);
    static final String CONTEXT_KEY_OBSERVATION = "micrometer.observation";
    final String completedOnNextStatus;
    final MicrometerObservationListenerConfiguration configuration;
    final ContextView originalContext;
    final Observation tapObservation;
    @Nullable
    Context contextWithObservation;
    boolean valued;

    MicrometerObservationListener(ContextView subscriberContext, MicrometerObservationListenerConfiguration configuration) {
        this(subscriberContext, configuration, null);
    }

    MicrometerObservationListener(ContextView subscriberContext, MicrometerObservationListenerConfiguration configuration, @Nullable Function<ObservationRegistry, Observation> observationSupplier) {
        this(subscriberContext, configuration, "completed", observationSupplier);
    }

    MicrometerObservationListener(ContextView subscriberContext, MicrometerObservationListenerConfiguration configuration, String completedOnNextStatus, @Nullable Function<ObservationRegistry, Observation> observationSupplier) {
        this.configuration = configuration;
        this.originalContext = subscriberContext;
        this.completedOnNextStatus = completedOnNextStatus;
        this.valued = false;
        this.tapObservation = MicrometerObservationListener.supplyOrCreateObservation(configuration, observationSupplier).lowCardinalityKeyValues(configuration.commonKeyValues);
    }

    private static Observation supplyOrCreateObservation(MicrometerObservationListenerConfiguration configuration, @Nullable Function<ObservationRegistry, Observation> observationSupplier) {
        Observation observation;
        if (observationSupplier != null && (observation = observationSupplier.apply(configuration.registry)) != null) {
            if (observation.getContext().getContextualName() != null) {
                return observation;
            }
            return observation.contextualName(configuration.sequenceName);
        }
        return Observation.createNotStarted((String)configuration.sequenceName, (ObservationRegistry)configuration.registry).contextualName(configuration.sequenceName);
    }

    public void doFirst() {
        Observation p = this.originalContext.hasKey((Object)CONTEXT_KEY_OBSERVATION) ? (Observation)this.originalContext.get((Object)CONTEXT_KEY_OBSERVATION) : this.configuration.registry.getCurrentObservation();
        Observation o = p != null ? this.tapObservation.parentObservation(p).start() : this.tapObservation.start();
        this.contextWithObservation = Context.of((ContextView)this.originalContext).put((Object)CONTEXT_KEY_OBSERVATION, (Object)o);
    }

    public Context addToContext(Context originalContext) {
        if (this.originalContext != originalContext) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("addToContext call on Observation {} with unexpected originalContext {}", new Object[]{this.tapObservation, originalContext});
            }
            return originalContext;
        }
        if (this.contextWithObservation == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("addToContext call on Observation {} before contextWithScope is set", new Object[]{this.tapObservation});
            }
            return originalContext;
        }
        return this.contextWithObservation;
    }

    public void doOnCancel() {
        Observation observation = this.tapObservation.lowCardinalityKeyValue(MicrometerObservationListenerDocumentation.ObservationTags.STATUS.asString(), "cancelled");
        observation.stop();
    }

    public void doOnComplete() {
        String status = null;
        if (!this.valued) {
            status = "completedEmpty";
        } else if (!this.configuration.isMono) {
            status = "completed";
        }
        if (status != null) {
            Observation completeObservation = this.tapObservation.lowCardinalityKeyValue(MicrometerObservationListenerDocumentation.ObservationTags.STATUS.asString(), status);
            completeObservation.stop();
        }
    }

    public void doOnError(Throwable e) {
        Observation errorObservation = this.tapObservation.lowCardinalityKeyValue(MicrometerObservationListenerDocumentation.ObservationTags.STATUS.asString(), "error").error(e);
        errorObservation.stop();
    }

    public void doOnNext(T t) {
        this.valued = true;
        if (this.configuration.isMono) {
            Observation completeObservation = this.tapObservation.lowCardinalityKeyValue(MicrometerObservationListenerDocumentation.ObservationTags.STATUS.asString(), this.completedOnNextStatus);
            completeObservation.stop();
        }
    }

    public void handleListenerError(Throwable listenerError) {
        LOGGER.error("unhandled listener error", listenerError);
    }

    public void doOnSubscription() {
    }

    public void doOnMalformedOnComplete() {
    }

    public void doOnMalformedOnError(Throwable e) {
    }

    public void doOnMalformedOnNext(T value) {
    }

    public void doOnRequest(long l) {
    }

    public void doOnFusion(int negotiatedFusion) {
    }

    public void doFinally(SignalType terminationType) {
    }

    public void doAfterComplete() {
    }

    public void doAfterError(Throwable error) {
    }
}

