/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.observability.micrometer;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import java.util.function.Function;
import reactor.core.observability.SignalListenerFactory;
import reactor.core.observability.micrometer.MicrometerMeterListenerFactory;
import reactor.core.observability.micrometer.MicrometerObservationListenerFactory;
import reactor.core.observability.micrometer.TimedScheduler;
import reactor.core.scheduler.Scheduler;

public final class Micrometer {
    public static final String DEFAULT_METER_PREFIX = "reactor";

    public static <T> SignalListenerFactory<T, ?> metrics(MeterRegistry meterRegistry) {
        return new MicrometerMeterListenerFactory(meterRegistry);
    }

    public static <T> SignalListenerFactory<T, ?> observation(ObservationRegistry registry) {
        return new MicrometerObservationListenerFactory(registry);
    }

    public static <T> SignalListenerFactory<T, ?> observation(ObservationRegistry registry, Function<ObservationRegistry, Observation> observationSupplier) {
        return new MicrometerObservationListenerFactory(registry, observationSupplier);
    }

    public static Scheduler timedScheduler(Scheduler original, MeterRegistry meterRegistry, String metricsPrefix) {
        return new TimedScheduler(original, meterRegistry, metricsPrefix, (Iterable<Tag>)Tags.empty());
    }

    public static Scheduler timedScheduler(Scheduler original, MeterRegistry meterRegistry, String metricsPrefix, Iterable<Tag> tags) {
        return new TimedScheduler(original, meterRegistry, metricsPrefix, tags);
    }
}

