/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.observability.micrometer;

import io.micrometer.common.docs.KeyName;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.docs.MeterDocumentation;

public enum MicrometerMeterListenerDocumentation implements MeterDocumentation
{
    MALFORMED_SOURCE_EVENTS{

        public KeyName[] getKeyNames() {
            return CommonTags.values();
        }

        public String getName() {
            return "%s.malformed.source";
        }

        public Meter.Type getType() {
            return Meter.Type.COUNTER;
        }
    }
    ,
    ON_NEXT_DELAY{

        public String getBaseUnit() {
            return "nanoseconds";
        }

        public KeyName[] getKeyNames() {
            return CommonTags.values();
        }

        public String getName() {
            return "%s.onNext.delay";
        }

        public Meter.Type getType() {
            return Meter.Type.TIMER;
        }
    }
    ,
    REQUESTED_AMOUNT{

        public KeyName[] getKeyNames() {
            return CommonTags.values();
        }

        public String getName() {
            return "%s.requested";
        }

        public Meter.Type getType() {
            return Meter.Type.DISTRIBUTION_SUMMARY;
        }
    }
    ,
    SUBSCRIBED{

        public KeyName[] getKeyNames() {
            return CommonTags.values();
        }

        public String getName() {
            return "%s.subscribed";
        }

        public Meter.Type getType() {
            return Meter.Type.COUNTER;
        }
    }
    ,
    FLOW_DURATION{

        public KeyName[] getKeyNames() {
            return KeyName.merge((KeyName[][])new KeyName[][]{CommonTags.values(), TerminationTags.values()});
        }

        public String getName() {
            return "%s.flow.duration";
        }

        public Meter.Type getType() {
            return Meter.Type.DISTRIBUTION_SUMMARY;
        }
    };


    public static enum TerminationTags implements KeyName
    {
        STATUS{

            public String asString() {
                return "status";
            }
        }
        ,
        EXCEPTION{

            public String asString() {
                return "exception";
            }
        };

        public static final String TAG_STATUS_CANCELLED = "cancelled";
        public static final String TAG_STATUS_COMPLETED = "completed";
        public static final String TAG_STATUS_COMPLETED_EMPTY = "completedEmpty";
        public static final String TAG_STATUS_ERROR = "error";
    }

    public static enum CommonTags implements KeyName
    {
        TYPE{

            public String asString() {
                return "type";
            }
        };

        public static final String TAG_TYPE_FLUX = "Flux";
        public static final String TAG_TYPE_MONO = "Mono";
    }
}

