/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.observability.micrometer;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import reactor.core.Disposable;
import reactor.core.observability.micrometer.TimedSchedulerMeterDocumentation;
import reactor.core.scheduler.Scheduler;

final class TimedScheduler
implements Scheduler {
    final Scheduler delegate;
    final MeterRegistry registry;
    final Counter submittedDirect;
    final Counter submittedDelayed;
    final Counter submittedPeriodicInitial;
    final Counter submittedPeriodicIteration;
    final LongTaskTimer pendingTasks;
    final LongTaskTimer activeTasks;
    final Timer completedTasks;

    TimedScheduler(Scheduler delegate, MeterRegistry registry, String metricPrefix, Iterable<Tag> tagsList) {
        this.delegate = delegate;
        this.registry = registry;
        if (metricPrefix.endsWith(".")) {
            metricPrefix = metricPrefix.substring(0, metricPrefix.length() - 1);
        }
        Tags tags = Tags.of(tagsList);
        String submittedName = TimedSchedulerMeterDocumentation.TASKS_SUBMITTED.getName(new String[]{metricPrefix});
        this.submittedDirect = registry.counter(submittedName, (Iterable)tags.and(TimedSchedulerMeterDocumentation.SubmittedTags.SUBMISSION.asString(), "direct"));
        this.submittedDelayed = registry.counter(submittedName, (Iterable)tags.and(TimedSchedulerMeterDocumentation.SubmittedTags.SUBMISSION.asString(), "delayed"));
        this.submittedPeriodicInitial = registry.counter(submittedName, (Iterable)tags.and(TimedSchedulerMeterDocumentation.SubmittedTags.SUBMISSION.asString(), "periodic_initial"));
        this.submittedPeriodicIteration = registry.counter(submittedName, (Iterable)tags.and(TimedSchedulerMeterDocumentation.SubmittedTags.SUBMISSION.asString(), "periodic_iteration"));
        this.pendingTasks = LongTaskTimer.builder((String)TimedSchedulerMeterDocumentation.TASKS_PENDING.getName(new String[]{metricPrefix})).tags((Iterable)tags).register(registry);
        this.activeTasks = LongTaskTimer.builder((String)TimedSchedulerMeterDocumentation.TASKS_ACTIVE.getName(new String[]{metricPrefix})).tags((Iterable)tags).register(registry);
        this.completedTasks = registry.timer(TimedSchedulerMeterDocumentation.TASKS_COMPLETED.getName(new String[]{metricPrefix}), (Iterable)tags);
    }

    TimedRunnable wrap(Runnable task) {
        return new TimedRunnable(this.registry, this, task);
    }

    TimedRunnable wrapPeriodic(Runnable task) {
        return new TimedRunnable(this.registry, this, task, true);
    }

    public Disposable schedule(Runnable task) {
        this.submittedDirect.increment();
        TimedRunnable timedTask = this.wrap(task);
        try {
            return this.delegate.schedule((Runnable)timedTask);
        }
        catch (RejectedExecutionException exception) {
            timedTask.pendingSample.stop();
            throw exception;
        }
    }

    public Disposable schedule(Runnable task, long delay, TimeUnit unit) {
        this.submittedDelayed.increment();
        TimedRunnable timedTask = this.wrap(task);
        try {
            return this.delegate.schedule((Runnable)timedTask, delay, unit);
        }
        catch (RejectedExecutionException exception) {
            timedTask.pendingSample.stop();
            throw exception;
        }
    }

    public Disposable schedulePeriodically(Runnable task, long initialDelay, long period, TimeUnit unit) {
        this.submittedPeriodicInitial.increment();
        return this.delegate.schedulePeriodically((Runnable)this.wrapPeriodic(task), initialDelay, period, unit);
    }

    public Scheduler.Worker createWorker() {
        return new TimedWorker(this, this.delegate.createWorker());
    }

    public boolean isDisposed() {
        return this.delegate.isDisposed();
    }

    public long now(TimeUnit unit) {
        return this.delegate.now(unit);
    }

    public void dispose() {
        this.delegate.dispose();
    }

    public void start() {
        this.delegate.start();
    }

    static final class TimedRunnable
    implements Runnable {
        final MeterRegistry registry;
        final TimedScheduler parent;
        final Runnable task;
        final LongTaskTimer.Sample pendingSample;
        boolean isRerun;

        TimedRunnable(MeterRegistry registry, TimedScheduler parent, Runnable task) {
            this(registry, parent, task, false);
        }

        TimedRunnable(MeterRegistry registry, TimedScheduler parent, Runnable task, boolean periodic) {
            this.registry = registry;
            this.parent = parent;
            this.task = task;
            this.pendingSample = periodic ? null : parent.pendingTasks.start();
            this.isRerun = false;
        }

        @Override
        public void run() {
            if (this.pendingSample != null) {
                this.pendingSample.stop();
            } else if (!this.isRerun) {
                this.isRerun = true;
            } else {
                this.parent.submittedPeriodicIteration.increment();
            }
            Runnable completionTrackingTask = this.parent.completedTasks.wrap(this.task);
            this.parent.activeTasks.record(completionTrackingTask);
        }
    }

    static final class TimedWorker
    implements Scheduler.Worker {
        final TimedScheduler parent;
        final Scheduler.Worker delegate;

        TimedWorker(TimedScheduler parent, Scheduler.Worker delegate) {
            this.parent = parent;
            this.delegate = delegate;
        }

        public void dispose() {
            this.delegate.dispose();
        }

        public boolean isDisposed() {
            return this.delegate.isDisposed();
        }

        public Disposable schedule(Runnable task) {
            this.parent.submittedDirect.increment();
            TimedRunnable timedTask = this.parent.wrap(task);
            try {
                return this.delegate.schedule((Runnable)timedTask);
            }
            catch (RejectedExecutionException exception) {
                timedTask.pendingSample.stop();
                throw exception;
            }
        }

        public Disposable schedule(Runnable task, long delay, TimeUnit unit) {
            this.parent.submittedDelayed.increment();
            TimedRunnable timedTask = this.parent.wrap(task);
            try {
                return this.delegate.schedule((Runnable)timedTask, delay, unit);
            }
            catch (RejectedExecutionException exception) {
                timedTask.pendingSample.stop();
                throw exception;
            }
        }

        public Disposable schedulePeriodically(Runnable task, long initialDelay, long period, TimeUnit unit) {
            this.parent.submittedPeriodicInitial.increment();
            return this.delegate.schedulePeriodically((Runnable)this.parent.wrapPeriodic(task), initialDelay, period, unit);
        }
    }
}

