/*
 * Decompiled with CFR 0.152.
 */
package reactor.groovy.config;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.stc.ClosureParams;
import groovy.transform.stc.SimpleType;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.reactivestreams.Processor;
import reactor.Environment;
import reactor.bus.Event;
import reactor.bus.EventBus;
import reactor.bus.filter.Filter;
import reactor.bus.filter.FirstFilter;
import reactor.bus.filter.PassThroughFilter;
import reactor.bus.filter.RandomFilter;
import reactor.bus.filter.RoundRobinFilter;
import reactor.bus.registry.Registries;
import reactor.bus.registry.Registry;
import reactor.bus.routing.Router;
import reactor.bus.selector.Selector;
import reactor.bus.selector.Selectors;
import reactor.bus.spec.EventBusSpec;
import reactor.core.Dispatcher;
import reactor.core.dispatch.SynchronousDispatcher;
import reactor.fn.Consumer;
import reactor.fn.Supplier;
import reactor.groovy.config.DSLUtils;
import reactor.groovy.config.StreamRouter;
import reactor.groovy.support.ClosureEventConsumer;
import reactor.rx.Stream;
import reactor.rx.action.Action;
import reactor.rx.action.CompositeAction;
import reactor.rx.broadcast.Broadcaster;

public class ReactorBuilder
implements Supplier<EventBus>,
GroovyObject {
    private static final Selector noSelector;
    private static final Filter DEFAULT_FILTER;
    private static final String ROUND_ROBIN = "round-robin";
    private static final String PUB_SUB = "all";
    private static final String RANDOM = "random";
    private static final String FIRST = "first";
    private Environment env;
    private Router router;
    private Dispatcher dispatcher;
    private Filter filter;
    private boolean override;
    private String dispatcherName;
    private final String name;
    private final SortedSet<SelectorProcessor> processors;
    private final Map<String, Object> ext;
    private final Map<Selector, List<Consumer>> consumers;
    private final Map<String, ReactorBuilder> reactorMap;
    private final List<ReactorBuilder> childNodes;
    private EventBus reactor;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    /*
     * WARNING - void declaration
     */
    public ReactorBuilder(String string, Map<String, ReactorBuilder> map) {
        void name;
        void reactorMap;
        MetaClass metaClass;
        List list;
        Map map2;
        Map map3;
        boolean bl;
        this.override = bl = false;
        TreeSet<SelectorProcessor> treeSet = new TreeSet<SelectorProcessor>();
        this.processors = treeSet;
        this.ext = map3 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        this.consumers = map2 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        this.childNodes = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        void var9_9 = reactorMap;
        this.reactorMap = var9_9;
        void var10_10 = name;
        this.name = var10_10;
    }

    public ReactorBuilder(String name, Map<String, ReactorBuilder> reactorMap, EventBus reactor) {
        this(name, reactorMap);
        EventBus eventBus;
        this.reactor = eventBus = reactor;
    }

    public void rehydrate(ReactorBuilder r) {
        Router router;
        String string;
        Dispatcher dispatcher;
        Filter filter;
        Filter filter2 = this.filter;
        this.filter = filter = DefaultTypeTransformation.booleanUnbox((Object)filter2) ? filter2 : r.getFilter();
        Dispatcher dispatcher2 = this.dispatcher;
        this.dispatcher = dispatcher = DefaultTypeTransformation.booleanUnbox((Object)dispatcher2) ? dispatcher2 : r.getDispatcher();
        String string2 = this.dispatcherName;
        this.dispatcherName = string = DefaultTypeTransformation.booleanUnbox((Object)string2) ? string2 : r.dispatcherName;
        Router router2 = this.router;
        this.router = router = DefaultTypeTransformation.booleanUnbox((Object)router2) ? router2 : r.getRouter();
        if (!this.override) {
            this.processors.addAll(r.processors);
            this.childNodes.addAll(r.childNodes);
        }
        Object entry = null;
        Iterator iterator = DefaultGroovyMethods.iterator(r.ext);
        while (iterator.hasNext()) {
            entry = iterator.next();
            if (!(!DefaultTypeTransformation.booleanUnbox((Object)DefaultGroovyMethods.getAt(this.ext, ((Map.Entry)ScriptBytecodeAdapter.castToType(entry, Map.Entry.class)).getKey())))) continue;
            Object v = ((Map.Entry)ScriptBytecodeAdapter.castToType(entry, Map.Entry.class)).getValue();
            DefaultGroovyMethods.putAt(this.ext, ((Map.Entry)ScriptBytecodeAdapter.castToType(entry, Map.Entry.class)).getKey(), v);
        }
    }

    public void init() {
        if (DefaultTypeTransformation.booleanUnbox((Object)this.name)) {
            ReactorBuilder r = (ReactorBuilder)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(this.reactorMap, (Object)this.name), ReactorBuilder.class);
            if (DefaultTypeTransformation.booleanUnbox((Object)r)) {
                this.rehydrate(r);
                this.addConsumersFrom(r);
            }
            ReactorBuilder reactorBuilder = this;
            DefaultGroovyMethods.putAt(this.reactorMap, (Object)this.name, (Object)reactorBuilder);
        }
    }

    public Object ext(String k) {
        return DefaultGroovyMethods.getAt(this.ext, (Object)k);
    }

    public void ext(String k, Object v) {
        Object object = v;
        DefaultGroovyMethods.putAt(this.ext, (Object)k, (Object)object);
    }

    public void exts(Map<String, Object> map) {
        this.ext.putAll(map);
    }

    public Filter routingStrategy(String strategy) {
        Filter filter;
        String string = strategy;
        if (ScriptBytecodeAdapter.isCase((Object)string, (Object)ROUND_ROBIN)) {
            RoundRobinFilter roundRobinFilter = new RoundRobinFilter();
            this.filter = roundRobinFilter;
            return roundRobinFilter;
        }
        if (ScriptBytecodeAdapter.isCase((Object)string, (Object)RANDOM)) {
            RandomFilter randomFilter = new RandomFilter();
            this.filter = randomFilter;
            return randomFilter;
        }
        if (ScriptBytecodeAdapter.isCase((Object)string, (Object)FIRST)) {
            FirstFilter firstFilter = new FirstFilter();
            this.filter = firstFilter;
            return firstFilter;
        }
        if (ScriptBytecodeAdapter.isCase((Object)string, (Object)PUB_SUB)) {
            // empty if block
        }
        this.filter = filter = DEFAULT_FILTER;
        return filter;
    }

    public ReactorBuilder dispatcher(String dispatcher) {
        Dispatcher dispatcher2;
        String string;
        this.dispatcherName = string = dispatcher;
        Environment environment = this.env;
        this.dispatcher = dispatcher2 = environment != null ? environment.getDispatcher(dispatcher) : null;
        return this;
    }

    public ReactorBuilder on(@DelegatesTo(strategy=1, value=ClosureEventConsumer.ReplyDecorator.class) Closure closure) {
        return this.on(noSelector, (Consumer)new ClosureEventConsumer((Closure)ScriptBytecodeAdapter.castToType((Object)closure.clone(), Closure.class)));
    }

    public ReactorBuilder on(String selector, @DelegatesTo(strategy=1, value=ClosureEventConsumer.ReplyDecorator.class) Closure closure) {
        return this.on(Selectors.object((Object)selector), (Consumer)new ClosureEventConsumer((Closure)ScriptBytecodeAdapter.castToType((Object)closure.clone(), Closure.class)));
    }

    public ReactorBuilder on(Consumer consumer) {
        return this.on(noSelector, consumer);
    }

    public ReactorBuilder on(String selector, Consumer closure) {
        return this.on(Selectors.object((Object)selector), closure);
    }

    public ReactorBuilder on(Selector selector, @DelegatesTo(strategy=1, value=ClosureEventConsumer.ReplyDecorator.class) Closure closure) {
        return this.on(selector, (Consumer)new ClosureEventConsumer((Closure)ScriptBytecodeAdapter.castToType((Object)closure.clone(), Closure.class)));
    }

    public ReactorBuilder on(Selector selector, Consumer closure) {
        Object object = DefaultGroovyMethods.getAt(this.consumers, (Object)selector);
        List list = (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
        List list2 = DefaultTypeTransformation.booleanUnbox((Object)object) ? list : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        DefaultGroovyMethods.putAt(this.consumers, (Object)selector, (Object)list2);
        DefaultGroovyMethods.leftShift((List)((List)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(this.consumers, (Object)selector), List.class)), (Object)closure);
        return this;
    }

    public void stream(@DelegatesTo(strategy=1, value=Stream.class) @ClosureParams(value=SimpleType.class, options={"Event"}) Closure<Action<Event<?>, Event<?>>> closure) {
        this.stream((Selector)null, closure);
    }

    public void stream(String selector, @DelegatesTo(strategy=1, value=Stream.class) @ClosureParams(value=SimpleType.class, options={"Event"}) Closure<Action<Event<?>, Event<?>>> closure) {
        this.stream(Selectors.$((Object)selector), closure);
    }

    public void stream(Selector selector, @DelegatesTo(strategy=1, value=Stream.class) @ClosureParams(value=SimpleType.class, options={"Event"}) Closure<Action<Event<?>, Event<?>>> closure) {
        Broadcaster head = Broadcaster.create((Environment)this.env, (Dispatcher)SynchronousDispatcher.INSTANCE);
        Action<Event<?>, Event<?>> action = DSLUtils.delegateFirstAndRun(head, closure);
        CompositeAction newTail = action != null ? action.combine() : null;
        if (!DefaultTypeTransformation.booleanUnbox((Object)newTail)) {
            throw (Throwable)new IllegalArgumentException("A Stream closure must return a non null reactor.rx.Action");
        }
        this.processor(selector, (Processor<?, Event>)newTail);
    }

    public void processor(String selector, Processor<?, Event> _processor) {
        this.processor(Selectors.object((Object)selector), _processor);
    }

    public void processor(Selector selector, Processor<?, Event> _processor) {
        Selector selector2 = selector;
        this.processors.add(new SelectorProcessor(this, _processor, DefaultTypeTransformation.booleanUnbox((Object)selector2) ? selector2 : Selectors.matchAll()));
    }

    public EventBus get() {
        if (DefaultTypeTransformation.booleanUnbox((Object)this.reactor)) {
            return this.reactor;
        }
        EventBusSpec spec = (EventBusSpec)ScriptBytecodeAdapter.castToType((Object)EventBus.config().env(this.env), EventBusSpec.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)this.dispatcherName)) {
            spec.dispatcher(this.dispatcherName);
        } else {
            spec.dispatcher(this.dispatcher);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.router)) {
            spec.eventRouter(this.router);
        } else if (DefaultTypeTransformation.booleanUnbox(this.processors)) {
            Registry registry = Registries.create();
            Iterator it = this.processors.iterator();
            SelectorProcessor p = null;
            while (it.hasNext()) {
                Object e = it.next();
                p = (SelectorProcessor)ScriptBytecodeAdapter.castToType(e, SelectorProcessor.class);
                registry.register(p.getSelector(), p.getProcessor());
            }
            Filter filter = this.filter;
            spec.eventRouter((Router)new StreamRouter(DefaultTypeTransformation.booleanUnbox((Object)filter) ? filter : DEFAULT_FILTER, registry));
        } else if (DefaultTypeTransformation.booleanUnbox((Object)this.filter)) {
            spec.eventFilter(this.filter);
        }
        Object object = spec.get();
        this.reactor = (EventBus)ScriptBytecodeAdapter.castToType((Object)object, EventBus.class);
        if (DefaultTypeTransformation.booleanUnbox(this.childNodes)) {
            ReactorBuilder childNode = null;
            Iterator<ReactorBuilder> iterator = this.childNodes.iterator();
            while (iterator.hasNext()) {
                childNode = (ReactorBuilder)ScriptBytecodeAdapter.castToType((Object)iterator.next(), ReactorBuilder.class);
                childNode.get();
            }
        }
        if (DefaultTypeTransformation.booleanUnbox(this.consumers)) {
            Map.Entry perSelectorConsumers = null;
            Iterator<Map.Entry<Selector, List<Consumer>>> iterator = this.consumers.entrySet().iterator();
            while (iterator.hasNext()) {
                perSelectorConsumers = (Map.Entry)ScriptBytecodeAdapter.castToType(iterator.next(), Map.Entry.class);
                Consumer consumer = null;
                Iterator iterator2 = ((List)perSelectorConsumers.getValue()).iterator();
                while (iterator2.hasNext()) {
                    consumer = (Consumer)ScriptBytecodeAdapter.castToType(iterator2.next(), Consumer.class);
                    this.reactor.on((Selector)ScriptBytecodeAdapter.castToType(perSelectorConsumers.getKey(), Selector.class), consumer);
                }
            }
        }
        return this.reactor;
    }

    public void addConsumersFrom(ReactorBuilder from) {
        Map<Selector, List<Consumer>> fromConsumers = from.consumers;
        Map.Entry consumerEntry = null;
        Object _consumerEntry = null;
        Iterator iterator = DefaultGroovyMethods.iterator(fromConsumers);
        while (iterator.hasNext()) {
            Map.Entry entry;
            _consumerEntry = iterator.next();
            consumerEntry = entry = (Map.Entry)ScriptBytecodeAdapter.castToType(_consumerEntry, Map.Entry.class);
            Consumer consumer = null;
            Iterator iterator2 = ((List)consumerEntry.getValue()).iterator();
            while (iterator2.hasNext()) {
                consumer = (Consumer)ScriptBytecodeAdapter.castToType(iterator2.next(), Consumer.class);
                this.on((Selector)ScriptBytecodeAdapter.castToType(consumerEntry.getKey(), Selector.class), consumer);
            }
        }
    }

    public ReactorBuilder reactor(@DelegatesTo(strategy=1, value=NestedReactorBuilder.class) Closure c) {
        return this.reactor(null, c);
    }

    public ReactorBuilder reactor(String reactorName, @DelegatesTo(strategy=1, value=NestedReactorBuilder.class) Closure c) {
        NestedReactorBuilder builder = new NestedReactorBuilder(this, reactorName, this, this.reactor);
        builder.init();
        DSLUtils.delegateFirstAndRun(builder, c);
        DefaultGroovyMethods.leftShift(this.childNodes, (Object)builder);
        return builder;
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ReactorBuilder.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, ReactorBuilder.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(ReactorBuilder.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public static /* synthetic */ Environment pfaccess$0(ReactorBuilder $that) {
        return $that.getEnv();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ReactorBuilder.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Selector selector;
        noSelector = selector = Selectors.anonymous();
        PassThroughFilter passThroughFilter = new PassThroughFilter();
        DEFAULT_FILTER = passThroughFilter;
    }

    public static final String getROUND_ROBIN() {
        return ROUND_ROBIN;
    }

    public static final String getPUB_SUB() {
        return PUB_SUB;
    }

    public static final String getRANDOM() {
        return RANDOM;
    }

    public static final String getFIRST() {
        return FIRST;
    }

    public Environment getEnv() {
        return this.env;
    }

    public void setEnv(Environment environment) {
        this.env = environment;
    }

    public Router getRouter() {
        return this.router;
    }

    public void setRouter(Router router) {
        this.router = router;
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void setDispatcher(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public boolean getOverride() {
        return this.override;
    }

    public boolean isOverride() {
        return this.override;
    }

    public void setOverride(boolean bl) {
        this.override = bl;
    }

    public final String getName() {
        return this.name;
    }

    public final class NestedReactorBuilder
    extends ReactorBuilder {
        public /* synthetic */ ReactorBuilder this$0;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public NestedReactorBuilder(ReactorBuilder $p$, String reactorName, ReactorBuilder parent, EventBus reactor) {
            ReactorBuilder reactorBuilder;
            this.this$0 = reactorBuilder = $p$;
            super(reactorName, parent.reactorMap, reactor);
            this.rehydrate(parent);
            Environment environment = parent.getEnv();
            this.setEnv(environment);
            ((Map)this.getProperty("consumers")).putAll(parent.consumers);
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return this.this$0.this$dist$invoke$1(name, args);
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            this.this$0.this$dist$set$1(name, val);
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return this.this$0.this$dist$get$1(name);
        }

        @Override
        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != NestedReactorBuilder.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }
    }

    public final class SelectorProcessor
    implements Comparable<SelectorProcessor>,
    GroovyObject {
        private final Processor<Event<?>, Event<?>> processor;
        private final Selector selector;
        public /* synthetic */ ReactorBuilder this$0;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        public SelectorProcessor(ReactorBuilder $p$, Processor<Event<?>, Event<?>> processor, Selector selector) {
            Selector selector2;
            MetaClass metaClass;
            ReactorBuilder reactorBuilder;
            this.this$0 = reactorBuilder = $p$;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            Processor<Event<?>, Event<?>> processor2 = processor;
            this.processor = processor2;
            this.selector = selector2 = selector;
        }

        @Override
        public int compareTo(SelectorProcessor o) {
            return DefaultTypeTransformation.booleanUnbox((Object)this.selector) ? 1 : 0;
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return this.this$0.this$dist$invoke$1(name, args);
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            this.this$0.this$dist$set$1(name, val);
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return this.this$0.this$dist$get$1(name);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != SelectorProcessor.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public final Processor<Event<?>, Event<?>> getProcessor() {
            return this.processor;
        }

        public final Selector getSelector() {
            return this.selector;
        }
    }
}

