/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.net.impl.netty.tcp;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.SocketChannelConfig;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.Environment;
import reactor.core.Dispatcher;
import reactor.core.support.NamedDaemonThreadFactory;
import reactor.io.buffer.Buffer;
import reactor.io.codec.Codec;
import reactor.io.net.ChannelStream;
import reactor.io.net.ReactorChannelHandler;
import reactor.io.net.config.ServerSocketOptions;
import reactor.io.net.config.SslOptions;
import reactor.io.net.impl.netty.NettyChannelHandlerBridge;
import reactor.io.net.impl.netty.NettyChannelStream;
import reactor.io.net.impl.netty.NettyServerSocketOptions;
import reactor.io.net.tcp.TcpServer;
import reactor.io.net.tcp.ssl.SSLEngineSupplier;
import reactor.rx.Promise;
import reactor.rx.Promises;

public class NettyTcpServer<IN, OUT>
extends TcpServer<IN, OUT> {
    private static final Logger log = LoggerFactory.getLogger(NettyTcpServer.class);
    private final NettyServerSocketOptions nettyOptions;
    private final ServerBootstrap bootstrap;
    private final EventLoopGroup selectorGroup;
    private final EventLoopGroup ioGroup;

    protected NettyTcpServer(Environment env, Dispatcher dispatcher, InetSocketAddress listenAddress, ServerSocketOptions options, SslOptions sslOptions, Codec<Buffer, IN, OUT> codec) {
        super(env, dispatcher, listenAddress, options, sslOptions, codec);
        this.nettyOptions = options instanceof NettyServerSocketOptions ? (NettyServerSocketOptions)options : null;
        int selectThreadCount = this.getDefaultEnvironment().getIntProperty("reactor.tcp.selectThreadCount", Environment.PROCESSORS / 2);
        int ioThreadCount = this.getDefaultEnvironment().getIntProperty("reactor.tcp.ioThreadCount", Environment.PROCESSORS);
        this.selectorGroup = new NioEventLoopGroup(selectThreadCount, (ThreadFactory)new NamedDaemonThreadFactory("reactor-tcp-select"));
        this.ioGroup = null != this.nettyOptions && null != this.nettyOptions.eventLoopGroup() ? this.nettyOptions.eventLoopGroup() : new NioEventLoopGroup(ioThreadCount, (ThreadFactory)new NamedDaemonThreadFactory("reactor-tcp-io"));
        this.bootstrap = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.selectorGroup, this.ioGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)options.backlog())).option(ChannelOption.SO_RCVBUF, (Object)options.rcvbuf())).option(ChannelOption.SO_SNDBUF, (Object)options.sndbuf())).option(ChannelOption.SO_REUSEADDR, (Object)options.reuseAddr())).localAddress((SocketAddress)(null == listenAddress ? new InetSocketAddress(0) : listenAddress))).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childOption(ChannelOption.AUTO_READ, (Object)(sslOptions != null ? 1 : 0));
    }

    @Override
    protected Promise<Void> doStart(final ReactorChannelHandler<IN, OUT, ChannelStream<IN, OUT>> handler) {
        this.bootstrap.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                if (NettyTcpServer.this.nettyOptions != null) {
                    SocketChannelConfig config = ch.config();
                    config.setReceiveBufferSize(NettyTcpServer.this.nettyOptions.rcvbuf());
                    config.setSendBufferSize(NettyTcpServer.this.nettyOptions.sndbuf());
                    config.setKeepAlive(NettyTcpServer.this.nettyOptions.keepAlive());
                    config.setReuseAddress(NettyTcpServer.this.nettyOptions.reuseAddr());
                    config.setSoLinger(NettyTcpServer.this.nettyOptions.linger());
                    config.setTcpNoDelay(NettyTcpServer.this.nettyOptions.tcpNoDelay());
                }
                if (log.isDebugEnabled()) {
                    log.debug("CONNECT {}", (Object)ch);
                }
                if (null != NettyTcpServer.this.getSslOptions()) {
                    SSLEngine ssl = new SSLEngineSupplier(NettyTcpServer.this.getSslOptions(), false).get();
                    if (log.isDebugEnabled()) {
                        log.debug("SSL enabled using keystore {}", (Object)(null != NettyTcpServer.this.getSslOptions().keystoreFile() ? NettyTcpServer.this.getSslOptions().keystoreFile() : "<DEFAULT>"));
                    }
                    ch.pipeline().addLast(new ChannelHandler[]{new SslHandler(ssl)});
                }
                if (null != NettyTcpServer.this.nettyOptions && null != NettyTcpServer.this.nettyOptions.pipelineConfigurer()) {
                    NettyTcpServer.this.nettyOptions.pipelineConfigurer().accept((Object)ch.pipeline());
                }
                NettyTcpServer.this.bindChannel(handler, ch);
            }
        });
        ChannelFuture bindFuture = this.bootstrap.bind();
        final Promise promise = Promises.prepare();
        bindFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                log.info("BIND {}", (Object)future.channel().localAddress());
                if (future.isSuccess()) {
                    if (NettyTcpServer.this.listenAddress.getPort() == 0) {
                        NettyTcpServer.this.listenAddress = (InetSocketAddress)future.channel().localAddress();
                    }
                    promise.onComplete();
                } else {
                    promise.onError(future.cause());
                }
            }
        });
        return promise;
    }

    @Override
    public Promise<Void> doShutdown() {
        final Promise d = Promises.prepare();
        final AtomicInteger groupsToShutdown = new AtomicInteger(2);
        GenericFutureListener listener = new GenericFutureListener(){

            public void operationComplete(Future future) throws Exception {
                if (groupsToShutdown.decrementAndGet() == 0) {
                    d.onComplete();
                }
            }
        };
        this.selectorGroup.shutdownGracefully().addListener(listener);
        if (null == this.nettyOptions || null == this.nettyOptions.eventLoopGroup()) {
            this.ioGroup.shutdownGracefully().addListener(listener);
        }
        return d;
    }

    protected void bindChannel(ReactorChannelHandler<IN, OUT, ChannelStream<IN, OUT>> handler, SocketChannel nativeChannel) {
        NettyChannelStream netChannel = new NettyChannelStream(this.getDefaultEnvironment(), this.getDefaultCodec(), this.getDefaultPrefetchSize(), this.getDefaultDispatcher(), (Channel)nativeChannel);
        ChannelPipeline pipeline = nativeChannel.pipeline();
        if (log.isDebugEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler(NettyTcpServer.class)});
        }
        pipeline.addLast(new ChannelHandler[]{new NettyChannelHandlerBridge<IN, OUT>(handler, netChannel)});
    }
}

