/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.parser;

import io.protostuff.compiler.parser.FileReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileReader
implements FileReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalFileReader.class);
    private final List<Path> pathList;

    public LocalFileReader(Path ... paths) {
        this.pathList = this.checkDirectories(Arrays.asList(paths));
    }

    public LocalFileReader(List<Path> paths) {
        this.pathList = this.checkDirectories(paths);
    }

    private List<Path> checkDirectories(List<Path> pathList) {
        ArrayList<Path> result = new ArrayList<Path>();
        for (Path path : pathList) {
            if (!Files.exists(path, new LinkOption[0])) {
                LOGGER.debug("'{}' does not exist", (Object)path);
            } else if (!Files.isDirectory(path, new LinkOption[0])) {
                LOGGER.warn("'{}' is not directory", (Object)path);
            }
            result.add(path);
        }
        return result;
    }

    @Override
    @Nullable
    public CharStream read(String name) {
        for (Path prefix : this.pathList) {
            Path path = prefix.resolve(name);
            if (!Files.isRegularFile(path, new LinkOption[0])) continue;
            try {
                byte[] bytes = Files.readAllBytes(path);
                String result = new String(bytes, StandardCharsets.UTF_8);
                return CharStreams.fromString((String)result);
            }
            catch (IOException e) {
                LOGGER.trace("Could not read {}", (Object)path, (Object)e);
            }
        }
        return null;
    }
}

