/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.cucumber5jvm.testsourcemodel;

import gherkin.AstBuilder;
import gherkin.Parser;
import gherkin.ParserException;
import gherkin.TokenMatcher;
import gherkin.ast.Examples;
import gherkin.ast.Feature;
import gherkin.ast.GherkinDocument;
import gherkin.ast.Node;
import gherkin.ast.ScenarioDefinition;
import gherkin.ast.ScenarioOutline;
import gherkin.ast.Step;
import gherkin.ast.TableRow;
import io.cucumber.plugin.event.TestSourceRead;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public final class TestSourcesModel {
    private final Map<URI, TestSourceRead> pathToReadEventMap = new HashMap<URI, TestSourceRead>();
    private final Map<URI, GherkinDocument> pathToAstMap = new HashMap<URI, GherkinDocument>();
    private final Map<URI, Map<Integer, AstNode>> pathToNodeMap = new HashMap<URI, Map<Integer, AstNode>>();

    public static ScenarioDefinition getScenarioDefinition(AstNode astNode) {
        return astNode.node instanceof ScenarioDefinition ? (ScenarioDefinition)astNode.node : (ScenarioDefinition)astNode.parent.parent.node;
    }

    public void addTestSourceReadEvent(URI path, TestSourceRead event) {
        this.pathToReadEventMap.put(path, event);
    }

    public Feature getFeature(URI path) {
        if (!this.pathToAstMap.containsKey(path)) {
            this.parseGherkinSource(path);
        }
        if (this.pathToAstMap.containsKey(path)) {
            return this.pathToAstMap.get(path).getFeature();
        }
        return null;
    }

    public AstNode getAstNode(URI path, int line) {
        if (!this.pathToNodeMap.containsKey(path)) {
            this.parseGherkinSource(path);
        }
        if (this.pathToNodeMap.containsKey(path)) {
            return this.pathToNodeMap.get(path).get(line);
        }
        return null;
    }

    private void parseGherkinSource(URI path) {
        if (!this.pathToReadEventMap.containsKey(path)) {
            return;
        }
        Parser parser = new Parser((Parser.Builder)new AstBuilder());
        TokenMatcher matcher = new TokenMatcher();
        try {
            GherkinDocument gherkinDocument = (GherkinDocument)parser.parse(this.pathToReadEventMap.get(path).getSource(), (Parser.ITokenMatcher)matcher);
            this.pathToAstMap.put(path, gherkinDocument);
            HashMap<Integer, AstNode> nodeMap = new HashMap<Integer, AstNode>();
            AstNode currentParent = new AstNode((Node)gherkinDocument.getFeature(), null);
            for (ScenarioDefinition child : gherkinDocument.getFeature().getChildren()) {
                this.processScenarioDefinition(nodeMap, child, currentParent);
            }
            this.pathToNodeMap.put(path, nodeMap);
        }
        catch (ParserException e) {
            throw new IllegalStateException("You are using a plugin that only supports till Gherkin 5.\nPlease check if the Gherkin provided follows the standard of Gherkin 5\n", e);
        }
    }

    private void processScenarioDefinition(Map<Integer, AstNode> nodeMap, ScenarioDefinition child, AstNode currentParent) {
        AstNode childNode = new AstNode((Node)child, currentParent);
        nodeMap.put(child.getLocation().getLine(), childNode);
        for (Step step : child.getSteps()) {
            nodeMap.put(step.getLocation().getLine(), TestSourcesModel.createAstNode((Node)step, childNode));
        }
        if (child instanceof ScenarioOutline) {
            this.processScenarioOutlineExamples(nodeMap, (ScenarioOutline)child, childNode);
        }
    }

    private void processScenarioOutlineExamples(Map<Integer, AstNode> nodeMap, ScenarioOutline scenarioOutline, AstNode childNode) {
        for (Examples examples : scenarioOutline.getExamples()) {
            AstNode examplesNode = TestSourcesModel.createAstNode((Node)examples, childNode);
            TableRow headerRow = examples.getTableHeader();
            AstNode headerNode = TestSourcesModel.createAstNode((Node)headerRow, examplesNode);
            nodeMap.put(headerRow.getLocation().getLine(), headerNode);
            for (int i = 0; i < examples.getTableBody().size(); ++i) {
                TableRow examplesRow = (TableRow)examples.getTableBody().get(i);
                ExamplesRowWrapperNode rowNode = TestSourcesModel.createExamplesRowWrapperNode((Node)examplesRow, i);
                AstNode expandedScenarioNode = TestSourcesModel.createAstNode(rowNode, examplesNode);
                nodeMap.put(examplesRow.getLocation().getLine(), expandedScenarioNode);
            }
        }
    }

    private static ExamplesRowWrapperNode createExamplesRowWrapperNode(Node examplesRow, int bodyRowIndex) {
        return new ExamplesRowWrapperNode(examplesRow, bodyRowIndex);
    }

    private static AstNode createAstNode(Node node, AstNode astNode) {
        return new AstNode(node, astNode);
    }

    static class AstNode {
        private final Node node;
        private final AstNode parent;

        public Node getNode() {
            return this.node;
        }

        public AstNode getParent() {
            return this.parent;
        }

        AstNode(Node node, AstNode parent) {
            this.node = node;
            this.parent = parent;
        }
    }

    static class ExamplesRowWrapperNode
    extends Node {
        private final int bodyRowIndex;

        public int getBodyRowIndex() {
            return this.bodyRowIndex;
        }

        ExamplesRowWrapperNode(Node examplesRow, int bodyRowIndex) {
            super(examplesRow.getLocation());
            this.bodyRowIndex = bodyRowIndex;
        }
    }
}

