/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.cucumber7jvm.testsourcemodel;

import io.cucumber.gherkin.Gherkin;
import io.cucumber.messages.types.Background;
import io.cucumber.messages.types.Envelope;
import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.FeatureChild;
import io.cucumber.messages.types.GherkinDocument;
import io.cucumber.messages.types.RuleChild;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.Step;
import io.cucumber.messages.types.TableRow;
import io.cucumber.plugin.event.TestSourceRead;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;

final class TestSourcesModel {
    private final Map<URI, TestSourceRead> pathToReadEventMap = new HashMap<URI, TestSourceRead>();
    private final Map<URI, GherkinDocument> pathToAstMap = new HashMap<URI, GherkinDocument>();
    private final Map<URI, Map<Long, AstNode>> pathToNodeMap = new HashMap<URI, Map<Long, AstNode>>();

    TestSourcesModel() {
    }

    public static Scenario getScenarioDefinition(AstNode astNode) {
        AstNode candidate = astNode;
        while (candidate != null && !(candidate.node instanceof Scenario)) {
            candidate = candidate.parent;
        }
        return candidate == null ? null : (Scenario)candidate.node;
    }

    public void addTestSourceReadEvent(URI path, TestSourceRead event) {
        this.pathToReadEventMap.put(path, event);
    }

    public Feature getFeature(URI path) {
        if (!this.pathToAstMap.containsKey(path)) {
            this.parseGherkinSource(path);
        }
        if (this.pathToAstMap.containsKey(path)) {
            return this.pathToAstMap.get(path).getFeature();
        }
        return null;
    }

    private void parseGherkinSource(URI path) {
        if (!this.pathToReadEventMap.containsKey(path)) {
            return;
        }
        String source = this.pathToReadEventMap.get(path).getSource();
        List<Envelope> sources = Collections.singletonList(Gherkin.makeSourceEnvelope((String)source, (String)path.toString()));
        List envelopes = Gherkin.fromSources(sources, (boolean)true, (boolean)true, (boolean)true, () -> String.valueOf(UUID.randomUUID())).collect(Collectors.toList());
        GherkinDocument gherkinDocument = envelopes.stream().map(Envelope::getGherkinDocument).filter(Objects::nonNull).findFirst().orElse(null);
        this.pathToAstMap.put(path, gherkinDocument);
        HashMap<Long, AstNode> nodeMap = new HashMap<Long, AstNode>();
        AstNode currentParent = this.createAstNode(Objects.requireNonNull(gherkinDocument).getFeature(), null);
        for (FeatureChild child : gherkinDocument.getFeature().getChildren()) {
            this.processFeatureDefinition(nodeMap, child, currentParent);
        }
        this.pathToNodeMap.put(path, nodeMap);
    }

    private void processFeatureDefinition(Map<Long, AstNode> nodeMap, FeatureChild child, AstNode currentParent) {
        if (child.getBackground() != null) {
            this.processBackgroundDefinition(nodeMap, child.getBackground(), currentParent);
        } else if (child.getScenario() != null) {
            this.processScenarioDefinition(nodeMap, child.getScenario(), currentParent);
        } else if (child.getRule() != null) {
            AstNode childNode = this.createAstNode(child.getRule(), currentParent);
            nodeMap.put(child.getRule().getLocation().getLine(), childNode);
            for (RuleChild ruleChild : child.getRule().getChildren()) {
                this.processRuleDefinition(nodeMap, ruleChild, childNode);
            }
        }
    }

    private void processBackgroundDefinition(Map<Long, AstNode> nodeMap, Background background, AstNode currentParent) {
        AstNode childNode = this.createAstNode(background, currentParent);
        nodeMap.put(background.getLocation().getLine(), childNode);
        for (Step step : background.getSteps()) {
            nodeMap.put(step.getLocation().getLine(), this.createAstNode(step, childNode));
        }
    }

    private void processScenarioDefinition(Map<Long, AstNode> nodeMap, Scenario child, AstNode currentParent) {
        AstNode childNode = this.createAstNode(child, currentParent);
        nodeMap.put(child.getLocation().getLine(), childNode);
        for (Step step : child.getSteps()) {
            nodeMap.put(step.getLocation().getLine(), this.createAstNode(step, childNode));
        }
        if (child.getExamples().size() > 0) {
            this.processScenarioOutlineExamples(nodeMap, child, childNode);
        }
    }

    private void processRuleDefinition(Map<Long, AstNode> nodeMap, RuleChild child, AstNode currentParent) {
        if (child.getBackground() != null) {
            this.processBackgroundDefinition(nodeMap, child.getBackground(), currentParent);
        } else if (child.getScenario() != null) {
            this.processScenarioDefinition(nodeMap, child.getScenario(), currentParent);
        }
    }

    private void processScenarioOutlineExamples(Map<Long, AstNode> nodeMap, Scenario scenarioOutline, AstNode parent) {
        for (Examples examples : scenarioOutline.getExamples()) {
            AstNode examplesNode = this.createAstNode(examples, parent);
            TableRow headerRow = examples.getTableHeader();
            AstNode headerNode = this.createAstNode(headerRow, examplesNode);
            nodeMap.put(headerRow.getLocation().getLine(), headerNode);
            for (int i = 0; i < examples.getTableBody().size(); ++i) {
                TableRow examplesRow = (TableRow)examples.getTableBody().get(i);
                AstNode expandedScenarioNode = this.createAstNode(examplesRow, examplesNode);
                nodeMap.put(examplesRow.getLocation().getLine(), expandedScenarioNode);
            }
        }
    }

    public AstNode getAstNode(URI path, int line) {
        if (!this.pathToNodeMap.containsKey(path)) {
            this.parseGherkinSource(path);
        }
        if (this.pathToNodeMap.containsKey(path)) {
            return this.pathToNodeMap.get(path).get(line);
        }
        return null;
    }

    private AstNode createAstNode(Object node, AstNode astNode) {
        return new AstNode(node, astNode);
    }

    private static class AstNode {
        private final Object node;
        private final AstNode parent;

        AstNode(Object node, AstNode parent) {
            this.node = node;
            this.parent = parent;
        }
    }
}

